# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.app_status import AppStatus
from koyeb.api.models.domain import Domain
from typing import Optional, Set
from typing_extensions import Self

class App(BaseModel):
    """
    App
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    started_at: Optional[datetime] = None
    succeeded_at: Optional[datetime] = None
    paused_at: Optional[datetime] = None
    resumed_at: Optional[datetime] = None
    terminated_at: Optional[datetime] = None
    status: Optional[AppStatus] = AppStatus.STARTING
    messages: Optional[List[StrictStr]] = None
    version: Optional[StrictStr] = None
    domains: Optional[List[Domain]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "organization_id", "created_at", "updated_at", "started_at", "succeeded_at", "paused_at", "resumed_at", "terminated_at", "status", "messages", "version", "domains"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of App from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in domains (list)
        _items = []
        if self.domains:
            for _item_domains in self.domains:
                if _item_domains:
                    _items.append(_item_domains.to_dict())
            _dict['domains'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of App from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "organization_id": obj.get("organization_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "started_at": obj.get("started_at"),
            "succeeded_at": obj.get("succeeded_at"),
            "paused_at": obj.get("paused_at"),
            "resumed_at": obj.get("resumed_at"),
            "terminated_at": obj.get("terminated_at"),
            "status": obj.get("status") if obj.get("status") is not None else AppStatus.STARTING,
            "messages": obj.get("messages"),
            "version": obj.get("version"),
            "domains": [Domain.from_dict(_item) for _item in obj["domains"]] if obj.get("domains") is not None else None
        })
        return _obj


