# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.database_usage import DatabaseUsage
from koyeb.api.models.service_usage import ServiceUsage
from typing import Optional, Set
from typing_extensions import Self

class AppUsage(BaseModel):
    """
    AppUsage
    """ # noqa: E501
    app_id: Optional[StrictStr] = None
    app_name: Optional[StrictStr] = None
    services: Optional[List[ServiceUsage]] = None
    databases: Optional[List[DatabaseUsage]] = None
    __properties: ClassVar[List[str]] = ["app_id", "app_name", "services", "databases"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in services (list)
        _items = []
        if self.services:
            for _item_services in self.services:
                if _item_services:
                    _items.append(_item_services.to_dict())
            _dict['services'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in databases (list)
        _items = []
        if self.databases:
            for _item_databases in self.databases:
                if _item_databases:
                    _items.append(_item_databases.to_dict())
            _dict['databases'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app_id": obj.get("app_id"),
            "app_name": obj.get("app_name"),
            "services": [ServiceUsage.from_dict(_item) for _item in obj["services"]] if obj.get("services") is not None else None,
            "databases": [DatabaseUsage.from_dict(_item) for _item in obj["databases"]] if obj.get("databases") is not None else None
        })
        return _obj


