# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from koyeb.api.models.catalog_gpu_details import CatalogGPUDetails
from typing import Optional, Set
from typing_extensions import Self

class CatalogInstance(BaseModel):
    """
    CatalogInstance
    """ # noqa: E501
    id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    vcpu: Optional[StrictInt] = Field(default=None, description="The number of cpus. Deprecated. Use vcpu_shares instead.")
    memory: Optional[StrictStr] = None
    disk: Optional[StrictStr] = None
    price_per_second: Optional[StrictStr] = None
    price_hourly: Optional[StrictStr] = None
    price_monthly: Optional[StrictStr] = None
    regions: Optional[List[StrictStr]] = None
    status: Optional[StrictStr] = None
    require_plan: Optional[List[StrictStr]] = None
    vcpu_shares: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of vcpu shares reserved for the instance.")
    display_name: Optional[StrictStr] = None
    aliases: Optional[List[StrictStr]] = None
    type: Optional[StrictStr] = None
    gpu: Optional[CatalogGPUDetails] = None
    service_types: Optional[List[StrictStr]] = None
    volumes_enabled: Optional[StrictBool] = None
    light_sleep_enabled: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "description", "vcpu", "memory", "disk", "price_per_second", "price_hourly", "price_monthly", "regions", "status", "require_plan", "vcpu_shares", "display_name", "aliases", "type", "gpu", "service_types", "volumes_enabled", "light_sleep_enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CatalogInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of gpu
        if self.gpu:
            _dict['gpu'] = self.gpu.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CatalogInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "vcpu": obj.get("vcpu"),
            "memory": obj.get("memory"),
            "disk": obj.get("disk"),
            "price_per_second": obj.get("price_per_second"),
            "price_hourly": obj.get("price_hourly"),
            "price_monthly": obj.get("price_monthly"),
            "regions": obj.get("regions"),
            "status": obj.get("status"),
            "require_plan": obj.get("require_plan"),
            "vcpu_shares": obj.get("vcpu_shares"),
            "display_name": obj.get("display_name"),
            "aliases": obj.get("aliases"),
            "type": obj.get("type"),
            "gpu": CatalogGPUDetails.from_dict(obj["gpu"]) if obj.get("gpu") is not None else None,
            "service_types": obj.get("service_types"),
            "volumes_enabled": obj.get("volumes_enabled"),
            "light_sleep_enabled": obj.get("light_sleep_enabled")
        })
        return _obj


