# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.domain_load_balancer_koyeb import DomainLoadBalancerKoyeb
from koyeb.api.models.domain_type import DomainType
from typing import Optional, Set
from typing_extensions import Self

class CreateDomain(BaseModel):
    """
    CreateDomain
    """ # noqa: E501
    name: Optional[StrictStr] = None
    type: Optional[DomainType] = DomainType.AUTOASSIGNED
    app_id: Optional[StrictStr] = None
    cloudflare: Optional[Dict[str, Any]] = None
    koyeb: Optional[DomainLoadBalancerKoyeb] = None
    __properties: ClassVar[List[str]] = ["name", "type", "app_id", "cloudflare", "koyeb"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDomain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of koyeb
        if self.koyeb:
            _dict['koyeb'] = self.koyeb.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDomain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": obj.get("type") if obj.get("type") is not None else DomainType.AUTOASSIGNED,
            "app_id": obj.get("app_id"),
            "cloudflare": obj.get("cloudflare"),
            "koyeb": DomainLoadBalancerKoyeb.from_dict(obj["koyeb"]) if obj.get("koyeb") is not None else None
        })
        return _obj


