# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.azure_container_registry_configuration import AzureContainerRegistryConfiguration
from koyeb.api.models.digital_ocean_registry_configuration import DigitalOceanRegistryConfiguration
from koyeb.api.models.docker_hub_registry_configuration import DockerHubRegistryConfiguration
from koyeb.api.models.gcp_container_registry_configuration import GCPContainerRegistryConfiguration
from koyeb.api.models.git_hub_registry_configuration import GitHubRegistryConfiguration
from koyeb.api.models.git_lab_registry_configuration import GitLabRegistryConfiguration
from koyeb.api.models.private_registry_configuration import PrivateRegistryConfiguration
from koyeb.api.models.secret_type import SecretType
from typing import Optional, Set
from typing_extensions import Self

class CreateSecret(BaseModel):
    """
    CreateSecret
    """ # noqa: E501
    name: Optional[StrictStr] = None
    type: Optional[SecretType] = SecretType.SIMPLE
    value: Optional[StrictStr] = None
    docker_hub_registry: Optional[DockerHubRegistryConfiguration] = None
    private_registry: Optional[PrivateRegistryConfiguration] = None
    digital_ocean_registry: Optional[DigitalOceanRegistryConfiguration] = None
    github_registry: Optional[GitHubRegistryConfiguration] = None
    gitlab_registry: Optional[GitLabRegistryConfiguration] = None
    gcp_container_registry: Optional[GCPContainerRegistryConfiguration] = None
    azure_container_registry: Optional[AzureContainerRegistryConfiguration] = None
    __properties: ClassVar[List[str]] = ["name", "type", "value", "docker_hub_registry", "private_registry", "digital_ocean_registry", "github_registry", "gitlab_registry", "gcp_container_registry", "azure_container_registry"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSecret from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of docker_hub_registry
        if self.docker_hub_registry:
            _dict['docker_hub_registry'] = self.docker_hub_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of private_registry
        if self.private_registry:
            _dict['private_registry'] = self.private_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of digital_ocean_registry
        if self.digital_ocean_registry:
            _dict['digital_ocean_registry'] = self.digital_ocean_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of github_registry
        if self.github_registry:
            _dict['github_registry'] = self.github_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gitlab_registry
        if self.gitlab_registry:
            _dict['gitlab_registry'] = self.gitlab_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_container_registry
        if self.gcp_container_registry:
            _dict['gcp_container_registry'] = self.gcp_container_registry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_container_registry
        if self.azure_container_registry:
            _dict['azure_container_registry'] = self.azure_container_registry.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSecret from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": obj.get("type") if obj.get("type") is not None else SecretType.SIMPLE,
            "value": obj.get("value"),
            "docker_hub_registry": DockerHubRegistryConfiguration.from_dict(obj["docker_hub_registry"]) if obj.get("docker_hub_registry") is not None else None,
            "private_registry": PrivateRegistryConfiguration.from_dict(obj["private_registry"]) if obj.get("private_registry") is not None else None,
            "digital_ocean_registry": DigitalOceanRegistryConfiguration.from_dict(obj["digital_ocean_registry"]) if obj.get("digital_ocean_registry") is not None else None,
            "github_registry": GitHubRegistryConfiguration.from_dict(obj["github_registry"]) if obj.get("github_registry") is not None else None,
            "gitlab_registry": GitLabRegistryConfiguration.from_dict(obj["gitlab_registry"]) if obj.get("gitlab_registry") is not None else None,
            "gcp_container_registry": GCPContainerRegistryConfiguration.from_dict(obj["gcp_container_registry"]) if obj.get("gcp_container_registry") is not None else None,
            "azure_container_registry": AzureContainerRegistryConfiguration.from_dict(obj["azure_container_registry"]) if obj.get("azure_container_registry") is not None else None
        })
        return _obj


