# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.credential_type import CredentialType
from typing import Optional, Set
from typing_extensions import Self

class Credential(BaseModel):
    """
    Credential
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[CredentialType] = CredentialType.INVALID
    name: Optional[StrictStr] = None
    token: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    created_at: Optional[datetime] = None
    expires_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "type", "name", "token", "description", "user_id", "organization_id", "updated_at", "created_at", "expires_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Credential from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Credential from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type") if obj.get("type") is not None else CredentialType.INVALID,
            "name": obj.get("name"),
            "token": obj.get("token"),
            "description": obj.get("description"),
            "user_id": obj.get("user_id"),
            "organization_id": obj.get("organization_id"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "expires_at": obj.get("expires_at")
        })
        return _obj


