# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.archive_deployment_metadata import ArchiveDeploymentMetadata
from koyeb.api.models.database_deployment_metadata import DatabaseDeploymentMetadata
from koyeb.api.models.deployment_proxy_port_metadata import DeploymentProxyPortMetadata
from koyeb.api.models.git_deployment_metadata import GitDeploymentMetadata
from koyeb.api.models.trigger_deployment_metadata import TriggerDeploymentMetadata
from typing import Optional, Set
from typing_extensions import Self

class DeploymentMetadata(BaseModel):
    """
    DeploymentMetadata
    """ # noqa: E501
    trigger: Optional[TriggerDeploymentMetadata] = None
    database: Optional[DatabaseDeploymentMetadata] = None
    git: Optional[GitDeploymentMetadata] = None
    archive: Optional[ArchiveDeploymentMetadata] = None
    proxy_ports: Optional[List[DeploymentProxyPortMetadata]] = None
    __properties: ClassVar[List[str]] = ["trigger", "database", "git", "archive", "proxy_ports"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of trigger
        if self.trigger:
            _dict['trigger'] = self.trigger.to_dict()
        # override the default output from pydantic by calling `to_dict()` of database
        if self.database:
            _dict['database'] = self.database.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git
        if self.git:
            _dict['git'] = self.git.to_dict()
        # override the default output from pydantic by calling `to_dict()` of archive
        if self.archive:
            _dict['archive'] = self.archive.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in proxy_ports (list)
        _items = []
        if self.proxy_ports:
            for _item_proxy_ports in self.proxy_ports:
                if _item_proxy_ports:
                    _items.append(_item_proxy_ports.to_dict())
            _dict['proxy_ports'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trigger": TriggerDeploymentMetadata.from_dict(obj["trigger"]) if obj.get("trigger") is not None else None,
            "database": DatabaseDeploymentMetadata.from_dict(obj["database"]) if obj.get("database") is not None else None,
            "git": GitDeploymentMetadata.from_dict(obj["git"]) if obj.get("git") is not None else None,
            "archive": ArchiveDeploymentMetadata.from_dict(obj["archive"]) if obj.get("archive") is not None else None,
            "proxy_ports": [DeploymentProxyPortMetadata.from_dict(_item) for _item in obj["proxy_ports"]] if obj.get("proxy_ports") is not None else None
        })
        return _obj


