# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.deployment_provisioning_info_stage_build_attempt_build_step import DeploymentProvisioningInfoStageBuildAttemptBuildStep
from koyeb.api.models.deployment_provisioning_info_stage_status import DeploymentProvisioningInfoStageStatus
from typing import Optional, Set
from typing_extensions import Self

class DeploymentProvisioningInfoStageBuildAttempt(BaseModel):
    """
    DeploymentProvisioningInfoStageBuildAttempt
    """ # noqa: E501
    id: Optional[StrictInt] = None
    status: Optional[DeploymentProvisioningInfoStageStatus] = DeploymentProvisioningInfoStageStatus.UNKNOWN
    messages: Optional[List[StrictStr]] = None
    started_at: Optional[datetime] = None
    finished_at: Optional[datetime] = None
    steps: Optional[List[DeploymentProvisioningInfoStageBuildAttemptBuildStep]] = None
    image_pushed: Optional[StrictBool] = None
    internal_failure: Optional[StrictBool] = None
    retryable_failure: Optional[StrictBool] = None
    wait_completion: Optional[StrictBool] = Field(default=None, description="This flag is used to finalize the build, and continue the deployment in case of success, or cancel and potentially retry the build in case of failure.")
    __properties: ClassVar[List[str]] = ["id", "status", "messages", "started_at", "finished_at", "steps", "image_pushed", "internal_failure", "retryable_failure", "wait_completion"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentProvisioningInfoStageBuildAttempt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item_steps in self.steps:
                if _item_steps:
                    _items.append(_item_steps.to_dict())
            _dict['steps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentProvisioningInfoStageBuildAttempt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status") if obj.get("status") is not None else DeploymentProvisioningInfoStageStatus.UNKNOWN,
            "messages": obj.get("messages"),
            "started_at": obj.get("started_at"),
            "finished_at": obj.get("finished_at"),
            "steps": [DeploymentProvisioningInfoStageBuildAttemptBuildStep.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "image_pushed": obj.get("image_pushed"),
            "internal_failure": obj.get("internal_failure"),
            "retryable_failure": obj.get("retryable_failure"),
            "wait_completion": obj.get("wait_completion")
        })
        return _obj


