# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.deployment_scaling_target_average_cpu import DeploymentScalingTargetAverageCPU
from koyeb.api.models.deployment_scaling_target_average_mem import DeploymentScalingTargetAverageMem
from koyeb.api.models.deployment_scaling_target_concurrent_requests import DeploymentScalingTargetConcurrentRequests
from koyeb.api.models.deployment_scaling_target_requests_per_second import DeploymentScalingTargetRequestsPerSecond
from koyeb.api.models.deployment_scaling_target_requests_response_time import DeploymentScalingTargetRequestsResponseTime
from koyeb.api.models.deployment_scaling_target_sleep_idle_delay import DeploymentScalingTargetSleepIdleDelay
from typing import Optional, Set
from typing_extensions import Self

class DeploymentScalingTarget(BaseModel):
    """
    DeploymentScalingTarget
    """ # noqa: E501
    average_cpu: Optional[DeploymentScalingTargetAverageCPU] = None
    average_mem: Optional[DeploymentScalingTargetAverageMem] = None
    requests_per_second: Optional[DeploymentScalingTargetRequestsPerSecond] = None
    concurrent_requests: Optional[DeploymentScalingTargetConcurrentRequests] = None
    requests_response_time: Optional[DeploymentScalingTargetRequestsResponseTime] = None
    sleep_idle_delay: Optional[DeploymentScalingTargetSleepIdleDelay] = None
    __properties: ClassVar[List[str]] = ["average_cpu", "average_mem", "requests_per_second", "concurrent_requests", "requests_response_time", "sleep_idle_delay"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentScalingTarget from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of average_cpu
        if self.average_cpu:
            _dict['average_cpu'] = self.average_cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of average_mem
        if self.average_mem:
            _dict['average_mem'] = self.average_mem.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requests_per_second
        if self.requests_per_second:
            _dict['requests_per_second'] = self.requests_per_second.to_dict()
        # override the default output from pydantic by calling `to_dict()` of concurrent_requests
        if self.concurrent_requests:
            _dict['concurrent_requests'] = self.concurrent_requests.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requests_response_time
        if self.requests_response_time:
            _dict['requests_response_time'] = self.requests_response_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sleep_idle_delay
        if self.sleep_idle_delay:
            _dict['sleep_idle_delay'] = self.sleep_idle_delay.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentScalingTarget from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "average_cpu": DeploymentScalingTargetAverageCPU.from_dict(obj["average_cpu"]) if obj.get("average_cpu") is not None else None,
            "average_mem": DeploymentScalingTargetAverageMem.from_dict(obj["average_mem"]) if obj.get("average_mem") is not None else None,
            "requests_per_second": DeploymentScalingTargetRequestsPerSecond.from_dict(obj["requests_per_second"]) if obj.get("requests_per_second") is not None else None,
            "concurrent_requests": DeploymentScalingTargetConcurrentRequests.from_dict(obj["concurrent_requests"]) if obj.get("concurrent_requests") is not None else None,
            "requests_response_time": DeploymentScalingTargetRequestsResponseTime.from_dict(obj["requests_response_time"]) if obj.get("requests_response_time") is not None else None,
            "sleep_idle_delay": DeploymentScalingTargetSleepIdleDelay.from_dict(obj["sleep_idle_delay"]) if obj.get("sleep_idle_delay") is not None else None
        })
        return _obj


