# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.exec_command_io import ExecCommandIO
from typing import Optional, Set
from typing_extensions import Self

class ExecCommandReply(BaseModel):
    """
    ExecCommandReply
    """ # noqa: E501
    stdout: Optional[ExecCommandIO] = None
    stderr: Optional[ExecCommandIO] = None
    exited: Optional[StrictBool] = None
    exit_code: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["stdout", "stderr", "exited", "exit_code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecCommandReply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stdout
        if self.stdout:
            _dict['stdout'] = self.stdout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stderr
        if self.stderr:
            _dict['stderr'] = self.stderr.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecCommandReply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "stdout": ExecCommandIO.from_dict(obj["stdout"]) if obj.get("stdout") is not None else None,
            "stderr": ExecCommandIO.from_dict(obj["stderr"]) if obj.get("stderr") is not None else None,
            "exited": obj.get("exited"),
            "exit_code": obj.get("exit_code")
        })
        return _obj


