# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.exec_command_io import ExecCommandIO
from koyeb.api.models.exec_command_request_terminal_size import ExecCommandRequestTerminalSize
from typing import Optional, Set
from typing_extensions import Self

class ExecCommandRequestBody(BaseModel):
    """
    ExecCommandRequestBody
    """ # noqa: E501
    command: Optional[List[StrictStr]] = Field(default=None, description="Command to exec. Mandatory in the first frame sent")
    tty_size: Optional[ExecCommandRequestTerminalSize] = None
    stdin: Optional[ExecCommandIO] = None
    disable_tty: Optional[StrictBool] = Field(default=None, description="Disable TTY. It's enough to specify it in the first frame", alias="disableTty")
    __properties: ClassVar[List[str]] = ["command", "tty_size", "stdin", "disableTty"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecCommandRequestBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tty_size
        if self.tty_size:
            _dict['tty_size'] = self.tty_size.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stdin
        if self.stdin:
            _dict['stdin'] = self.stdin.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecCommandRequestBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "command": obj.get("command"),
            "tty_size": ExecCommandRequestTerminalSize.from_dict(obj["tty_size"]) if obj.get("tty_size") is not None else None,
            "stdin": ExecCommandIO.from_dict(obj["stdin"]) if obj.get("stdin") is not None else None,
            "disableTty": obj.get("disableTty")
        })
        return _obj


