# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.kgitproxy_github_installation_status import KgitproxyGithubInstallationStatus
from koyeb.api.models.kgitproxy_indexing_status import KgitproxyIndexingStatus
from typing import Optional, Set
from typing_extensions import Self

class GetGithubInstallationReply(BaseModel):
    """
    GetGithubInstallationReply
    """ # noqa: E501
    installation_id: Optional[StrictStr] = None
    installation_url: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    avatar_url: Optional[StrictStr] = None
    status: Optional[KgitproxyGithubInstallationStatus] = KgitproxyGithubInstallationStatus.INVALID
    installed_at: Optional[datetime] = None
    suspended_at: Optional[datetime] = None
    indexing_status: Optional[KgitproxyIndexingStatus] = KgitproxyIndexingStatus.INVALID_INDEXING_STATUS
    indexed_repositories: Optional[StrictInt] = None
    total_repositories: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["installation_id", "installation_url", "name", "avatar_url", "status", "installed_at", "suspended_at", "indexing_status", "indexed_repositories", "total_repositories"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetGithubInstallationReply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetGithubInstallationReply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "installation_id": obj.get("installation_id"),
            "installation_url": obj.get("installation_url"),
            "name": obj.get("name"),
            "avatar_url": obj.get("avatar_url"),
            "status": obj.get("status") if obj.get("status") is not None else KgitproxyGithubInstallationStatus.INVALID,
            "installed_at": obj.get("installed_at"),
            "suspended_at": obj.get("suspended_at"),
            "indexing_status": obj.get("indexing_status") if obj.get("indexing_status") is not None else KgitproxyIndexingStatus.INVALID_INDEXING_STATUS,
            "indexed_repositories": obj.get("indexed_repositories"),
            "total_repositories": obj.get("total_repositories")
        })
        return _obj


