# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.database_usage_details import DatabaseUsageDetails
from koyeb.api.models.usage_details import UsageDetails
from typing import Optional, Set
from typing_extensions import Self

class GetOrganizationUsageDetailsReply(BaseModel):
    """
    GetOrganizationUsageDetailsReply
    """ # noqa: E501
    usage_details: Optional[List[UsageDetails]] = None
    database_details: Optional[List[DatabaseUsageDetails]] = None
    limit: Optional[StrictInt] = None
    offset: Optional[StrictInt] = None
    count: Optional[StrictInt] = None
    order: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["usage_details", "database_details", "limit", "offset", "count", "order"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetOrganizationUsageDetailsReply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in usage_details (list)
        _items = []
        if self.usage_details:
            for _item_usage_details in self.usage_details:
                if _item_usage_details:
                    _items.append(_item_usage_details.to_dict())
            _dict['usage_details'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in database_details (list)
        _items = []
        if self.database_details:
            for _item_database_details in self.database_details:
                if _item_database_details:
                    _items.append(_item_database_details.to_dict())
            _dict['database_details'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetOrganizationUsageDetailsReply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "usage_details": [UsageDetails.from_dict(_item) for _item in obj["usage_details"]] if obj.get("usage_details") is not None else None,
            "database_details": [DatabaseUsageDetails.from_dict(_item) for _item in obj["database_details"]] if obj.get("database_details") is not None else None,
            "limit": obj.get("limit"),
            "offset": obj.get("offset"),
            "count": obj.get("count"),
            "order": obj.get("order")
        })
        return _obj


