# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.instance_status import InstanceStatus
from typing import Optional, Set
from typing_extensions import Self

class InstanceListItem(BaseModel):
    """
    InstanceListItem
    """ # noqa: E501
    id: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    organization_id: Optional[StrictStr] = None
    app_id: Optional[StrictStr] = None
    service_id: Optional[StrictStr] = None
    regional_deployment_id: Optional[StrictStr] = None
    allocation_id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    replica_index: Optional[StrictInt] = None
    region: Optional[StrictStr] = None
    datacenter: Optional[StrictStr] = None
    status: Optional[InstanceStatus] = InstanceStatus.ALLOCATING
    messages: Optional[List[StrictStr]] = None
    xyz_deployment_id: Optional[StrictStr] = Field(default=None, description="WARNING: Please don't use the following attribute. Koyeb doesn't guarantee backwards compatible breaking change and reserve the right to completely drop it without notice. USE AT YOUR OWN RISK.")
    __properties: ClassVar[List[str]] = ["id", "created_at", "updated_at", "organization_id", "app_id", "service_id", "regional_deployment_id", "allocation_id", "type", "replica_index", "region", "datacenter", "status", "messages", "xyz_deployment_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "organization_id": obj.get("organization_id"),
            "app_id": obj.get("app_id"),
            "service_id": obj.get("service_id"),
            "regional_deployment_id": obj.get("regional_deployment_id"),
            "allocation_id": obj.get("allocation_id"),
            "type": obj.get("type"),
            "replica_index": obj.get("replica_index"),
            "region": obj.get("region"),
            "datacenter": obj.get("datacenter"),
            "status": obj.get("status") if obj.get("status") is not None else InstanceStatus.ALLOCATING,
            "messages": obj.get("messages"),
            "xyz_deployment_id": obj.get("xyz_deployment_id")
        })
        return _obj


