# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.kgitproxy_git_hub_repository import KgitproxyGitHubRepository
from koyeb.api.models.kgitproxy_repository_provider import KgitproxyRepositoryProvider
from typing import Optional, Set
from typing_extensions import Self

class KgitproxyRepository(BaseModel):
    """
    KgitproxyRepository
    """ # noqa: E501
    id: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    is_private: Optional[StrictBool] = None
    is_disabled: Optional[StrictBool] = None
    default_branch: Optional[StrictStr] = None
    provider: Optional[KgitproxyRepositoryProvider] = KgitproxyRepositoryProvider.INVALID_PROVIDER
    last_push_date: Optional[datetime] = None
    github: Optional[KgitproxyGitHubRepository] = None
    __properties: ClassVar[List[str]] = ["id", "organization_id", "name", "url", "description", "is_private", "is_disabled", "default_branch", "provider", "last_push_date", "github"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KgitproxyRepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of github
        if self.github:
            _dict['github'] = self.github.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KgitproxyRepository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organization_id": obj.get("organization_id"),
            "name": obj.get("name"),
            "url": obj.get("url"),
            "description": obj.get("description"),
            "is_private": obj.get("is_private"),
            "is_disabled": obj.get("is_disabled"),
            "default_branch": obj.get("default_branch"),
            "provider": obj.get("provider") if obj.get("provider") is not None else KgitproxyRepositoryProvider.INVALID_PROVIDER,
            "last_push_date": obj.get("last_push_date"),
            "github": KgitproxyGitHubRepository.from_dict(obj["github"]) if obj.get("github") is not None else None
        })
        return _obj


