# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.organization_deactivation_reason import OrganizationDeactivationReason
from koyeb.api.models.organization_detailed_status import OrganizationDetailedStatus
from koyeb.api.models.organization_status import OrganizationStatus
from koyeb.api.models.plan import Plan
from typing import Optional, Set
from typing_extensions import Self

class Organization(BaseModel):
    """
    Organization
    """ # noqa: E501
    id: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = None
    provisioning: Optional[StrictBool] = None
    address1: Optional[StrictStr] = None
    address2: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    postal_code: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    company: Optional[StrictBool] = None
    vat_number: Optional[StrictStr] = None
    billing_name: Optional[StrictStr] = None
    billing_email: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    plan: Optional[Plan] = Plan.HOBBY
    plan_updated_at: Optional[datetime] = None
    has_payment_method: Optional[StrictBool] = None
    subscription_id: Optional[StrictStr] = None
    current_subscription_id: Optional[StrictStr] = None
    latest_subscription_id: Optional[StrictStr] = None
    signup_qualification: Optional[Dict[str, Any]] = None
    status: Optional[OrganizationStatus] = OrganizationStatus.WARNING
    status_message: Optional[OrganizationDetailedStatus] = OrganizationDetailedStatus.NEW
    deactivation_reason: Optional[OrganizationDeactivationReason] = OrganizationDeactivationReason.INVALID
    verified: Optional[StrictBool] = None
    qualifies_for_hobby23: Optional[StrictBool] = None
    reprocess_after: Optional[datetime] = None
    trialing: Optional[StrictBool] = None
    trial_starts_at: Optional[datetime] = None
    trial_ends_at: Optional[datetime] = None
    email_domain_allowlist: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "external_id", "provisioning", "address1", "address2", "city", "postal_code", "state", "country", "company", "vat_number", "billing_name", "billing_email", "name", "plan", "plan_updated_at", "has_payment_method", "subscription_id", "current_subscription_id", "latest_subscription_id", "signup_qualification", "status", "status_message", "deactivation_reason", "verified", "qualifies_for_hobby23", "reprocess_after", "trialing", "trial_starts_at", "trial_ends_at", "email_domain_allowlist"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "external_id": obj.get("external_id"),
            "provisioning": obj.get("provisioning"),
            "address1": obj.get("address1"),
            "address2": obj.get("address2"),
            "city": obj.get("city"),
            "postal_code": obj.get("postal_code"),
            "state": obj.get("state"),
            "country": obj.get("country"),
            "company": obj.get("company"),
            "vat_number": obj.get("vat_number"),
            "billing_name": obj.get("billing_name"),
            "billing_email": obj.get("billing_email"),
            "name": obj.get("name"),
            "plan": obj.get("plan") if obj.get("plan") is not None else Plan.HOBBY,
            "plan_updated_at": obj.get("plan_updated_at"),
            "has_payment_method": obj.get("has_payment_method"),
            "subscription_id": obj.get("subscription_id"),
            "current_subscription_id": obj.get("current_subscription_id"),
            "latest_subscription_id": obj.get("latest_subscription_id"),
            "signup_qualification": obj.get("signup_qualification"),
            "status": obj.get("status") if obj.get("status") is not None else OrganizationStatus.WARNING,
            "status_message": obj.get("status_message") if obj.get("status_message") is not None else OrganizationDetailedStatus.NEW,
            "deactivation_reason": obj.get("deactivation_reason") if obj.get("deactivation_reason") is not None else OrganizationDeactivationReason.INVALID,
            "verified": obj.get("verified"),
            "qualifies_for_hobby23": obj.get("qualifies_for_hobby23"),
            "reprocess_after": obj.get("reprocess_after"),
            "trialing": obj.get("trialing"),
            "trial_starts_at": obj.get("trial_starts_at"),
            "trial_ends_at": obj.get("trial_ends_at"),
            "email_domain_allowlist": obj.get("email_domain_allowlist")
        })
        return _obj


