# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.payment_method_status import PaymentMethodStatus
from typing import Optional, Set
from typing_extensions import Self

class PaymentMethod(BaseModel):
    """
    PaymentMethod
    """ # noqa: E501
    id: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    version: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    provider: Optional[StrictStr] = None
    status: Optional[PaymentMethodStatus] = PaymentMethodStatus.INVALID
    messages: Optional[List[StrictStr]] = None
    stripe_payment_method_id: Optional[StrictStr] = None
    authorization_verified_at: Optional[datetime] = None
    authorization_canceled_at: Optional[datetime] = None
    authorization_stripe_payment_intent_id: Optional[StrictStr] = None
    authorization_stripe_payment_intent_client_secret: Optional[StrictStr] = None
    card_brand: Optional[StrictStr] = None
    card_country: Optional[StrictStr] = None
    card_funding: Optional[StrictStr] = None
    card_fingerprint: Optional[StrictStr] = None
    card_last_digits: Optional[StrictStr] = None
    card_expiration_month: Optional[StrictInt] = None
    card_expiration_year: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["id", "created_at", "updated_at", "version", "organization_id", "type", "provider", "status", "messages", "stripe_payment_method_id", "authorization_verified_at", "authorization_canceled_at", "authorization_stripe_payment_intent_id", "authorization_stripe_payment_intent_client_secret", "card_brand", "card_country", "card_funding", "card_fingerprint", "card_last_digits", "card_expiration_month", "card_expiration_year"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentMethod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentMethod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "version": obj.get("version"),
            "organization_id": obj.get("organization_id"),
            "type": obj.get("type"),
            "provider": obj.get("provider"),
            "status": obj.get("status") if obj.get("status") is not None else PaymentMethodStatus.INVALID,
            "messages": obj.get("messages"),
            "stripe_payment_method_id": obj.get("stripe_payment_method_id"),
            "authorization_verified_at": obj.get("authorization_verified_at"),
            "authorization_canceled_at": obj.get("authorization_canceled_at"),
            "authorization_stripe_payment_intent_id": obj.get("authorization_stripe_payment_intent_id"),
            "authorization_stripe_payment_intent_client_secret": obj.get("authorization_stripe_payment_intent_client_secret"),
            "card_brand": obj.get("card_brand"),
            "card_country": obj.get("card_country"),
            "card_funding": obj.get("card_funding"),
            "card_fingerprint": obj.get("card_fingerprint"),
            "card_last_digits": obj.get("card_last_digits"),
            "card_expiration_month": obj.get("card_expiration_month"),
            "card_expiration_year": obj.get("card_expiration_year")
        })
        return _obj


