# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.persistent_volume_backing_store import PersistentVolumeBackingStore
from koyeb.api.models.persistent_volume_status import PersistentVolumeStatus
from typing import Optional, Set
from typing_extensions import Self

class PersistentVolume(BaseModel):
    """
    PersistentVolume
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    snapshot_id: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    deleted_at: Optional[datetime] = None
    organization_id: Optional[StrictStr] = None
    service_id: Optional[StrictStr] = None
    region: Optional[StrictStr] = None
    read_only: Optional[StrictBool] = None
    max_size: Optional[StrictInt] = None
    cur_size: Optional[StrictInt] = None
    status: Optional[PersistentVolumeStatus] = PersistentVolumeStatus.PERSISTENT_VOLUME_STATUS_INVALID
    backing_store: Optional[PersistentVolumeBackingStore] = PersistentVolumeBackingStore.PERSISTENT_VOLUME_BACKING_STORE_INVALID
    __properties: ClassVar[List[str]] = ["id", "name", "snapshot_id", "created_at", "updated_at", "deleted_at", "organization_id", "service_id", "region", "read_only", "max_size", "cur_size", "status", "backing_store"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersistentVolume from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersistentVolume from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "snapshot_id": obj.get("snapshot_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "deleted_at": obj.get("deleted_at"),
            "organization_id": obj.get("organization_id"),
            "service_id": obj.get("service_id"),
            "region": obj.get("region"),
            "read_only": obj.get("read_only"),
            "max_size": obj.get("max_size"),
            "cur_size": obj.get("cur_size"),
            "status": obj.get("status") if obj.get("status") is not None else PersistentVolumeStatus.PERSISTENT_VOLUME_STATUS_INVALID,
            "backing_store": obj.get("backing_store") if obj.get("backing_store") is not None else PersistentVolumeBackingStore.PERSISTENT_VOLUME_BACKING_STORE_INVALID
        })
        return _obj


