# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.domain_load_balancer_quotas import DomainLoadBalancerQuotas
from koyeb.api.models.persistent_volume_quotas import PersistentVolumeQuotas
from koyeb.api.models.scale_to_zero_quotas import ScaleToZeroQuotas
from typing import Optional, Set
from typing_extensions import Self

class Quotas(BaseModel):
    """
    Quotas
    """ # noqa: E501
    apps: Optional[StrictStr] = None
    services: Optional[StrictStr] = None
    domains: Optional[StrictStr] = None
    services_by_app: Optional[StrictStr] = None
    service_provisioning_concurrency: Optional[StrictStr] = None
    memory_mb: Optional[StrictStr] = None
    instance_types: Optional[List[StrictStr]] = None
    regions: Optional[List[StrictStr]] = None
    max_organization_members: Optional[StrictStr] = None
    max_instances_by_type: Optional[Dict[str, StrictStr]] = None
    persistent_volumes_by_region: Optional[Dict[str, PersistentVolumeQuotas]] = None
    custom_domains: Optional[StrictStr] = None
    domains_load_balancer: Optional[DomainLoadBalancerQuotas] = None
    metrics_retention: Optional[StrictInt] = None
    logs_retention: Optional[StrictInt] = None
    access_reserved_subdomains: Optional[List[StrictStr]] = None
    proxy_ports: Optional[StrictInt] = None
    scale_to_zero: Optional[ScaleToZeroQuotas] = None
    archives: Optional[StrictStr] = None
    archive_max_size_mb: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["apps", "services", "domains", "services_by_app", "service_provisioning_concurrency", "memory_mb", "instance_types", "regions", "max_organization_members", "max_instances_by_type", "persistent_volumes_by_region", "custom_domains", "domains_load_balancer", "metrics_retention", "logs_retention", "access_reserved_subdomains", "proxy_ports", "scale_to_zero", "archives", "archive_max_size_mb"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Quotas from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in persistent_volumes_by_region (dict)
        _field_dict = {}
        if self.persistent_volumes_by_region:
            for _key_persistent_volumes_by_region in self.persistent_volumes_by_region:
                if self.persistent_volumes_by_region[_key_persistent_volumes_by_region]:
                    _field_dict[_key_persistent_volumes_by_region] = self.persistent_volumes_by_region[_key_persistent_volumes_by_region].to_dict()
            _dict['persistent_volumes_by_region'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of domains_load_balancer
        if self.domains_load_balancer:
            _dict['domains_load_balancer'] = self.domains_load_balancer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scale_to_zero
        if self.scale_to_zero:
            _dict['scale_to_zero'] = self.scale_to_zero.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Quotas from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apps": obj.get("apps"),
            "services": obj.get("services"),
            "domains": obj.get("domains"),
            "services_by_app": obj.get("services_by_app"),
            "service_provisioning_concurrency": obj.get("service_provisioning_concurrency"),
            "memory_mb": obj.get("memory_mb"),
            "instance_types": obj.get("instance_types"),
            "regions": obj.get("regions"),
            "max_organization_members": obj.get("max_organization_members"),
            "max_instances_by_type": obj.get("max_instances_by_type"),
            "persistent_volumes_by_region": dict(
                (_k, PersistentVolumeQuotas.from_dict(_v))
                for _k, _v in obj["persistent_volumes_by_region"].items()
            )
            if obj.get("persistent_volumes_by_region") is not None
            else None,
            "custom_domains": obj.get("custom_domains"),
            "domains_load_balancer": DomainLoadBalancerQuotas.from_dict(obj["domains_load_balancer"]) if obj.get("domains_load_balancer") is not None else None,
            "metrics_retention": obj.get("metrics_retention"),
            "logs_retention": obj.get("logs_retention"),
            "access_reserved_subdomains": obj.get("access_reserved_subdomains"),
            "proxy_ports": obj.get("proxy_ports"),
            "scale_to_zero": ScaleToZeroQuotas.from_dict(obj["scale_to_zero"]) if obj.get("scale_to_zero") is not None else None,
            "archives": obj.get("archives"),
            "archive_max_size_mb": obj.get("archive_max_size_mb")
        })
        return _obj


