# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ScaleToZeroQuotas(BaseModel):
    """
    ScaleToZeroQuotas
    """ # noqa: E501
    is_deep_sleep_enabled: Optional[StrictBool] = None
    deep_sleep_idle_delay_min: Optional[StrictInt] = None
    deep_sleep_idle_delay_max: Optional[StrictInt] = None
    is_light_sleep_enabled: Optional[StrictBool] = None
    light_sleep_idle_delay_min: Optional[StrictInt] = None
    light_sleep_idle_delay_max: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["is_deep_sleep_enabled", "deep_sleep_idle_delay_min", "deep_sleep_idle_delay_max", "is_light_sleep_enabled", "light_sleep_idle_delay_min", "light_sleep_idle_delay_max"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScaleToZeroQuotas from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScaleToZeroQuotas from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "is_deep_sleep_enabled": obj.get("is_deep_sleep_enabled"),
            "deep_sleep_idle_delay_min": obj.get("deep_sleep_idle_delay_min"),
            "deep_sleep_idle_delay_max": obj.get("deep_sleep_idle_delay_max"),
            "is_light_sleep_enabled": obj.get("is_light_sleep_enabled"),
            "light_sleep_idle_delay_min": obj.get("light_sleep_idle_delay_min"),
            "light_sleep_idle_delay_max": obj.get("light_sleep_idle_delay_max")
        })
        return _obj


