# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.service_state import ServiceState
from koyeb.api.models.service_status import ServiceStatus
from koyeb.api.models.service_type import ServiceType
from typing import Optional, Set
from typing_extensions import Self

class ServiceListItem(BaseModel):
    """
    ServiceListItem
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    type: Optional[ServiceType] = ServiceType.INVALID_TYPE
    organization_id: Optional[StrictStr] = None
    app_id: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    created_at: Optional[datetime] = None
    status: Optional[ServiceStatus] = ServiceStatus.STARTING
    messages: Optional[List[StrictStr]] = None
    version: Optional[StrictStr] = None
    state: Optional[ServiceState] = None
    active_deployment_id: Optional[StrictStr] = None
    latest_deployment_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "type", "organization_id", "app_id", "updated_at", "created_at", "status", "messages", "version", "state", "active_deployment_id", "latest_deployment_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServiceListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServiceListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type") if obj.get("type") is not None else ServiceType.INVALID_TYPE,
            "organization_id": obj.get("organization_id"),
            "app_id": obj.get("app_id"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "status": obj.get("status") if obj.get("status") is not None else ServiceStatus.STARTING,
            "messages": obj.get("messages"),
            "version": obj.get("version"),
            "state": ServiceState.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "active_deployment_id": obj.get("active_deployment_id"),
            "latest_deployment_id": obj.get("latest_deployment_id")
        })
        return _obj


