# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.subscription_payment_failure import SubscriptionPaymentFailure
from koyeb.api.models.subscription_status import SubscriptionStatus
from typing import Optional, Set
from typing_extensions import Self

class Subscription(BaseModel):
    """
    Subscription
    """ # noqa: E501
    id: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    version: Optional[StrictStr] = None
    organization_id: Optional[StrictStr] = None
    stripe_subscription_id: Optional[StrictStr] = None
    status: Optional[SubscriptionStatus] = SubscriptionStatus.INVALID
    messages: Optional[List[StrictStr]] = None
    has_pending_update: Optional[StrictBool] = None
    stripe_pending_invoice_id: Optional[StrictStr] = None
    terminate_at: Optional[datetime] = None
    canceled_at: Optional[datetime] = None
    terminated_at: Optional[datetime] = None
    current_period_start: Optional[datetime] = None
    current_period_end: Optional[datetime] = None
    currency: Optional[StrictStr] = None
    amount_payable: Optional[StrictStr] = None
    amount_paid: Optional[StrictStr] = None
    amount_remaining: Optional[StrictStr] = None
    payment_failure: Optional[SubscriptionPaymentFailure] = None
    trialing: Optional[StrictBool] = None
    trial_ends_at: Optional[datetime] = None
    trial_max_spend: Optional[StrictStr] = None
    current_spend: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "created_at", "updated_at", "version", "organization_id", "stripe_subscription_id", "status", "messages", "has_pending_update", "stripe_pending_invoice_id", "terminate_at", "canceled_at", "terminated_at", "current_period_start", "current_period_end", "currency", "amount_payable", "amount_paid", "amount_remaining", "payment_failure", "trialing", "trial_ends_at", "trial_max_spend", "current_spend"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Subscription from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payment_failure
        if self.payment_failure:
            _dict['payment_failure'] = self.payment_failure.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Subscription from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "version": obj.get("version"),
            "organization_id": obj.get("organization_id"),
            "stripe_subscription_id": obj.get("stripe_subscription_id"),
            "status": obj.get("status") if obj.get("status") is not None else SubscriptionStatus.INVALID,
            "messages": obj.get("messages"),
            "has_pending_update": obj.get("has_pending_update"),
            "stripe_pending_invoice_id": obj.get("stripe_pending_invoice_id"),
            "terminate_at": obj.get("terminate_at"),
            "canceled_at": obj.get("canceled_at"),
            "terminated_at": obj.get("terminated_at"),
            "current_period_start": obj.get("current_period_start"),
            "current_period_end": obj.get("current_period_end"),
            "currency": obj.get("currency"),
            "amount_payable": obj.get("amount_payable"),
            "amount_paid": obj.get("amount_paid"),
            "amount_remaining": obj.get("amount_remaining"),
            "payment_failure": SubscriptionPaymentFailure.from_dict(obj["payment_failure"]) if obj.get("payment_failure") is not None else None,
            "trialing": obj.get("trialing"),
            "trial_ends_at": obj.get("trial_ends_at"),
            "trial_max_spend": obj.get("trial_max_spend"),
            "current_spend": obj.get("current_spend")
        })
        return _obj


