# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UsageDetails(BaseModel):
    """
    UsageDetails
    """ # noqa: E501
    organization_id: Optional[StrictStr] = None
    instance_id: Optional[StrictStr] = None
    app_id: Optional[StrictStr] = None
    app_name: Optional[StrictStr] = None
    service_id: Optional[StrictStr] = None
    service_name: Optional[StrictStr] = None
    regional_deployment_id: Optional[StrictStr] = None
    region: Optional[StrictStr] = None
    deployment_id: Optional[StrictStr] = None
    instance_type: Optional[StrictStr] = None
    duration_seconds: Optional[StrictInt] = None
    started_at: Optional[datetime] = None
    terminated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["organization_id", "instance_id", "app_id", "app_name", "service_id", "service_name", "regional_deployment_id", "region", "deployment_id", "instance_type", "duration_seconds", "started_at", "terminated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UsageDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UsageDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organization_id": obj.get("organization_id"),
            "instance_id": obj.get("instance_id"),
            "app_id": obj.get("app_id"),
            "app_name": obj.get("app_name"),
            "service_id": obj.get("service_id"),
            "service_name": obj.get("service_name"),
            "regional_deployment_id": obj.get("regional_deployment_id"),
            "region": obj.get("region"),
            "deployment_id": obj.get("deployment_id"),
            "instance_type": obj.get("instance_type"),
            "duration_seconds": obj.get("duration_seconds"),
            "started_at": obj.get("started_at"),
            "terminated_at": obj.get("terminated_at")
        })
        return _obj


