# coding: utf-8

"""
    Koyeb Rest API

    The Koyeb API allows you to interact with the Koyeb platform in a simple, programmatic way using conventional HTTP requests. 

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from koyeb.api.models.user_flags import UserFlags
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User
    """ # noqa: E501
    id: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    avatar_url: Optional[StrictStr] = None
    two_factor_authentication: Optional[StrictBool] = None
    last_login: Optional[datetime] = None
    last_login_ip: Optional[StrictStr] = None
    updated_at: Optional[datetime] = None
    created_at: Optional[datetime] = None
    newsletter_subscribed: Optional[StrictBool] = None
    github_id: Optional[StrictStr] = None
    github_user: Optional[StrictStr] = None
    flags: Optional[List[UserFlags]] = None
    name: Optional[StrictStr] = None
    email_validated: Optional[StrictBool] = None
    trialed: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "email", "avatar_url", "two_factor_authentication", "last_login", "last_login_ip", "updated_at", "created_at", "newsletter_subscribed", "github_id", "github_user", "flags", "name", "email_validated", "trialed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "avatar_url": obj.get("avatar_url"),
            "two_factor_authentication": obj.get("two_factor_authentication"),
            "last_login": obj.get("last_login"),
            "last_login_ip": obj.get("last_login_ip"),
            "updated_at": obj.get("updated_at"),
            "created_at": obj.get("created_at"),
            "newsletter_subscribed": obj.get("newsletter_subscribed"),
            "github_id": obj.get("github_id"),
            "github_user": obj.get("github_user"),
            "flags": obj.get("flags"),
            "name": obj.get("name"),
            "email_validated": obj.get("email_validated"),
            "trialed": obj.get("trialed")
        })
        return _obj


