"""
Built-in formatters for common training frameworks.

These formatters transform DeepFabric datasets to formats required by
popular training frameworks and methodologies.
"""

from .alpaca import AlpacaFormatter
from .chatml import ChatmlFormatter
from .grpo import GrpoFormatter
from .im_format import ImFormatter
from .unsloth import UnslothFormatter
from .unsloth_grpo import UnslothGrpoFormatter

__all__ = [
    "AlpacaFormatter",
    "ChatmlFormatter",
    "GrpoFormatter",
    "ImFormatter",
    "UnslothFormatter",
    "UnslothGrpoFormatter",
]
