# visualize

The `visualize` command creates SVG diagrams of topic graphs, enabling visual exploration of domain structures and relationship patterns. This capability is particularly valuable for topic graphs where cross-connections between concepts create complex structures that benefit from visual representation.

The visualization process transforms the abstract JSON representation of topic relationships into comprehensible diagrams that reveal structural patterns, connection densities, and hierarchical organization within your generated topic models.

## Basic Usage

Create an SVG visualization from a topic graph file:

```bash
deepfabric visualize topic_graph.json --output domain_structure
```

This command reads the graph structure and generates `domain_structure.svg` showing nodes as topics and edges as relationships between concepts.

## Graph File Requirements

The visualize command works with JSON files containing topic graph structures as generated by the graph-based topic modeling process:

```json
{
  "nodes": {
    "root": {"prompt": "Root concept", "children": ["child1", "child2"]},
    "child1": {"prompt": "First subtopic", "connections": ["child2"]}
  },
  "edges": [
    {"from": "root", "to": "child1", "type": "hierarchical"},
    {"from": "child1", "to": "child2", "type": "cross_connection"}
  ]
}
```

The visualization interprets both hierarchical parent-child relationships and cross-connections between topics in different branches.

## Output Options

Control the output file location and naming:

```bash
# Specify custom output location
deepfabric visualize research_graph.json --output analysis/research_structure

# Use different naming pattern
deepfabric visualize ml_topics.json -o visualizations/ml_domain_map
```

The command automatically appends `.svg` to the output filename, creating scalable vector graphics suitable for both screen viewing and print output.

## Visual Elements

The generated diagrams use distinct visual elements to represent different aspects of the graph structure:

**Node Representation** displays topics as labeled boxes with the seed prompt text, sized according to their position in the hierarchy.

**Hierarchical Edges** appear as solid lines connecting parent topics to their direct children, showing the primary organizational structure.

**Cross-Connections** are rendered as dashed lines linking related concepts across different hierarchical branches, highlighting interdisciplinary relationships.

**Root Highlighting** uses distinctive formatting for the root node to clearly identify the domain's central concept.

## Use Cases

Graph visualization serves multiple analytical and communication purposes:

**Domain Analysis** reveals the overall structure and balance of your topic coverage, identifying areas with dense interconnections versus isolated branches.

**Quality Assessment** enables visual inspection of topic relationships to identify illogical connections or missing relationships that might indicate generation issues.

**Stakeholder Communication** provides intuitive visual representations of complex domain structures for presentations and documentation.

**Iterative Development** supports refinement of topic generation parameters by visualizing the effects of different configuration choices.

## Large Graph Considerations

Complex topic graphs with many nodes and connections benefit from several visualization strategies:

**Hierarchical Layout** organizes nodes by their distance from the root, creating clear visual layers that show conceptual progression.

**Connection Filtering** can emphasize the most important relationships while de-emphasizing less significant connections to reduce visual clutter.

**Subgraph Focus** enables visualization of specific portions of large graphs for detailed analysis of particular domain areas.

## Integration with Generation Workflow

Visualization fits naturally into the iterative development process:

```bash
# Generate topic graph
deepfabric generate research-config.yaml

# Visualize the structure
deepfabric visualize research_graph.json --output research_analysis

# Review visualization and adjust parameters
# Regenerate with modified configuration
```

This workflow enables rapid iteration on topic generation parameters with immediate visual feedback on structural changes.

## File Format Compatibility

The visualization command specifically requires JSON files in the DeepFabric topic graph format. JSONL topic tree files are not directly compatible, though topic trees can be converted to graph format for visualization purposes.

## Technical Specifications

Generated SVG files are self-contained vector graphics that:

- Scale cleanly to any resolution without quality loss
- Include embedded text that remains searchable and selectable
- Work in modern web browsers, vector graphics applications, and print workflows
- Use standard web colors and fonts for maximum compatibility

??? tip "Visualization Best Practices"
    Generate visualizations after topic graph creation but before dataset generation to validate topic coverage and relationships. Use visualizations to identify overly dense or sparse areas in your domain coverage, then adjust generation parameters accordingly.