# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .domains.client import AsyncDomainsClient, DomainsClient
from .drafts.client import AsyncDraftsClient, DraftsClient
from .environment import AgentMailEnvironment
from .inboxes.client import AsyncInboxesClient, InboxesClient
from .threads.client import AsyncThreadsClient, ThreadsClient
from .webhooks.client import AsyncWebhooksClient, WebhooksClient
from .websockets.client import AsyncWebsocketsClient, WebsocketsClient


class AgentMail:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : AgentMailEnvironment
        The environment to use for requests from the client. from .environment import AgentMailEnvironment



        Defaults to AgentMailEnvironment.PRODUCTION



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agentmail import AgentMail

    client = AgentMail(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: AgentMailEnvironment = AgentMailEnvironment.PRODUCTION,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("AGENTMAIL_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting AGENTMAIL_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.inboxes = InboxesClient(client_wrapper=self._client_wrapper)
        self.webhooks = WebhooksClient(client_wrapper=self._client_wrapper)
        self.domains = DomainsClient(client_wrapper=self._client_wrapper)
        self.drafts = DraftsClient(client_wrapper=self._client_wrapper)
        self.threads = ThreadsClient(client_wrapper=self._client_wrapper)
        self.websockets = WebsocketsClient(client_wrapper=self._client_wrapper)


class AsyncAgentMail:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : AgentMailEnvironment
        The environment to use for requests from the client. from .environment import AgentMailEnvironment



        Defaults to AgentMailEnvironment.PRODUCTION



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agentmail import AsyncAgentMail

    client = AsyncAgentMail(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: AgentMailEnvironment = AgentMailEnvironment.PRODUCTION,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("AGENTMAIL_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting AGENTMAIL_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.inboxes = AsyncInboxesClient(client_wrapper=self._client_wrapper)
        self.webhooks = AsyncWebhooksClient(client_wrapper=self._client_wrapper)
        self.domains = AsyncDomainsClient(client_wrapper=self._client_wrapper)
        self.drafts = AsyncDraftsClient(client_wrapper=self._client_wrapper)
        self.threads = AsyncThreadsClient(client_wrapper=self._client_wrapper)
        self.websockets = AsyncWebsocketsClient(client_wrapper=self._client_wrapper)
