# This file was auto-generated by Fern from our API Definition.

import inspect
import typing
from enum import Enum


class EventType(str, Enum):
    OPEN = "open"
    MESSAGE = "message"
    ERROR = "error"
    CLOSE = "close"


class EventEmitterMixin:
    """
    Simple mixin for registering and emitting events.
    """

    def __init__(self) -> None:
        self._callbacks: typing.Dict[EventType, typing.List[typing.Callable]] = {}

    def on(self, event_name: EventType, callback: typing.Callable[[typing.Any], typing.Any]) -> None:
        if event_name not in self._callbacks:
            self._callbacks[event_name] = []
        self._callbacks[event_name].append(callback)

    def _emit(self, event_name: EventType, data: typing.Any) -> None:
        if event_name in self._callbacks:
            for cb in self._callbacks[event_name]:
                cb(data)

    async def _emit_async(self, event_name: EventType, data: typing.Any) -> None:
        if event_name in self._callbacks:
            for cb in self._callbacks[event_name]:
                res = cb(data)
                if inspect.isawaitable(res):
                    await res
