# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.organization_id import OrganizationId
from .domain_id import DomainId


class DomainSummary(UncheckedBaseModel):
    domain_id: DomainId
    organization_id: OrganizationId
    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was created.
    """

    feedback_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to forward bounce and complaint notifications to your domain.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
