# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .record_status import RecordStatus
from .record_type import RecordType


class VerificationRecord(UncheckedBaseModel):
    type: RecordType = pydantic.Field()
    """
    The type of the DNS record.
    """

    name: str = pydantic.Field()
    """
    The name or host of the record.
    """

    value: str = pydantic.Field()
    """
    The value of the record.
    """

    status: RecordStatus = pydantic.Field()
    """
    The verification status of this specific record.
    """

    priority: typing.Optional[int] = pydantic.Field(default=None)
    """
    The priority of the MX record.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
