# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.not_found_error import NotFoundError
from ..types.ascending import Ascending
from ..types.error_response import ErrorResponse
from ..types.labels import Labels
from ..types.limit import Limit
from ..types.page_token import PageToken
from .types.draft import Draft
from .types.draft_id import DraftId
from .types.list_drafts_response import ListDraftsResponse


class RawDraftsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListDraftsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListDraftsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v0/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(self, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Draft]:
        """
        Parameters
        ----------
        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Draft]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDraftsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListDraftsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListDraftsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v0/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Draft]:
        """
        Parameters
        ----------
        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Draft]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
