# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...inboxes.types.inbox_id import InboxId
from ...threads.types.thread_id import ThreadId
from .draft_attachments import DraftAttachments
from .draft_bcc import DraftBcc
from .draft_cc import DraftCc
from .draft_html import DraftHtml
from .draft_id import DraftId
from .draft_labels import DraftLabels
from .draft_preview import DraftPreview
from .draft_reply_to import DraftReplyTo
from .draft_subject import DraftSubject
from .draft_text import DraftText
from .draft_to import DraftTo
from .draft_updated_at import DraftUpdatedAt


class Draft(UncheckedBaseModel):
    inbox_id: InboxId
    thread_id: ThreadId
    draft_id: DraftId
    labels: DraftLabels
    reply_to: typing.Optional[DraftReplyTo] = None
    to: typing.Optional[DraftTo] = None
    cc: typing.Optional[DraftCc] = None
    bcc: typing.Optional[DraftBcc] = None
    subject: typing.Optional[DraftSubject] = None
    preview: typing.Optional[DraftPreview] = None
    text: typing.Optional[DraftText] = None
    html: typing.Optional[DraftHtml] = None
    attachments: typing.Optional[DraftAttachments] = None
    in_reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of message being replied to.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    IDs of previous messages in thread.
    """

    updated_at: DraftUpdatedAt
    created_at: dt.datetime = pydantic.Field()
    """
    Time at which draft was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
