# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ...drafts.types.draft import Draft
from ...drafts.types.draft_bcc import DraftBcc
from ...drafts.types.draft_cc import DraftCc
from ...drafts.types.draft_html import DraftHtml
from ...drafts.types.draft_id import DraftId
from ...drafts.types.draft_labels import DraftLabels
from ...drafts.types.draft_reply_to import DraftReplyTo
from ...drafts.types.draft_subject import DraftSubject
from ...drafts.types.draft_text import DraftText
from ...drafts.types.draft_to import DraftTo
from ...drafts.types.list_drafts_response import ListDraftsResponse
from ...errors.not_found_error import NotFoundError
from ...errors.validation_error import ValidationError
from ...messages.errors.message_rejected_error import MessageRejectedError
from ...messages.types.send_message_response import SendMessageResponse
from ...types.ascending import Ascending
from ...types.error_response import ErrorResponse
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ...types.validation_error_response import ValidationErrorResponse
from ..types.inbox_id import InboxId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDraftsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListDraftsResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListDraftsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Draft]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Draft]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": reply_to,
                "to": to,
                "cc": cc,
                "bcc": bcc,
                "subject": subject,
                "text": text,
                "html": html,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SendMessageResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDraftsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListDraftsResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListDraftsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Draft]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Draft]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": reply_to,
                "to": to,
                "cc": cc,
                "bcc": bcc,
                "subject": subject,
                "text": text,
                "html": html,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SendMessageResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
