# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from ...core.unchecked_base_model import UncheckedBaseModel
from ...inboxes.types.inbox_id import InboxId
from ...threads.types.thread_id import ThreadId
from .message_attachments import MessageAttachments
from .message_bcc import MessageBcc
from .message_cc import MessageCc
from .message_from import MessageFrom
from .message_html import MessageHtml
from .message_id import MessageId
from .message_labels import MessageLabels
from .message_preview import MessagePreview
from .message_subject import MessageSubject
from .message_text import MessageText
from .message_timestamp import MessageTimestamp
from .message_to import MessageTo


class Message(UncheckedBaseModel):
    inbox_id: InboxId
    thread_id: ThreadId
    message_id: MessageId
    labels: MessageLabels
    timestamp: MessageTimestamp
    from_: typing_extensions.Annotated[MessageFrom, FieldMetadata(alias="from")]
    reply_to: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Reply-to addresses. In format `username@domain.com` or `Display Name <username@domain.com>`.
    """

    to: MessageTo
    cc: typing.Optional[MessageCc] = None
    bcc: typing.Optional[MessageBcc] = None
    subject: typing.Optional[MessageSubject] = None
    preview: typing.Optional[MessagePreview] = None
    text: typing.Optional[MessageText] = None
    html: typing.Optional[MessageHtml] = None
    attachments: typing.Optional[MessageAttachments] = None
    in_reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of message being replied to.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    IDs of previous messages in thread.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which message was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which message was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
