# This file was auto-generated by Fern from our API Definition.

import typing
from contextlib import asynccontextmanager, contextmanager

import httpx
import websockets.exceptions
import websockets.sync.client as websockets_sync_client
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawWebsocketsClient, RawWebsocketsClient
from .socket_client import AsyncWebsocketsSocketClient, WebsocketsSocketClient

try:
    from websockets.legacy.client import connect as websockets_client_connect  # type: ignore
except ImportError:
    from websockets import connect as websockets_client_connect  # type: ignore


class WebsocketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebsocketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebsocketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebsocketsClient
        """
        return self._raw_client

    @contextmanager
    def connect(
        self, *, auth_token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[WebsocketsSocketClient]:
        """
        Parameters
        ----------
        auth_token : str
            Your API key.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebsocketsSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().websockets + "/v0"
        query_params = httpx.QueryParams()
        if auth_token is not None:
            query_params = query_params.add("auth_token", auth_token)
        ws_url = ws_url + f"?{query_params}"
        headers = self._raw_client._client_wrapper.get_headers()
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            with websockets_sync_client.connect(ws_url, additional_headers=headers) as protocol:
                yield WebsocketsSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )


class AsyncWebsocketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebsocketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebsocketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebsocketsClient
        """
        return self._raw_client

    @asynccontextmanager
    async def connect(
        self, *, auth_token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncWebsocketsSocketClient]:
        """
        Parameters
        ----------
        auth_token : str
            Your API key.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncWebsocketsSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().websockets + "/v0"
        query_params = httpx.QueryParams()
        if auth_token is not None:
            query_params = query_params.add("auth_token", auth_token)
        ws_url = ws_url + f"?{query_params}"
        headers = self._raw_client._client_wrapper.get_headers()
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            async with websockets_client_connect(ws_url, extra_headers=headers) as protocol:
                yield AsyncWebsocketsSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )
