# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthenticationPolicyArgs', 'AuthenticationPolicy']

@pulumi.input_type
class AuthenticationPolicyArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mfa_enrollment: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_policy: Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pat_policy: Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']] = None,
                 security_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_policy: Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']] = None):
        """
        The set of arguments for constructing a AuthenticationPolicy resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_methods: A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_types: A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the authentication policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mfa_authentication_methods: A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        :param pulumi.Input[_builtins.str] mfa_enrollment: Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        :param pulumi.Input['AuthenticationPolicyMfaPolicyArgs'] mfa_policy: Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input['AuthenticationPolicyPatPolicyArgs'] pat_policy: Specifies the policy for programmatic access tokens.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_integrations: A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        :param pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs'] workload_identity_policy: Specifies the policy for workload identity federation.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if authentication_methods is not None:
            pulumi.set(__self__, "authentication_methods", authentication_methods)
        if client_types is not None:
            pulumi.set(__self__, "client_types", client_types)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if mfa_authentication_methods is not None:
            warnings.warn("""This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""", DeprecationWarning)
            pulumi.log.warn("""mfa_authentication_methods is deprecated: This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""")
        if mfa_authentication_methods is not None:
            pulumi.set(__self__, "mfa_authentication_methods", mfa_authentication_methods)
        if mfa_enrollment is not None:
            pulumi.set(__self__, "mfa_enrollment", mfa_enrollment)
        if mfa_policy is not None:
            pulumi.set(__self__, "mfa_policy", mfa_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pat_policy is not None:
            pulumi.set(__self__, "pat_policy", pat_policy)
        if security_integrations is not None:
            pulumi.set(__self__, "security_integrations", security_integrations)
        if workload_identity_policy is not None:
            pulumi.set(__self__, "workload_identity_policy", workload_identity_policy)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethods")
    def authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        """
        return pulumi.get(self, "authentication_methods")

    @authentication_methods.setter
    def authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientTypes")
    def client_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        """
        return pulumi.get(self, "client_types")

    @client_types.setter
    def client_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_types", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the authentication policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="mfaAuthenticationMethods")
    @_utilities.deprecated("""This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""")
    def mfa_authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        """
        return pulumi.get(self, "mfa_authentication_methods")

    @mfa_authentication_methods.setter
    def mfa_authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mfa_authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="mfaEnrollment")
    def mfa_enrollment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enrollment")

    @mfa_enrollment.setter
    def mfa_enrollment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mfa_enrollment", value)

    @_builtins.property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']]:
        """
        Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        """
        return pulumi.get(self, "mfa_policy")

    @mfa_policy.setter
    def mfa_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']]):
        pulumi.set(self, "mfa_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="patPolicy")
    def pat_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']]:
        """
        Specifies the policy for programmatic access tokens.
        """
        return pulumi.get(self, "pat_policy")

    @pat_policy.setter
    def pat_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']]):
        pulumi.set(self, "pat_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityIntegrations")
    def security_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        """
        return pulumi.get(self, "security_integrations")

    @security_integrations.setter
    def security_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_integrations", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPolicy")
    def workload_identity_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']]:
        """
        Specifies the policy for workload identity federation.
        """
        return pulumi.get(self, "workload_identity_policy")

    @workload_identity_policy.setter
    def workload_identity_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']]):
        pulumi.set(self, "workload_identity_policy", value)


@pulumi.input_type
class _AuthenticationPolicyState:
    def __init__(__self__, *,
                 authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyDescribeOutputArgs']]]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mfa_enrollment: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_policy: Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pat_policy: Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 security_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyShowOutputArgs']]]] = None,
                 workload_identity_policy: Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering AuthenticationPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_methods: A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_types: A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the authentication policy.
        :param pulumi.Input[_builtins.str] database: The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE AUTHENTICATION POLICY` for the given policy.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mfa_authentication_methods: A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        :param pulumi.Input[_builtins.str] mfa_enrollment: Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        :param pulumi.Input['AuthenticationPolicyMfaPolicyArgs'] mfa_policy: Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input['AuthenticationPolicyPatPolicyArgs'] pat_policy: Specifies the policy for programmatic access tokens.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_integrations: A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        :param pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyShowOutputArgs']]] show_outputs: Outputs the result of `SHOW AUTHENTICATION POLICIES` for the given policy.
        :param pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs'] workload_identity_policy: Specifies the policy for workload identity federation.
        """
        if authentication_methods is not None:
            pulumi.set(__self__, "authentication_methods", authentication_methods)
        if client_types is not None:
            pulumi.set(__self__, "client_types", client_types)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if mfa_authentication_methods is not None:
            warnings.warn("""This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""", DeprecationWarning)
            pulumi.log.warn("""mfa_authentication_methods is deprecated: This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""")
        if mfa_authentication_methods is not None:
            pulumi.set(__self__, "mfa_authentication_methods", mfa_authentication_methods)
        if mfa_enrollment is not None:
            pulumi.set(__self__, "mfa_enrollment", mfa_enrollment)
        if mfa_policy is not None:
            pulumi.set(__self__, "mfa_policy", mfa_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pat_policy is not None:
            pulumi.set(__self__, "pat_policy", pat_policy)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if security_integrations is not None:
            pulumi.set(__self__, "security_integrations", security_integrations)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if workload_identity_policy is not None:
            pulumi.set(__self__, "workload_identity_policy", workload_identity_policy)

    @_builtins.property
    @pulumi.getter(name="authenticationMethods")
    def authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        """
        return pulumi.get(self, "authentication_methods")

    @authentication_methods.setter
    def authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientTypes")
    def client_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        """
        return pulumi.get(self, "client_types")

    @client_types.setter
    def client_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_types", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the authentication policy.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE AUTHENTICATION POLICY` for the given policy.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="mfaAuthenticationMethods")
    @_utilities.deprecated("""This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""")
    def mfa_authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        """
        return pulumi.get(self, "mfa_authentication_methods")

    @mfa_authentication_methods.setter
    def mfa_authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mfa_authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="mfaEnrollment")
    def mfa_enrollment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enrollment")

    @mfa_enrollment.setter
    def mfa_enrollment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mfa_enrollment", value)

    @_builtins.property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']]:
        """
        Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        """
        return pulumi.get(self, "mfa_policy")

    @mfa_policy.setter
    def mfa_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyMfaPolicyArgs']]):
        pulumi.set(self, "mfa_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="patPolicy")
    def pat_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']]:
        """
        Specifies the policy for programmatic access tokens.
        """
        return pulumi.get(self, "pat_policy")

    @pat_policy.setter
    def pat_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyPatPolicyArgs']]):
        pulumi.set(self, "pat_policy", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="securityIntegrations")
    def security_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        """
        return pulumi.get(self, "security_integrations")

    @security_integrations.setter
    def security_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_integrations", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW AUTHENTICATION POLICIES` for the given policy.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationPolicyShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPolicy")
    def workload_identity_policy(self) -> Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']]:
        """
        Specifies the policy for workload identity federation.
        """
        return pulumi.get(self, "workload_identity_policy")

    @workload_identity_policy.setter
    def workload_identity_policy(self, value: Optional[pulumi.Input['AuthenticationPolicyWorkloadIdentityPolicyArgs']]):
        pulumi.set(self, "workload_identity_policy", value)


@pulumi.type_token("snowflake:index/authenticationPolicy:AuthenticationPolicy")
class AuthenticationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mfa_enrollment: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_policy: Optional[pulumi.Input[Union['AuthenticationPolicyMfaPolicyArgs', 'AuthenticationPolicyMfaPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pat_policy: Optional[pulumi.Input[Union['AuthenticationPolicyPatPolicyArgs', 'AuthenticationPolicyPatPolicyArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 security_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_policy: Optional[pulumi.Input[Union['AuthenticationPolicyWorkloadIdentityPolicyArgs', 'AuthenticationPolicyWorkloadIdentityPolicyArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/authenticationPolicy:AuthenticationPolicy example '"<database_name>"."<schema_name>"."<authentication_policy_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_methods: A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_types: A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the authentication policy.
        :param pulumi.Input[_builtins.str] database: The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mfa_authentication_methods: A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        :param pulumi.Input[_builtins.str] mfa_enrollment: Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        :param pulumi.Input[Union['AuthenticationPolicyMfaPolicyArgs', 'AuthenticationPolicyMfaPolicyArgsDict']] mfa_policy: Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Union['AuthenticationPolicyPatPolicyArgs', 'AuthenticationPolicyPatPolicyArgsDict']] pat_policy: Specifies the policy for programmatic access tokens.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_integrations: A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        :param pulumi.Input[Union['AuthenticationPolicyWorkloadIdentityPolicyArgs', 'AuthenticationPolicyWorkloadIdentityPolicyArgsDict']] workload_identity_policy: Specifies the policy for workload identity federation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/authenticationPolicy:AuthenticationPolicy example '"<database_name>"."<schema_name>"."<authentication_policy_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mfa_enrollment: Optional[pulumi.Input[_builtins.str]] = None,
                 mfa_policy: Optional[pulumi.Input[Union['AuthenticationPolicyMfaPolicyArgs', 'AuthenticationPolicyMfaPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pat_policy: Optional[pulumi.Input[Union['AuthenticationPolicyPatPolicyArgs', 'AuthenticationPolicyPatPolicyArgsDict']]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 security_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workload_identity_policy: Optional[pulumi.Input[Union['AuthenticationPolicyWorkloadIdentityPolicyArgs', 'AuthenticationPolicyWorkloadIdentityPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationPolicyArgs.__new__(AuthenticationPolicyArgs)

            __props__.__dict__["authentication_methods"] = authentication_methods
            __props__.__dict__["client_types"] = client_types
            __props__.__dict__["comment"] = comment
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["mfa_authentication_methods"] = mfa_authentication_methods
            __props__.__dict__["mfa_enrollment"] = mfa_enrollment
            __props__.__dict__["mfa_policy"] = mfa_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["pat_policy"] = pat_policy
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["security_integrations"] = security_integrations
            __props__.__dict__["workload_identity_policy"] = workload_identity_policy
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(AuthenticationPolicy, __self__).__init__(
            'snowflake:index/authenticationPolicy:AuthenticationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationPolicyDescribeOutputArgs', 'AuthenticationPolicyDescribeOutputArgsDict']]]]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            mfa_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mfa_enrollment: Optional[pulumi.Input[_builtins.str]] = None,
            mfa_policy: Optional[pulumi.Input[Union['AuthenticationPolicyMfaPolicyArgs', 'AuthenticationPolicyMfaPolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pat_policy: Optional[pulumi.Input[Union['AuthenticationPolicyPatPolicyArgs', 'AuthenticationPolicyPatPolicyArgsDict']]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            security_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationPolicyShowOutputArgs', 'AuthenticationPolicyShowOutputArgsDict']]]]] = None,
            workload_identity_policy: Optional[pulumi.Input[Union['AuthenticationPolicyWorkloadIdentityPolicyArgs', 'AuthenticationPolicyWorkloadIdentityPolicyArgsDict']]] = None) -> 'AuthenticationPolicy':
        """
        Get an existing AuthenticationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authentication_methods: A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_types: A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the authentication policy.
        :param pulumi.Input[_builtins.str] database: The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationPolicyDescribeOutputArgs', 'AuthenticationPolicyDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE AUTHENTICATION POLICY` for the given policy.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mfa_authentication_methods: A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        :param pulumi.Input[_builtins.str] mfa_enrollment: Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        :param pulumi.Input[Union['AuthenticationPolicyMfaPolicyArgs', 'AuthenticationPolicyMfaPolicyArgsDict']] mfa_policy: Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Union['AuthenticationPolicyPatPolicyArgs', 'AuthenticationPolicyPatPolicyArgsDict']] pat_policy: Specifies the policy for programmatic access tokens.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_integrations: A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthenticationPolicyShowOutputArgs', 'AuthenticationPolicyShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW AUTHENTICATION POLICIES` for the given policy.
        :param pulumi.Input[Union['AuthenticationPolicyWorkloadIdentityPolicyArgs', 'AuthenticationPolicyWorkloadIdentityPolicyArgsDict']] workload_identity_policy: Specifies the policy for workload identity federation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationPolicyState.__new__(_AuthenticationPolicyState)

        __props__.__dict__["authentication_methods"] = authentication_methods
        __props__.__dict__["client_types"] = client_types
        __props__.__dict__["comment"] = comment
        __props__.__dict__["database"] = database
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["mfa_authentication_methods"] = mfa_authentication_methods
        __props__.__dict__["mfa_enrollment"] = mfa_enrollment
        __props__.__dict__["mfa_policy"] = mfa_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["pat_policy"] = pat_policy
        __props__.__dict__["schema"] = schema
        __props__.__dict__["security_integrations"] = security_integrations
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["workload_identity_policy"] = workload_identity_policy
        return AuthenticationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMethods")
    def authentication_methods(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of authentication methods that are allowed during login. Valid values are (case-insensitive): `ALL` | `SAML` | `PASSWORD` | `OAUTH` | `KEYPAIR` | `PROGRAMMATIC_ACCESS_TOKEN` | `WORKLOAD_IDENTITY`.
        """
        return pulumi.get(self, "authentication_methods")

    @_builtins.property
    @pulumi.getter(name="clientTypes")
    def client_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of clients that can authenticate with Snowflake. If a client tries to connect, and the client is not one of the valid `client_types`, then the login attempt fails. Valid values are (case-insensitive): `ALL` | `SNOWFLAKE_UI` | `DRIVERS` | `SNOWSQL` | `SNOWFLAKE_CLI`. The `client_types` property of an authentication policy is a best effort method to block user logins based on specific clients. It should not be used as the sole control to establish a security boundary.
        """
        return pulumi.get(self, "client_types")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the authentication policy.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.AuthenticationPolicyDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE AUTHENTICATION POLICY` for the given policy.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="mfaAuthenticationMethods")
    @_utilities.deprecated("""This field is deprecated and will be removed in the future. The new field `ENFORCE_MFA_ON_EXTERNAL_AUTHENTICATION` will be added in the next versions of the provider. Read our [BCR Migration Guide](https://github.com/snowflakedb/terraform-provider-snowflake/blob/main/SNOWFLAKE_BCR_MIGRATION_GUIDE.md#changes-in-authentication-policies) for more migration steps and more details.""")
    def mfa_authentication_methods(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of authentication methods that enforce multi-factor authentication (MFA) during login. Authentication methods not listed in this parameter do not prompt for multi-factor authentication. Allowed values are `ALL` | `SAML` | `PASSWORD`.
        """
        return pulumi.get(self, "mfa_authentication_methods")

    @_builtins.property
    @pulumi.getter(name="mfaEnrollment")
    def mfa_enrollment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines whether a user must enroll in multi-factor authentication. Valid values are (case-insensitive): `REQUIRED` | `REQUIRED_PASSWORD_ONLY` | `OPTIONAL`. When REQUIRED is specified, Enforces users to enroll in MFA. If this value is used, then the `client_types` parameter must include `snowflake_ui`, because Snowsight is the only place users can enroll in multi-factor authentication (MFA).
        """
        return pulumi.get(self, "mfa_enrollment")

    @_builtins.property
    @pulumi.getter(name="mfaPolicy")
    def mfa_policy(self) -> pulumi.Output[Optional['outputs.AuthenticationPolicyMfaPolicy']]:
        """
        Specifies the multi-factor authentication (MFA) methods that users can use as a second factor of authentication.
        """
        return pulumi.get(self, "mfa_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="patPolicy")
    def pat_policy(self) -> pulumi.Output[Optional['outputs.AuthenticationPolicyPatPolicy']]:
        """
        Specifies the policy for programmatic access tokens.
        """
        return pulumi.get(self, "pat_policy")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the authentication policy. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="securityIntegrations")
    def security_integrations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of security integrations the authentication policy is associated with. This parameter has no effect when `saml` or `oauth` are not in the `authentication_methods` list. All values in the `security_integrations` list must be compatible with the values in the `authentication_methods` list. For example, if `security_integrations` contains a SAML security integration, and `authentication_methods` contains OAUTH, then you cannot create the authentication policy. To allow all security integrations use `ALL` as parameter.
        """
        return pulumi.get(self, "security_integrations")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.AuthenticationPolicyShowOutput']]:
        """
        Outputs the result of `SHOW AUTHENTICATION POLICIES` for the given policy.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPolicy")
    def workload_identity_policy(self) -> pulumi.Output[Optional['outputs.AuthenticationPolicyWorkloadIdentityPolicy']]:
        """
        Specifies the policy for workload identity federation.
        """
        return pulumi.get(self, "workload_identity_policy")

