# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAlertsResult',
    'AwaitableGetAlertsResult',
    'get_alerts',
    'get_alerts_output',
]

@pulumi.output_type
class GetAlertsResult:
    """
    A collection of values returned by getAlerts.
    """
    def __init__(__self__, alerts=None, database=None, id=None, pattern=None, schema=None):
        if alerts and not isinstance(alerts, list):
            raise TypeError("Expected argument 'alerts' to be a list")
        pulumi.set(__self__, "alerts", alerts)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pattern and not isinstance(pattern, str):
            raise TypeError("Expected argument 'pattern' to be a str")
        pulumi.set(__self__, "pattern", pattern)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Sequence['outputs.GetAlertsAlertResult']:
        """
        Lists alerts for the current/specified database or schema, or across the entire account.
        """
        return pulumi.get(self, "alerts")

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[_builtins.str]:
        """
        The database from which to return the alerts from.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[_builtins.str]:
        """
        Filters the command output by object name.
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[_builtins.str]:
        """
        The schema from which to return the alerts from.
        """
        return pulumi.get(self, "schema")


class AwaitableGetAlertsResult(GetAlertsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertsResult(
            alerts=self.alerts,
            database=self.database,
            id=self.id,
            pattern=self.pattern,
            schema=self.schema)


def get_alerts(database: Optional[_builtins.str] = None,
               pattern: Optional[_builtins.str] = None,
               schema: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertsResult:
    """
    !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    current = snowflake.get_alerts(database="MYDB",
        schema="MYSCHEMA")
    ```

    > **Note** If a field has a default value, it is shown next to the type in the schema.


    :param _builtins.str database: The database from which to return the alerts from.
    :param _builtins.str pattern: Filters the command output by object name.
    :param _builtins.str schema: The schema from which to return the alerts from.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['pattern'] = pattern
    __args__['schema'] = schema
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('snowflake:index/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult).value

    return AwaitableGetAlertsResult(
        alerts=pulumi.get(__ret__, 'alerts'),
        database=pulumi.get(__ret__, 'database'),
        id=pulumi.get(__ret__, 'id'),
        pattern=pulumi.get(__ret__, 'pattern'),
        schema=pulumi.get(__ret__, 'schema'))
def get_alerts_output(database: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      pattern: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      schema: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertsResult]:
    """
    !> **Caution: Preview Feature** This feature is considered a preview feature in the provider, regardless of the state of the resource in Snowflake. We do not guarantee its stability. It will be reworked and marked as a stable feature in future releases. Breaking changes are expected, even without bumping the major version. To use this feature, add the relevant feature name to `preview_features_enabled` field in the provider configuration. Please always refer to the Getting Help section in our Github repo to best determine how to get help for your questions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_snowflake as snowflake

    current = snowflake.get_alerts(database="MYDB",
        schema="MYSCHEMA")
    ```

    > **Note** If a field has a default value, it is shown next to the type in the schema.


    :param _builtins.str database: The database from which to return the alerts from.
    :param _builtins.str pattern: Filters the command output by object name.
    :param _builtins.str schema: The schema from which to return the alerts from.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['pattern'] = pattern
    __args__['schema'] = schema
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('snowflake:index/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult)
    return __ret__.apply(lambda __response__: GetAlertsResult(
        alerts=pulumi.get(__response__, 'alerts'),
        database=pulumi.get(__response__, 'database'),
        id=pulumi.get(__response__, 'id'),
        pattern=pulumi.get(__response__, 'pattern'),
        schema=pulumi.get(__response__, 'schema')))
