# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGitRepositoriesResult',
    'AwaitableGetGitRepositoriesResult',
    'get_git_repositories',
    'get_git_repositories_output',
]

@pulumi.output_type
class GetGitRepositoriesResult:
    """
    A collection of values returned by getGitRepositories.
    """
    def __init__(__self__, git_repositories=None, id=None, in_=None, like=None, limit=None, with_describe=None):
        if git_repositories and not isinstance(git_repositories, list):
            raise TypeError("Expected argument 'git_repositories' to be a list")
        pulumi.set(__self__, "git_repositories", git_repositories)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_ and not isinstance(in_, dict):
            raise TypeError("Expected argument 'in_' to be a dict")
        pulumi.set(__self__, "in_", in_)
        if like and not isinstance(like, str):
            raise TypeError("Expected argument 'like' to be a str")
        pulumi.set(__self__, "like", like)
        if limit and not isinstance(limit, dict):
            raise TypeError("Expected argument 'limit' to be a dict")
        pulumi.set(__self__, "limit", limit)
        if with_describe and not isinstance(with_describe, bool):
            raise TypeError("Expected argument 'with_describe' to be a bool")
        pulumi.set(__self__, "with_describe", with_describe)

    @_builtins.property
    @pulumi.getter(name="gitRepositories")
    def git_repositories(self) -> Sequence['outputs.GetGitRepositoriesGitRepositoryResult']:
        """
        Holds the aggregated output of all git repositories details queries.
        """
        return pulumi.get(self, "git_repositories")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="in")
    def in_(self) -> Optional['outputs.GetGitRepositoriesInResult']:
        """
        IN clause to filter the list of objects
        """
        return pulumi.get(self, "in_")

    @_builtins.property
    @pulumi.getter
    def like(self) -> Optional[_builtins.str]:
        """
        Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
        """
        return pulumi.get(self, "like")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional['outputs.GetGitRepositoriesLimitResult']:
        """
        Limits the number of rows returned. If the `limit.from` is set, then the limit will start from the first element matched by the expression. The expression is only used to match with the first element, later on the elements are not matched by the prefix, but you can enforce a certain pattern with `starts_with` or `like`.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="withDescribe")
    def with_describe(self) -> Optional[_builtins.bool]:
        """
        (Default: `true`) Runs DESC GIT REPOSITORY for each git repository returned by SHOW GIT REPOSITORIES. The output of describe is saved to the description field. By default this value is set to true.
        """
        return pulumi.get(self, "with_describe")


class AwaitableGetGitRepositoriesResult(GetGitRepositoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitRepositoriesResult(
            git_repositories=self.git_repositories,
            id=self.id,
            in_=self.in_,
            like=self.like,
            limit=self.limit,
            with_describe=self.with_describe)


def get_git_repositories(in_: Optional[Union['GetGitRepositoriesInArgs', 'GetGitRepositoriesInArgsDict']] = None,
                         like: Optional[_builtins.str] = None,
                         limit: Optional[Union['GetGitRepositoriesLimitArgs', 'GetGitRepositoriesLimitArgsDict']] = None,
                         with_describe: Optional[_builtins.bool] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitRepositoriesResult:
    """
    Data source used to get details of filtered git repositories. Filtering is aligned with the current possibilities for [SHOW GIT REPOSITORIES](https://docs.snowflake.com/en/sql-reference/sql/show-git-repositories) query. The results of SHOW and DESCRIBE are encapsulated in one output collection `git_repositories`.


    :param Union['GetGitRepositoriesInArgs', 'GetGitRepositoriesInArgsDict'] in_: IN clause to filter the list of objects
    :param _builtins.str like: Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    :param Union['GetGitRepositoriesLimitArgs', 'GetGitRepositoriesLimitArgsDict'] limit: Limits the number of rows returned. If the `limit.from` is set, then the limit will start from the first element matched by the expression. The expression is only used to match with the first element, later on the elements are not matched by the prefix, but you can enforce a certain pattern with `starts_with` or `like`.
    :param _builtins.bool with_describe: (Default: `true`) Runs DESC GIT REPOSITORY for each git repository returned by SHOW GIT REPOSITORIES. The output of describe is saved to the description field. By default this value is set to true.
    """
    __args__ = dict()
    __args__['in'] = in_
    __args__['like'] = like
    __args__['limit'] = limit
    __args__['withDescribe'] = with_describe
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('snowflake:index/getGitRepositories:getGitRepositories', __args__, opts=opts, typ=GetGitRepositoriesResult).value

    return AwaitableGetGitRepositoriesResult(
        git_repositories=pulumi.get(__ret__, 'git_repositories'),
        id=pulumi.get(__ret__, 'id'),
        in_=pulumi.get(__ret__, 'in_'),
        like=pulumi.get(__ret__, 'like'),
        limit=pulumi.get(__ret__, 'limit'),
        with_describe=pulumi.get(__ret__, 'with_describe'))
def get_git_repositories_output(in_: Optional[pulumi.Input[Optional[Union['GetGitRepositoriesInArgs', 'GetGitRepositoriesInArgsDict']]]] = None,
                                like: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                limit: Optional[pulumi.Input[Optional[Union['GetGitRepositoriesLimitArgs', 'GetGitRepositoriesLimitArgsDict']]]] = None,
                                with_describe: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGitRepositoriesResult]:
    """
    Data source used to get details of filtered git repositories. Filtering is aligned with the current possibilities for [SHOW GIT REPOSITORIES](https://docs.snowflake.com/en/sql-reference/sql/show-git-repositories) query. The results of SHOW and DESCRIBE are encapsulated in one output collection `git_repositories`.


    :param Union['GetGitRepositoriesInArgs', 'GetGitRepositoriesInArgsDict'] in_: IN clause to filter the list of objects
    :param _builtins.str like: Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    :param Union['GetGitRepositoriesLimitArgs', 'GetGitRepositoriesLimitArgsDict'] limit: Limits the number of rows returned. If the `limit.from` is set, then the limit will start from the first element matched by the expression. The expression is only used to match with the first element, later on the elements are not matched by the prefix, but you can enforce a certain pattern with `starts_with` or `like`.
    :param _builtins.bool with_describe: (Default: `true`) Runs DESC GIT REPOSITORY for each git repository returned by SHOW GIT REPOSITORIES. The output of describe is saved to the description field. By default this value is set to true.
    """
    __args__ = dict()
    __args__['in'] = in_
    __args__['like'] = like
    __args__['limit'] = limit
    __args__['withDescribe'] = with_describe
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('snowflake:index/getGitRepositories:getGitRepositories', __args__, opts=opts, typ=GetGitRepositoriesResult)
    return __ret__.apply(lambda __response__: GetGitRepositoriesResult(
        git_repositories=pulumi.get(__response__, 'git_repositories'),
        id=pulumi.get(__response__, 'id'),
        in_=pulumi.get(__response__, 'in_'),
        like=pulumi.get(__response__, 'like'),
        limit=pulumi.get(__response__, 'limit'),
        with_describe=pulumi.get(__response__, 'with_describe')))
