# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListingArgs', 'Listing']

@pulumi.input_type
class ListingArgs:
    def __init__(__self__, *,
                 manifest: pulumi.Input['ListingManifestArgs'],
                 application_package: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish: Optional[pulumi.Input[_builtins.str]] = None,
                 share: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Listing resource.
        :param pulumi.Input[_builtins.str] application_package: Specifies the application package attached to the listing.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the listing.
        :param pulumi.Input[_builtins.str] name: Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        :param pulumi.Input[_builtins.str] publish: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        :param pulumi.Input[_builtins.str] share: Specifies the identifier for the share to attach to the listing.
        """
        pulumi.set(__self__, "manifest", manifest)
        if application_package is not None:
            pulumi.set(__self__, "application_package", application_package)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if share is not None:
            pulumi.set(__self__, "share", share)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Input['ListingManifestArgs']:
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: pulumi.Input['ListingManifestArgs']):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter(name="applicationPackage")
    def application_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the application package attached to the listing.
        """
        return pulumi.get(self, "application_package")

    @application_package.setter
    def application_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_package", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the listing.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publish", value)

    @_builtins.property
    @pulumi.getter
    def share(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the share to attach to the listing.
        """
        return pulumi.get(self, "share")

    @share.setter
    def share(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share", value)


@pulumi.input_type
class _ListingState:
    def __init__(__self__, *,
                 application_package: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input['ListingManifestArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish: Optional[pulumi.Input[_builtins.str]] = None,
                 share: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ListingShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering Listing resources.
        :param pulumi.Input[_builtins.str] application_package: Specifies the application package attached to the listing.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the listing.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        :param pulumi.Input[_builtins.str] publish: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        :param pulumi.Input[_builtins.str] share: Specifies the identifier for the share to attach to the listing.
        :param pulumi.Input[Sequence[pulumi.Input['ListingShowOutputArgs']]] show_outputs: Outputs the result of `SHOW LISTINGS` for the given listing.
        """
        if application_package is not None:
            pulumi.set(__self__, "application_package", application_package)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if share is not None:
            pulumi.set(__self__, "share", share)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="applicationPackage")
    def application_package(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the application package attached to the listing.
        """
        return pulumi.get(self, "application_package")

    @application_package.setter
    def application_package(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_package", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the listing.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input['ListingManifestArgs']]:
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input['ListingManifestArgs']]):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publish", value)

    @_builtins.property
    @pulumi.getter
    def share(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the share to attach to the listing.
        """
        return pulumi.get(self, "share")

    @share.setter
    def share(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListingShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW LISTINGS` for the given listing.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListingShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/listing:Listing")
class Listing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_package: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input[Union['ListingManifestArgs', 'ListingManifestArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish: Optional[pulumi.Input[_builtins.str]] = None,
                 share: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/listing:Listing example '"<listing_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_package: Specifies the application package attached to the listing.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the listing.
        :param pulumi.Input[_builtins.str] name: Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        :param pulumi.Input[_builtins.str] publish: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        :param pulumi.Input[_builtins.str] share: Specifies the identifier for the share to attach to the listing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/listing:Listing example '"<listing_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ListingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_package: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input[Union['ListingManifestArgs', 'ListingManifestArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish: Optional[pulumi.Input[_builtins.str]] = None,
                 share: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListingArgs.__new__(ListingArgs)

            __props__.__dict__["application_package"] = application_package
            __props__.__dict__["comment"] = comment
            if manifest is None and not opts.urn:
                raise TypeError("Missing required property 'manifest'")
            __props__.__dict__["manifest"] = manifest
            __props__.__dict__["name"] = name
            __props__.__dict__["publish"] = publish
            __props__.__dict__["share"] = share
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(Listing, __self__).__init__(
            'snowflake:index/listing:Listing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_package: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            manifest: Optional[pulumi.Input[Union['ListingManifestArgs', 'ListingManifestArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            publish: Optional[pulumi.Input[_builtins.str]] = None,
            share: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListingShowOutputArgs', 'ListingShowOutputArgsDict']]]]] = None) -> 'Listing':
        """
        Get an existing Listing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_package: Specifies the application package attached to the listing.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the listing.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        :param pulumi.Input[_builtins.str] publish: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        :param pulumi.Input[_builtins.str] share: Specifies the identifier for the share to attach to the listing.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListingShowOutputArgs', 'ListingShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW LISTINGS` for the given listing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListingState.__new__(_ListingState)

        __props__.__dict__["application_package"] = application_package
        __props__.__dict__["comment"] = comment
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["manifest"] = manifest
        __props__.__dict__["name"] = name
        __props__.__dict__["publish"] = publish
        __props__.__dict__["share"] = share
        __props__.__dict__["show_outputs"] = show_outputs
        return Listing(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationPackage")
    def application_package(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the application package attached to the listing.
        """
        return pulumi.get(self, "application_package")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the listing.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Output['outputs.ListingManifest']:
        return pulumi.get(self, "manifest")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the listing identifier (name). It must be unique within the organization, regardless of which Snowflake region the account is located in. Must start with an alphabetic character and cannot contain spaces or special characters except for underscores.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publish(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Determines if the listing should be published.
        """
        return pulumi.get(self, "publish")

    @_builtins.property
    @pulumi.getter
    def share(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier for the share to attach to the listing.
        """
        return pulumi.get(self, "share")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ListingShowOutput']]:
        """
        Outputs the result of `SHOW LISTINGS` for the given listing.
        """
        return pulumi.get(self, "show_outputs")

