# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticator: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 client_request_mfa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 client_store_temporary_credential: Optional[pulumi.Input[_builtins.str]] = None,
                 client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_console_login: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_query_context_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_telemetry: Optional[pulumi.Input[_builtins.bool]] = None,
                 driver_tracing: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_single_use_refresh_tokens: Optional[pulumi.Input[_builtins.bool]] = None,
                 experimental_features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_browser_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 include_retry_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 jwt_client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jwt_expire_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_session_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retry_count: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_authorization_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_token_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passcode: Optional[pulumi.Input[_builtins.str]] = None,
                 passcode_in_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preview_features_enabled: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_toml_file_permission_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_accessor: Optional[pulumi.Input['ProviderTokenAccessorArgs']] = None,
                 use_legacy_toml_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_default_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_entra_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_provider: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
        :param pulumi.Input[_builtins.str] authenticator: Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA` | `PROGRAMMATIC_ACCESS_TOKEN` | `OAUTH_CLIENT_CREDENTIALS` | `OAUTH_AUTHORIZATION_CODE` | `WORKLOAD_IDENTITY`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
        :param pulumi.Input[_builtins.str] client_ip: IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
        :param pulumi.Input[_builtins.str] client_request_mfa_token: When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
        :param pulumi.Input[_builtins.str] client_store_temporary_credential: When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
        :param pulumi.Input[_builtins.int] client_timeout: The timeout in seconds for the client to complete the authentication. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] disable_console_login: Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
        :param pulumi.Input[_builtins.bool] disable_query_context_cache: Disables HTAP query context cache in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
        :param pulumi.Input[_builtins.bool] disable_telemetry: Disables telemetry in the driver. Can also be sourced from the `DISABLE_TELEMETRY` environment variable.
        :param pulumi.Input[_builtins.str] driver_tracing: Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
        :param pulumi.Input[_builtins.bool] enable_single_use_refresh_tokens: Enables single use refresh tokens for Snowflake IdP. Can also be sourced from the `SNOWFLAKE_ENABLE_SINGLE_USE_REFRESH_TOKENS` environment variable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] experimental_features_enableds: A list of experimental features. Similarly to preview features, they are not yet stable features of the provider. Enabling given experiment is still considered a preview feature, even when applied to the stable resource. These switches offer experiments altering the provider behavior. If the given experiment is successful, it can be considered an addition in the future provider versions. This field can not be set with environmental variables. Valid options are: `WAREHOUSE_SHOW_IMPROVED_PERFORMANCE`.
        :param pulumi.Input[_builtins.int] external_browser_timeout: The timeout in seconds for the external browser to complete the authentication. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] host: Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
        :param pulumi.Input[_builtins.str] include_retry_reason: Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
        :param pulumi.Input[_builtins.bool] insecure_mode: If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
        :param pulumi.Input[_builtins.int] jwt_client_timeout: The timeout in seconds for the JWT client to complete the authentication. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.int] jwt_expire_timeout: JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.bool] keep_session_alive: Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
        :param pulumi.Input[_builtins.int] login_timeout: Login retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.int] max_retry_count: Specifies how many times non-periodic HTTP request can be retried by the driver. Can also be sourced from the `SNOWFLAKE_MAX_RETRY_COUNT` environment variable.
        :param pulumi.Input[_builtins.str] oauth_authorization_url: Authorization URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_AUTHORIZATION_URL` environment variable.
        :param pulumi.Input[_builtins.str] oauth_client_id: Client id for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        :param pulumi.Input[_builtins.str] oauth_client_secret: Client secret for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Redirect URI registered in IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_REDIRECT_URI` environment variable.
        :param pulumi.Input[_builtins.str] oauth_scope: Comma separated list of scopes. If empty it is derived from role. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_SCOPE` environment variable.
        :param pulumi.Input[_builtins.str] oauth_token_request_url: Token request URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_TOKEN_REQUEST_URL` environment variable.
        :param pulumi.Input[_builtins.str] ocsp_fail_open: True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
        :param pulumi.Input[_builtins.str] okta_url: The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
        :param pulumi.Input[_builtins.str] organization_name: Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters). This field can not be set with environmental variables.
        :param pulumi.Input[_builtins.str] passcode: Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
        :param pulumi.Input[_builtins.bool] passcode_in_password: False by default. Set to true if the MFA passcode is embedded to the configured password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.str] password: Password for user + password or [token](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens#generating-a-programmatic-access-token) for [PAT auth](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens). Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.int] port: Specifies a custom port value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
        :param pulumi.Input[_builtins.str] private_key: Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
        :param pulumi.Input[_builtins.str] private_key_passphrase: Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
        :param pulumi.Input[_builtins.str] profile: Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
        :param pulumi.Input[_builtins.str] protocol: A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
        :param pulumi.Input[_builtins.int] request_timeout: request retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] role: Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
        :param pulumi.Input[_builtins.bool] skip_toml_file_permission_verification: False by default. Skips TOML configuration file permission verification. This flag has no effect on Windows systems, as the permissions are not checked on this platform. Instead of skipping the permissions verification, we recommend setting the proper privileges - see the section below. Can also be sourced from the `SNOWFLAKE_SKIP_TOML_FILE_PERMISSION_VERIFICATION` environment variable.
        :param pulumi.Input[_builtins.str] tmp_directory_path: Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
        :param pulumi.Input[_builtins.str] token: Token to use for OAuth and other forms of token based auth. When this field is set here, or in the TOML file, the provider sets the `authenticator` to `OAUTH`. Optionally, set the `authenticator` field to the authenticator you want to use. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
        :param pulumi.Input['ProviderTokenAccessorArgs'] token_accessor: If you are using the OAuth authentication flows, use the dedicated `authenticator` and `oauth...` fields instead. See our authentication methods guide for more information.
        :param pulumi.Input[_builtins.bool] use_legacy_toml_file: False by default. When this is set to true, the provider expects the legacy TOML format. Otherwise, it expects the new format. See more in the section below Can also be sourced from the `SNOWFLAKE_USE_LEGACY_TOML_FILE` environment variable.
        :param pulumi.Input[_builtins.str] user: Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
        :param pulumi.Input[_builtins.str] validate_default_parameters: True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
        :param pulumi.Input[_builtins.str] warehouse: Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
        :param pulumi.Input[_builtins.str] workload_identity_entra_resource: The resource to use for WIF authentication on Azure environment. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_ENTRA_RESOURCE` environment variable.
        :param pulumi.Input[_builtins.str] workload_identity_provider: The workload identity provider to use for WIF authentication. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_PROVIDER` environment variable.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if authenticator is not None:
            pulumi.set(__self__, "authenticator", authenticator)
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)
        if client_request_mfa_token is not None:
            pulumi.set(__self__, "client_request_mfa_token", client_request_mfa_token)
        if client_store_temporary_credential is not None:
            pulumi.set(__self__, "client_store_temporary_credential", client_store_temporary_credential)
        if client_timeout is not None:
            pulumi.set(__self__, "client_timeout", client_timeout)
        if disable_console_login is not None:
            pulumi.set(__self__, "disable_console_login", disable_console_login)
        if disable_query_context_cache is not None:
            pulumi.set(__self__, "disable_query_context_cache", disable_query_context_cache)
        if disable_telemetry is not None:
            pulumi.set(__self__, "disable_telemetry", disable_telemetry)
        if driver_tracing is not None:
            pulumi.set(__self__, "driver_tracing", driver_tracing)
        if enable_single_use_refresh_tokens is not None:
            pulumi.set(__self__, "enable_single_use_refresh_tokens", enable_single_use_refresh_tokens)
        if experimental_features_enableds is not None:
            pulumi.set(__self__, "experimental_features_enableds", experimental_features_enableds)
        if external_browser_timeout is not None:
            pulumi.set(__self__, "external_browser_timeout", external_browser_timeout)
        if host is None:
            host = _utilities.get_env('SNOWFLAKE_HOST')
        if host is not None:
            pulumi.set(__self__, "host", host)
        if include_retry_reason is not None:
            pulumi.set(__self__, "include_retry_reason", include_retry_reason)
        if insecure_mode is not None:
            pulumi.set(__self__, "insecure_mode", insecure_mode)
        if jwt_client_timeout is not None:
            pulumi.set(__self__, "jwt_client_timeout", jwt_client_timeout)
        if jwt_expire_timeout is not None:
            pulumi.set(__self__, "jwt_expire_timeout", jwt_expire_timeout)
        if keep_session_alive is not None:
            pulumi.set(__self__, "keep_session_alive", keep_session_alive)
        if login_timeout is not None:
            pulumi.set(__self__, "login_timeout", login_timeout)
        if max_retry_count is not None:
            pulumi.set(__self__, "max_retry_count", max_retry_count)
        if oauth_authorization_url is not None:
            pulumi.set(__self__, "oauth_authorization_url", oauth_authorization_url)
        if oauth_client_id is not None:
            pulumi.set(__self__, "oauth_client_id", oauth_client_id)
        if oauth_client_secret is not None:
            pulumi.set(__self__, "oauth_client_secret", oauth_client_secret)
        if oauth_redirect_uri is not None:
            pulumi.set(__self__, "oauth_redirect_uri", oauth_redirect_uri)
        if oauth_scope is not None:
            pulumi.set(__self__, "oauth_scope", oauth_scope)
        if oauth_token_request_url is not None:
            pulumi.set(__self__, "oauth_token_request_url", oauth_token_request_url)
        if ocsp_fail_open is not None:
            pulumi.set(__self__, "ocsp_fail_open", ocsp_fail_open)
        if okta_url is not None:
            pulumi.set(__self__, "okta_url", okta_url)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if passcode is not None:
            pulumi.set(__self__, "passcode", passcode)
        if passcode_in_password is not None:
            pulumi.set(__self__, "passcode_in_password", passcode_in_password)
        if password is None:
            password = _utilities.get_env('SNOWFLAKE_PASSWORD')
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is None:
            port = _utilities.get_env_int('SNOWFLAKE_PORT')
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preview_features_enabled is not None:
            pulumi.set(__self__, "preview_features_enabled", preview_features_enabled)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_passphrase is None:
            private_key_passphrase = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if protocol is None:
            protocol = _utilities.get_env('SNOWFLAKE_PROTOCOL')
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if role is None:
            role = _utilities.get_env('SNOWFLAKE_ROLE')
        if role is not None:
            pulumi.set(__self__, "role", role)
        if skip_toml_file_permission_verification is not None:
            pulumi.set(__self__, "skip_toml_file_permission_verification", skip_toml_file_permission_verification)
        if tmp_directory_path is not None:
            pulumi.set(__self__, "tmp_directory_path", tmp_directory_path)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_accessor is not None:
            pulumi.set(__self__, "token_accessor", token_accessor)
        if use_legacy_toml_file is not None:
            pulumi.set(__self__, "use_legacy_toml_file", use_legacy_toml_file)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if validate_default_parameters is not None:
            pulumi.set(__self__, "validate_default_parameters", validate_default_parameters)
        if warehouse is None:
            warehouse = _utilities.get_env('SNOWFLAKE_WAREHOUSE')
        if warehouse is not None:
            pulumi.set(__self__, "warehouse", warehouse)
        if workload_identity_entra_resource is not None:
            pulumi.set(__self__, "workload_identity_entra_resource", workload_identity_entra_resource)
        if workload_identity_provider is not None:
            pulumi.set(__self__, "workload_identity_provider", workload_identity_provider)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter
    def authenticator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA` | `PROGRAMMATIC_ACCESS_TOKEN` | `OAUTH_CLIENT_CREDENTIALS` | `OAUTH_AUTHORIZATION_CODE` | `WORKLOAD_IDENTITY`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
        """
        return pulumi.get(self, "authenticator")

    @authenticator.setter
    def authenticator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authenticator", value)

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
        """
        return pulumi.get(self, "client_ip")

    @client_ip.setter
    def client_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ip", value)

    @_builtins.property
    @pulumi.getter(name="clientRequestMfaToken")
    def client_request_mfa_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
        """
        return pulumi.get(self, "client_request_mfa_token")

    @client_request_mfa_token.setter
    def client_request_mfa_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_request_mfa_token", value)

    @_builtins.property
    @pulumi.getter(name="clientStoreTemporaryCredential")
    def client_store_temporary_credential(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
        """
        return pulumi.get(self, "client_store_temporary_credential")

    @client_store_temporary_credential.setter
    def client_store_temporary_credential(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_store_temporary_credential", value)

    @_builtins.property
    @pulumi.getter(name="clientTimeout")
    def client_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in seconds for the client to complete the authentication. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "client_timeout")

    @client_timeout.setter
    def client_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_timeout", value)

    @_builtins.property
    @pulumi.getter(name="disableConsoleLogin")
    def disable_console_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
        """
        return pulumi.get(self, "disable_console_login")

    @disable_console_login.setter
    def disable_console_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disable_console_login", value)

    @_builtins.property
    @pulumi.getter(name="disableQueryContextCache")
    def disable_query_context_cache(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables HTAP query context cache in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
        """
        return pulumi.get(self, "disable_query_context_cache")

    @disable_query_context_cache.setter
    def disable_query_context_cache(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_query_context_cache", value)

    @_builtins.property
    @pulumi.getter(name="disableTelemetry")
    def disable_telemetry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables telemetry in the driver. Can also be sourced from the `DISABLE_TELEMETRY` environment variable.
        """
        return pulumi.get(self, "disable_telemetry")

    @disable_telemetry.setter
    def disable_telemetry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_telemetry", value)

    @_builtins.property
    @pulumi.getter(name="driverTracing")
    def driver_tracing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
        """
        return pulumi.get(self, "driver_tracing")

    @driver_tracing.setter
    def driver_tracing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver_tracing", value)

    @_builtins.property
    @pulumi.getter(name="enableSingleUseRefreshTokens")
    def enable_single_use_refresh_tokens(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables single use refresh tokens for Snowflake IdP. Can also be sourced from the `SNOWFLAKE_ENABLE_SINGLE_USE_REFRESH_TOKENS` environment variable.
        """
        return pulumi.get(self, "enable_single_use_refresh_tokens")

    @enable_single_use_refresh_tokens.setter
    def enable_single_use_refresh_tokens(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_single_use_refresh_tokens", value)

    @_builtins.property
    @pulumi.getter(name="experimentalFeaturesEnableds")
    def experimental_features_enableds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of experimental features. Similarly to preview features, they are not yet stable features of the provider. Enabling given experiment is still considered a preview feature, even when applied to the stable resource. These switches offer experiments altering the provider behavior. If the given experiment is successful, it can be considered an addition in the future provider versions. This field can not be set with environmental variables. Valid options are: `WAREHOUSE_SHOW_IMPROVED_PERFORMANCE`.
        """
        return pulumi.get(self, "experimental_features_enableds")

    @experimental_features_enableds.setter
    def experimental_features_enableds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "experimental_features_enableds", value)

    @_builtins.property
    @pulumi.getter(name="externalBrowserTimeout")
    def external_browser_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in seconds for the external browser to complete the authentication. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "external_browser_timeout")

    @external_browser_timeout.setter
    def external_browser_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "external_browser_timeout", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="includeRetryReason")
    def include_retry_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
        """
        return pulumi.get(self, "include_retry_reason")

    @include_retry_reason.setter
    def include_retry_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include_retry_reason", value)

    @_builtins.property
    @pulumi.getter(name="insecureMode")
    def insecure_mode(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
        """
        return pulumi.get(self, "insecure_mode")

    @insecure_mode.setter
    def insecure_mode(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_mode", value)

    @_builtins.property
    @pulumi.getter(name="jwtClientTimeout")
    def jwt_client_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in seconds for the JWT client to complete the authentication. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "jwt_client_timeout")

    @jwt_client_timeout.setter
    def jwt_client_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "jwt_client_timeout", value)

    @_builtins.property
    @pulumi.getter(name="jwtExpireTimeout")
    def jwt_expire_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "jwt_expire_timeout")

    @jwt_expire_timeout.setter
    def jwt_expire_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "jwt_expire_timeout", value)

    @_builtins.property
    @pulumi.getter(name="keepSessionAlive")
    def keep_session_alive(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
        """
        return pulumi.get(self, "keep_session_alive")

    @keep_session_alive.setter
    def keep_session_alive(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_session_alive", value)

    @_builtins.property
    @pulumi.getter(name="loginTimeout")
    def login_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Login retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "login_timeout")

    @login_timeout.setter
    def login_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "login_timeout", value)

    @_builtins.property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how many times non-periodic HTTP request can be retried by the driver. Can also be sourced from the `SNOWFLAKE_MAX_RETRY_COUNT` environment variable.
        """
        return pulumi.get(self, "max_retry_count")

    @max_retry_count.setter
    def max_retry_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retry_count", value)

    @_builtins.property
    @pulumi.getter(name="oauthAuthorizationUrl")
    def oauth_authorization_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_AUTHORIZATION_URL` environment variable.
        """
        return pulumi.get(self, "oauth_authorization_url")

    @oauth_authorization_url.setter
    def oauth_authorization_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_authorization_url", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client id for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "oauth_client_id")

    @oauth_client_id.setter
    def oauth_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_id", value)

    @_builtins.property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "oauth_client_secret")

    @oauth_client_secret.setter
    def oauth_client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_client_secret", value)

    @_builtins.property
    @pulumi.getter(name="oauthRedirectUri")
    def oauth_redirect_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redirect URI registered in IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_REDIRECT_URI` environment variable.
        """
        return pulumi.get(self, "oauth_redirect_uri")

    @oauth_redirect_uri.setter
    def oauth_redirect_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_redirect_uri", value)

    @_builtins.property
    @pulumi.getter(name="oauthScope")
    def oauth_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma separated list of scopes. If empty it is derived from role. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_SCOPE` environment variable.
        """
        return pulumi.get(self, "oauth_scope")

    @oauth_scope.setter
    def oauth_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_scope", value)

    @_builtins.property
    @pulumi.getter(name="oauthTokenRequestUrl")
    def oauth_token_request_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token request URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_TOKEN_REQUEST_URL` environment variable.
        """
        return pulumi.get(self, "oauth_token_request_url")

    @oauth_token_request_url.setter
    def oauth_token_request_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oauth_token_request_url", value)

    @_builtins.property
    @pulumi.getter(name="ocspFailOpen")
    def ocsp_fail_open(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
        """
        return pulumi.get(self, "ocsp_fail_open")

    @ocsp_fail_open.setter
    def ocsp_fail_open(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_fail_open", value)

    @_builtins.property
    @pulumi.getter(name="oktaUrl")
    def okta_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
        """
        return pulumi.get(self, "okta_url")

    @okta_url.setter
    def okta_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "okta_url", value)

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
        """
        return pulumi.get(self, "organization_name")

    @organization_name.setter
    def organization_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_name", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters). This field can not be set with environmental variables.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def passcode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
        """
        return pulumi.get(self, "passcode")

    @passcode.setter
    def passcode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passcode", value)

    @_builtins.property
    @pulumi.getter(name="passcodeInPassword")
    def passcode_in_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        False by default. Set to true if the MFA passcode is embedded to the configured password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
        """
        return pulumi.get(self, "passcode_in_password")

    @passcode_in_password.setter
    def passcode_in_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "passcode_in_password", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for user + password or [token](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens#generating-a-programmatic-access-token) for [PAT auth](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens). Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies a custom port value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="previewFeaturesEnabled")
    def preview_features_enabled(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "preview_features_enabled")

    @preview_features_enabled.setter
    def preview_features_enabled(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preview_features_enabled", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        request retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="skipTomlFilePermissionVerification")
    def skip_toml_file_permission_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        False by default. Skips TOML configuration file permission verification. This flag has no effect on Windows systems, as the permissions are not checked on this platform. Instead of skipping the permissions verification, we recommend setting the proper privileges - see the section below. Can also be sourced from the `SNOWFLAKE_SKIP_TOML_FILE_PERMISSION_VERIFICATION` environment variable.
        """
        return pulumi.get(self, "skip_toml_file_permission_verification")

    @skip_toml_file_permission_verification.setter
    def skip_toml_file_permission_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_toml_file_permission_verification", value)

    @_builtins.property
    @pulumi.getter(name="tmpDirectoryPath")
    def tmp_directory_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
        """
        return pulumi.get(self, "tmp_directory_path")

    @tmp_directory_path.setter
    def tmp_directory_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tmp_directory_path", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token to use for OAuth and other forms of token based auth. When this field is set here, or in the TOML file, the provider sets the `authenticator` to `OAUTH`. Optionally, set the `authenticator` field to the authenticator you want to use. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenAccessor")
    def token_accessor(self) -> Optional[pulumi.Input['ProviderTokenAccessorArgs']]:
        """
        If you are using the OAuth authentication flows, use the dedicated `authenticator` and `oauth...` fields instead. See our authentication methods guide for more information.
        """
        return pulumi.get(self, "token_accessor")

    @token_accessor.setter
    def token_accessor(self, value: Optional[pulumi.Input['ProviderTokenAccessorArgs']]):
        pulumi.set(self, "token_accessor", value)

    @_builtins.property
    @pulumi.getter(name="useLegacyTomlFile")
    def use_legacy_toml_file(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        False by default. When this is set to true, the provider expects the legacy TOML format. Otherwise, it expects the new format. See more in the section below Can also be sourced from the `SNOWFLAKE_USE_LEGACY_TOML_FILE` environment variable.
        """
        return pulumi.get(self, "use_legacy_toml_file")

    @use_legacy_toml_file.setter
    def use_legacy_toml_file(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_legacy_toml_file", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="validateDefaultParameters")
    def validate_default_parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
        """
        return pulumi.get(self, "validate_default_parameters")

    @validate_default_parameters.setter
    def validate_default_parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validate_default_parameters", value)

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
        """
        return pulumi.get(self, "warehouse")

    @warehouse.setter
    def warehouse(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "warehouse", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityEntraResource")
    def workload_identity_entra_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource to use for WIF authentication on Azure environment. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_ENTRA_RESOURCE` environment variable.
        """
        return pulumi.get(self, "workload_identity_entra_resource")

    @workload_identity_entra_resource.setter
    def workload_identity_entra_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_entra_resource", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityProvider")
    def workload_identity_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The workload identity provider to use for WIF authentication. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_PROVIDER` environment variable.
        """
        return pulumi.get(self, "workload_identity_provider")

    @workload_identity_provider.setter
    def workload_identity_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_provider", value)


@pulumi.type_token("pulumi:providers:snowflake")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticator: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 client_request_mfa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 client_store_temporary_credential: Optional[pulumi.Input[_builtins.str]] = None,
                 client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_console_login: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_query_context_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_telemetry: Optional[pulumi.Input[_builtins.bool]] = None,
                 driver_tracing: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_single_use_refresh_tokens: Optional[pulumi.Input[_builtins.bool]] = None,
                 experimental_features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_browser_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 include_retry_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 jwt_client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jwt_expire_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_session_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retry_count: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_authorization_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_token_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passcode: Optional[pulumi.Input[_builtins.str]] = None,
                 passcode_in_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preview_features_enabled: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_toml_file_permission_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_accessor: Optional[pulumi.Input[Union['ProviderTokenAccessorArgs', 'ProviderTokenAccessorArgsDict']]] = None,
                 use_legacy_toml_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_default_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_entra_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the snowflake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
        :param pulumi.Input[_builtins.str] authenticator: Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA` | `PROGRAMMATIC_ACCESS_TOKEN` | `OAUTH_CLIENT_CREDENTIALS` | `OAUTH_AUTHORIZATION_CODE` | `WORKLOAD_IDENTITY`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
        :param pulumi.Input[_builtins.str] client_ip: IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
        :param pulumi.Input[_builtins.str] client_request_mfa_token: When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
        :param pulumi.Input[_builtins.str] client_store_temporary_credential: When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
        :param pulumi.Input[_builtins.int] client_timeout: The timeout in seconds for the client to complete the authentication. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] disable_console_login: Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
        :param pulumi.Input[_builtins.bool] disable_query_context_cache: Disables HTAP query context cache in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
        :param pulumi.Input[_builtins.bool] disable_telemetry: Disables telemetry in the driver. Can also be sourced from the `DISABLE_TELEMETRY` environment variable.
        :param pulumi.Input[_builtins.str] driver_tracing: Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
        :param pulumi.Input[_builtins.bool] enable_single_use_refresh_tokens: Enables single use refresh tokens for Snowflake IdP. Can also be sourced from the `SNOWFLAKE_ENABLE_SINGLE_USE_REFRESH_TOKENS` environment variable.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] experimental_features_enableds: A list of experimental features. Similarly to preview features, they are not yet stable features of the provider. Enabling given experiment is still considered a preview feature, even when applied to the stable resource. These switches offer experiments altering the provider behavior. If the given experiment is successful, it can be considered an addition in the future provider versions. This field can not be set with environmental variables. Valid options are: `WAREHOUSE_SHOW_IMPROVED_PERFORMANCE`.
        :param pulumi.Input[_builtins.int] external_browser_timeout: The timeout in seconds for the external browser to complete the authentication. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] host: Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
        :param pulumi.Input[_builtins.str] include_retry_reason: Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
        :param pulumi.Input[_builtins.bool] insecure_mode: If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
        :param pulumi.Input[_builtins.int] jwt_client_timeout: The timeout in seconds for the JWT client to complete the authentication. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.int] jwt_expire_timeout: JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.bool] keep_session_alive: Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
        :param pulumi.Input[_builtins.int] login_timeout: Login retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.int] max_retry_count: Specifies how many times non-periodic HTTP request can be retried by the driver. Can also be sourced from the `SNOWFLAKE_MAX_RETRY_COUNT` environment variable.
        :param pulumi.Input[_builtins.str] oauth_authorization_url: Authorization URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_AUTHORIZATION_URL` environment variable.
        :param pulumi.Input[_builtins.str] oauth_client_id: Client id for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        :param pulumi.Input[_builtins.str] oauth_client_secret: Client secret for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        :param pulumi.Input[_builtins.str] oauth_redirect_uri: Redirect URI registered in IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_REDIRECT_URI` environment variable.
        :param pulumi.Input[_builtins.str] oauth_scope: Comma separated list of scopes. If empty it is derived from role. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_SCOPE` environment variable.
        :param pulumi.Input[_builtins.str] oauth_token_request_url: Token request URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_TOKEN_REQUEST_URL` environment variable.
        :param pulumi.Input[_builtins.str] ocsp_fail_open: True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
        :param pulumi.Input[_builtins.str] okta_url: The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
        :param pulumi.Input[_builtins.str] organization_name: Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] params: Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters). This field can not be set with environmental variables.
        :param pulumi.Input[_builtins.str] passcode: Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
        :param pulumi.Input[_builtins.bool] passcode_in_password: False by default. Set to true if the MFA passcode is embedded to the configured password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.str] password: Password for user + password or [token](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens#generating-a-programmatic-access-token) for [PAT auth](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens). Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
        :param pulumi.Input[_builtins.int] port: Specifies a custom port value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
        :param pulumi.Input[_builtins.str] private_key: Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
        :param pulumi.Input[_builtins.str] private_key_passphrase: Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
        :param pulumi.Input[_builtins.str] profile: Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
        :param pulumi.Input[_builtins.str] protocol: A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
        :param pulumi.Input[_builtins.int] request_timeout: request retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
        :param pulumi.Input[_builtins.str] role: Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
        :param pulumi.Input[_builtins.bool] skip_toml_file_permission_verification: False by default. Skips TOML configuration file permission verification. This flag has no effect on Windows systems, as the permissions are not checked on this platform. Instead of skipping the permissions verification, we recommend setting the proper privileges - see the section below. Can also be sourced from the `SNOWFLAKE_SKIP_TOML_FILE_PERMISSION_VERIFICATION` environment variable.
        :param pulumi.Input[_builtins.str] tmp_directory_path: Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
        :param pulumi.Input[_builtins.str] token: Token to use for OAuth and other forms of token based auth. When this field is set here, or in the TOML file, the provider sets the `authenticator` to `OAUTH`. Optionally, set the `authenticator` field to the authenticator you want to use. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
        :param pulumi.Input[Union['ProviderTokenAccessorArgs', 'ProviderTokenAccessorArgsDict']] token_accessor: If you are using the OAuth authentication flows, use the dedicated `authenticator` and `oauth...` fields instead. See our authentication methods guide for more information.
        :param pulumi.Input[_builtins.bool] use_legacy_toml_file: False by default. When this is set to true, the provider expects the legacy TOML format. Otherwise, it expects the new format. See more in the section below Can also be sourced from the `SNOWFLAKE_USE_LEGACY_TOML_FILE` environment variable.
        :param pulumi.Input[_builtins.str] user: Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
        :param pulumi.Input[_builtins.str] validate_default_parameters: True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
        :param pulumi.Input[_builtins.str] warehouse: Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
        :param pulumi.Input[_builtins.str] workload_identity_entra_resource: The resource to use for WIF authentication on Azure environment. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_ENTRA_RESOURCE` environment variable.
        :param pulumi.Input[_builtins.str] workload_identity_provider: The workload identity provider to use for WIF authentication. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_PROVIDER` environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the snowflake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authenticator: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 client_request_mfa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 client_store_temporary_credential: Optional[pulumi.Input[_builtins.str]] = None,
                 client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 disable_console_login: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_query_context_cache: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_telemetry: Optional[pulumi.Input[_builtins.bool]] = None,
                 driver_tracing: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_single_use_refresh_tokens: Optional[pulumi.Input[_builtins.bool]] = None,
                 experimental_features_enableds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_browser_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 include_retry_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure_mode: Optional[pulumi.Input[_builtins.bool]] = None,
                 jwt_client_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 jwt_expire_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_session_alive: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retry_count: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth_authorization_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_redirect_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_token_request_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_fail_open: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_url: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_name: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 passcode: Optional[pulumi.Input[_builtins.str]] = None,
                 passcode_in_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preview_features_enabled: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_toml_file_permission_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 tmp_directory_path: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_accessor: Optional[pulumi.Input[Union['ProviderTokenAccessorArgs', 'ProviderTokenAccessorArgsDict']]] = None,
                 use_legacy_toml_file: Optional[pulumi.Input[_builtins.bool]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_default_parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 warehouse: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_entra_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["authenticator"] = authenticator
            __props__.__dict__["client_ip"] = client_ip
            __props__.__dict__["client_request_mfa_token"] = client_request_mfa_token
            __props__.__dict__["client_store_temporary_credential"] = client_store_temporary_credential
            __props__.__dict__["client_timeout"] = pulumi.Output.from_input(client_timeout).apply(pulumi.runtime.to_json) if client_timeout is not None else None
            __props__.__dict__["disable_console_login"] = disable_console_login
            __props__.__dict__["disable_query_context_cache"] = pulumi.Output.from_input(disable_query_context_cache).apply(pulumi.runtime.to_json) if disable_query_context_cache is not None else None
            __props__.__dict__["disable_telemetry"] = pulumi.Output.from_input(disable_telemetry).apply(pulumi.runtime.to_json) if disable_telemetry is not None else None
            __props__.__dict__["driver_tracing"] = driver_tracing
            __props__.__dict__["enable_single_use_refresh_tokens"] = pulumi.Output.from_input(enable_single_use_refresh_tokens).apply(pulumi.runtime.to_json) if enable_single_use_refresh_tokens is not None else None
            __props__.__dict__["experimental_features_enableds"] = pulumi.Output.from_input(experimental_features_enableds).apply(pulumi.runtime.to_json) if experimental_features_enableds is not None else None
            __props__.__dict__["external_browser_timeout"] = pulumi.Output.from_input(external_browser_timeout).apply(pulumi.runtime.to_json) if external_browser_timeout is not None else None
            if host is None:
                host = _utilities.get_env('SNOWFLAKE_HOST')
            __props__.__dict__["host"] = host
            __props__.__dict__["include_retry_reason"] = include_retry_reason
            __props__.__dict__["insecure_mode"] = pulumi.Output.from_input(insecure_mode).apply(pulumi.runtime.to_json) if insecure_mode is not None else None
            __props__.__dict__["jwt_client_timeout"] = pulumi.Output.from_input(jwt_client_timeout).apply(pulumi.runtime.to_json) if jwt_client_timeout is not None else None
            __props__.__dict__["jwt_expire_timeout"] = pulumi.Output.from_input(jwt_expire_timeout).apply(pulumi.runtime.to_json) if jwt_expire_timeout is not None else None
            __props__.__dict__["keep_session_alive"] = pulumi.Output.from_input(keep_session_alive).apply(pulumi.runtime.to_json) if keep_session_alive is not None else None
            __props__.__dict__["login_timeout"] = pulumi.Output.from_input(login_timeout).apply(pulumi.runtime.to_json) if login_timeout is not None else None
            __props__.__dict__["max_retry_count"] = pulumi.Output.from_input(max_retry_count).apply(pulumi.runtime.to_json) if max_retry_count is not None else None
            __props__.__dict__["oauth_authorization_url"] = None if oauth_authorization_url is None else pulumi.Output.secret(oauth_authorization_url)
            __props__.__dict__["oauth_client_id"] = None if oauth_client_id is None else pulumi.Output.secret(oauth_client_id)
            __props__.__dict__["oauth_client_secret"] = None if oauth_client_secret is None else pulumi.Output.secret(oauth_client_secret)
            __props__.__dict__["oauth_redirect_uri"] = None if oauth_redirect_uri is None else pulumi.Output.secret(oauth_redirect_uri)
            __props__.__dict__["oauth_scope"] = oauth_scope
            __props__.__dict__["oauth_token_request_url"] = None if oauth_token_request_url is None else pulumi.Output.secret(oauth_token_request_url)
            __props__.__dict__["ocsp_fail_open"] = ocsp_fail_open
            __props__.__dict__["okta_url"] = okta_url
            __props__.__dict__["organization_name"] = organization_name
            __props__.__dict__["params"] = pulumi.Output.from_input(params).apply(pulumi.runtime.to_json) if params is not None else None
            __props__.__dict__["passcode"] = None if passcode is None else pulumi.Output.secret(passcode)
            __props__.__dict__["passcode_in_password"] = pulumi.Output.from_input(passcode_in_password).apply(pulumi.runtime.to_json) if passcode_in_password is not None else None
            if password is None:
                password = _utilities.get_env('SNOWFLAKE_PASSWORD')
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if port is None:
                port = _utilities.get_env_int('SNOWFLAKE_PORT')
            __props__.__dict__["port"] = pulumi.Output.from_input(port).apply(pulumi.runtime.to_json) if port is not None else None
            __props__.__dict__["preview_features_enabled"] = pulumi.Output.from_input(preview_features_enabled).apply(pulumi.runtime.to_json) if preview_features_enabled is not None else None
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if private_key_passphrase is None:
                private_key_passphrase = _utilities.get_env('SNOWFLAKE_PRIVATE_KEY_PASSPHRASE')
            __props__.__dict__["private_key_passphrase"] = None if private_key_passphrase is None else pulumi.Output.secret(private_key_passphrase)
            __props__.__dict__["profile"] = profile
            if protocol is None:
                protocol = _utilities.get_env('SNOWFLAKE_PROTOCOL')
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["request_timeout"] = pulumi.Output.from_input(request_timeout).apply(pulumi.runtime.to_json) if request_timeout is not None else None
            if role is None:
                role = _utilities.get_env('SNOWFLAKE_ROLE')
            __props__.__dict__["role"] = role
            __props__.__dict__["skip_toml_file_permission_verification"] = pulumi.Output.from_input(skip_toml_file_permission_verification).apply(pulumi.runtime.to_json) if skip_toml_file_permission_verification is not None else None
            __props__.__dict__["tmp_directory_path"] = tmp_directory_path
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["token_accessor"] = pulumi.Output.from_input(token_accessor).apply(pulumi.runtime.to_json) if token_accessor is not None else None
            __props__.__dict__["use_legacy_toml_file"] = pulumi.Output.from_input(use_legacy_toml_file).apply(pulumi.runtime.to_json) if use_legacy_toml_file is not None else None
            __props__.__dict__["user"] = user
            __props__.__dict__["validate_default_parameters"] = validate_default_parameters
            if warehouse is None:
                warehouse = _utilities.get_env('SNOWFLAKE_WAREHOUSE')
            __props__.__dict__["warehouse"] = warehouse
            __props__.__dict__["workload_identity_entra_resource"] = workload_identity_entra_resource
            __props__.__dict__["workload_identity_provider"] = workload_identity_provider
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["oauthAuthorizationUrl", "oauthClientId", "oauthClientSecret", "oauthRedirectUri", "oauthTokenRequestUrl", "passcode", "password", "privateKey", "privateKeyPassphrase", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'snowflake',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def authenticator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA` | `PROGRAMMATIC_ACCESS_TOKEN` | `OAUTH_CLIENT_CREDENTIALS` | `OAUTH_AUTHORIZATION_CODE` | `WORKLOAD_IDENTITY`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
        """
        return pulumi.get(self, "authenticator")

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
        """
        return pulumi.get(self, "client_ip")

    @_builtins.property
    @pulumi.getter(name="clientRequestMfaToken")
    def client_request_mfa_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
        """
        return pulumi.get(self, "client_request_mfa_token")

    @_builtins.property
    @pulumi.getter(name="clientStoreTemporaryCredential")
    def client_store_temporary_credential(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
        """
        return pulumi.get(self, "client_store_temporary_credential")

    @_builtins.property
    @pulumi.getter(name="disableConsoleLogin")
    def disable_console_login(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
        """
        return pulumi.get(self, "disable_console_login")

    @_builtins.property
    @pulumi.getter(name="driverTracing")
    def driver_tracing(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
        """
        return pulumi.get(self, "driver_tracing")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="includeRetryReason")
    def include_retry_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
        """
        return pulumi.get(self, "include_retry_reason")

    @_builtins.property
    @pulumi.getter(name="oauthAuthorizationUrl")
    def oauth_authorization_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authorization URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_AUTHORIZATION_URL` environment variable.
        """
        return pulumi.get(self, "oauth_authorization_url")

    @_builtins.property
    @pulumi.getter(name="oauthClientId")
    def oauth_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client id for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_ID` environment variable.
        """
        return pulumi.get(self, "oauth_client_id")

    @_builtins.property
    @pulumi.getter(name="oauthClientSecret")
    def oauth_client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client secret for OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_CLIENT_SECRET` environment variable.
        """
        return pulumi.get(self, "oauth_client_secret")

    @_builtins.property
    @pulumi.getter(name="oauthRedirectUri")
    def oauth_redirect_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Redirect URI registered in IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_REDIRECT_URI` environment variable.
        """
        return pulumi.get(self, "oauth_redirect_uri")

    @_builtins.property
    @pulumi.getter(name="oauthScope")
    def oauth_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comma separated list of scopes. If empty it is derived from role. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_SCOPE` environment variable.
        """
        return pulumi.get(self, "oauth_scope")

    @_builtins.property
    @pulumi.getter(name="oauthTokenRequestUrl")
    def oauth_token_request_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Token request URL of OAuth2 external IdP. See [Snowflake OAuth documentation](https://docs.snowflake.com/en/user-guide/oauth). Can also be sourced from the `SNOWFLAKE_OAUTH_TOKEN_REQUEST_URL` environment variable.
        """
        return pulumi.get(self, "oauth_token_request_url")

    @_builtins.property
    @pulumi.getter(name="ocspFailOpen")
    def ocsp_fail_open(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
        """
        return pulumi.get(self, "ocsp_fail_open")

    @_builtins.property
    @pulumi.getter(name="oktaUrl")
    def okta_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
        """
        return pulumi.get(self, "okta_url")

    @_builtins.property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
        """
        return pulumi.get(self, "organization_name")

    @_builtins.property
    @pulumi.getter
    def passcode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
        """
        return pulumi.get(self, "passcode")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password for user + password or [token](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens#generating-a-programmatic-access-token) for [PAT auth](https://docs.snowflake.com/en/user-guide/programmatic-access-tokens). Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
        """
        return pulumi.get(self, "private_key_passphrase")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="tmpDirectoryPath")
    def tmp_directory_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
        """
        return pulumi.get(self, "tmp_directory_path")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Token to use for OAuth and other forms of token based auth. When this field is set here, or in the TOML file, the provider sets the `authenticator` to `OAUTH`. Optionally, set the `authenticator` field to the authenticator you want to use. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="validateDefaultParameters")
    def validate_default_parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
        """
        return pulumi.get(self, "validate_default_parameters")

    @_builtins.property
    @pulumi.getter
    def warehouse(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
        """
        return pulumi.get(self, "warehouse")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityEntraResource")
    def workload_identity_entra_resource(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource to use for WIF authentication on Azure environment. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_ENTRA_RESOURCE` environment variable.
        """
        return pulumi.get(self, "workload_identity_entra_resource")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityProvider")
    def workload_identity_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The workload identity provider to use for WIF authentication. Can also be sourced from the `SNOWFLAKE_WORKLOAD_IDENTITY_PROVIDER` environment variable.
        """
        return pulumi.get(self, "workload_identity_provider")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:snowflake/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

