# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['Saml2IntegrationArgs', 'Saml2Integration']

@pulumi.input_type
class Saml2IntegrationArgs:
    def __init__(__self__, *,
                 saml2_issuer: pulumi.Input[_builtins.str],
                 saml2_provider: pulumi.Input[_builtins.str],
                 saml2_sso_url: pulumi.Input[_builtins.str],
                 saml2_x509_cert: pulumi.Input[_builtins.str],
                 allowed_email_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_force_authn: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Saml2Integration resource.
        :param pulumi.Input[_builtins.str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[_builtins.str] saml2_provider: The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[_builtins.str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_email_patterns: A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_domains: A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] saml2_enable_sp_initiated: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_force_authn: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[_builtins.str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        :param pulumi.Input[_builtins.str] saml2_sign_request: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        pulumi.set(__self__, "saml2_issuer", saml2_issuer)
        pulumi.set(__self__, "saml2_provider", saml2_provider)
        pulumi.set(__self__, "saml2_sso_url", saml2_sso_url)
        pulumi.set(__self__, "saml2_x509_cert", saml2_x509_cert)
        if allowed_email_patterns is not None:
            pulumi.set(__self__, "allowed_email_patterns", allowed_email_patterns)
        if allowed_user_domains is not None:
            pulumi.set(__self__, "allowed_user_domains", allowed_user_domains)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml2_enable_sp_initiated is not None:
            pulumi.set(__self__, "saml2_enable_sp_initiated", saml2_enable_sp_initiated)
        if saml2_force_authn is not None:
            pulumi.set(__self__, "saml2_force_authn", saml2_force_authn)
        if saml2_post_logout_redirect_url is not None:
            pulumi.set(__self__, "saml2_post_logout_redirect_url", saml2_post_logout_redirect_url)
        if saml2_requested_nameid_format is not None:
            pulumi.set(__self__, "saml2_requested_nameid_format", saml2_requested_nameid_format)
        if saml2_sign_request is not None:
            pulumi.set(__self__, "saml2_sign_request", saml2_sign_request)
        if saml2_snowflake_acs_url is not None:
            pulumi.set(__self__, "saml2_snowflake_acs_url", saml2_snowflake_acs_url)
        if saml2_snowflake_issuer_url is not None:
            pulumi.set(__self__, "saml2_snowflake_issuer_url", saml2_snowflake_issuer_url)
        if saml2_sp_initiated_login_page_label is not None:
            pulumi.set(__self__, "saml2_sp_initiated_login_page_label", saml2_sp_initiated_login_page_label)

    @_builtins.property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> pulumi.Input[_builtins.str]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @saml2_issuer.setter
    def saml2_issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saml2_issuer", value)

    @_builtins.property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        """
        return pulumi.get(self, "saml2_provider")

    @saml2_provider.setter
    def saml2_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saml2_provider", value)

    @_builtins.property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> pulumi.Input[_builtins.str]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @saml2_sso_url.setter
    def saml2_sso_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saml2_sso_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> pulumi.Input[_builtins.str]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

    @saml2_x509_cert.setter
    def saml2_x509_cert(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "saml2_x509_cert", value)

    @_builtins.property
    @pulumi.getter(name="allowedEmailPatterns")
    def allowed_email_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_email_patterns")

    @allowed_email_patterns.setter
    def allowed_email_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_email_patterns", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserDomains")
    def allowed_user_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_user_domains")

    @allowed_user_domains.setter
    def allowed_user_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_user_domains", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @saml2_enable_sp_initiated.setter
    def saml2_enable_sp_initiated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_enable_sp_initiated", value)

    @_builtins.property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_force_authn")

    @saml2_force_authn.setter
    def saml2_force_authn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_force_authn", value)

    @_builtins.property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @saml2_post_logout_redirect_url.setter
    def saml2_post_logout_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_post_logout_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @saml2_requested_nameid_format.setter
    def saml2_requested_nameid_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_requested_nameid_format", value)

    @_builtins.property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_sign_request")

    @saml2_sign_request.setter
    def saml2_sign_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_sign_request", value)

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @saml2_snowflake_acs_url.setter
    def saml2_snowflake_acs_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_snowflake_acs_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @saml2_snowflake_issuer_url.setter
    def saml2_snowflake_issuer_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_snowflake_issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @saml2_sp_initiated_login_page_label.setter
    def saml2_sp_initiated_login_page_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_sp_initiated_login_page_label", value)


@pulumi.input_type
class _Saml2IntegrationState:
    def __init__(__self__, *,
                 allowed_email_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationDescribeOutputArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_force_authn: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering Saml2Integration resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_email_patterns: A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_domains: A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] saml2_enable_sp_initiated: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_force_authn: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[_builtins.str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[_builtins.str] saml2_provider: The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        :param pulumi.Input[_builtins.str] saml2_sign_request: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[_builtins.str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        :param pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        if allowed_email_patterns is not None:
            pulumi.set(__self__, "allowed_email_patterns", allowed_email_patterns)
        if allowed_user_domains is not None:
            pulumi.set(__self__, "allowed_user_domains", allowed_user_domains)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if saml2_enable_sp_initiated is not None:
            pulumi.set(__self__, "saml2_enable_sp_initiated", saml2_enable_sp_initiated)
        if saml2_force_authn is not None:
            pulumi.set(__self__, "saml2_force_authn", saml2_force_authn)
        if saml2_issuer is not None:
            pulumi.set(__self__, "saml2_issuer", saml2_issuer)
        if saml2_post_logout_redirect_url is not None:
            pulumi.set(__self__, "saml2_post_logout_redirect_url", saml2_post_logout_redirect_url)
        if saml2_provider is not None:
            pulumi.set(__self__, "saml2_provider", saml2_provider)
        if saml2_requested_nameid_format is not None:
            pulumi.set(__self__, "saml2_requested_nameid_format", saml2_requested_nameid_format)
        if saml2_sign_request is not None:
            pulumi.set(__self__, "saml2_sign_request", saml2_sign_request)
        if saml2_snowflake_acs_url is not None:
            pulumi.set(__self__, "saml2_snowflake_acs_url", saml2_snowflake_acs_url)
        if saml2_snowflake_issuer_url is not None:
            pulumi.set(__self__, "saml2_snowflake_issuer_url", saml2_snowflake_issuer_url)
        if saml2_sp_initiated_login_page_label is not None:
            pulumi.set(__self__, "saml2_sp_initiated_login_page_label", saml2_sp_initiated_login_page_label)
        if saml2_sso_url is not None:
            pulumi.set(__self__, "saml2_sso_url", saml2_sso_url)
        if saml2_x509_cert is not None:
            pulumi.set(__self__, "saml2_x509_cert", saml2_x509_cert)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="allowedEmailPatterns")
    def allowed_email_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_email_patterns")

    @allowed_email_patterns.setter
    def allowed_email_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_email_patterns", value)

    @_builtins.property
    @pulumi.getter(name="allowedUserDomains")
    def allowed_user_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_user_domains")

    @allowed_user_domains.setter
    def allowed_user_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_user_domains", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @saml2_enable_sp_initiated.setter
    def saml2_enable_sp_initiated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_enable_sp_initiated", value)

    @_builtins.property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_force_authn")

    @saml2_force_authn.setter
    def saml2_force_authn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_force_authn", value)

    @_builtins.property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @saml2_issuer.setter
    def saml2_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_issuer", value)

    @_builtins.property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @saml2_post_logout_redirect_url.setter
    def saml2_post_logout_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_post_logout_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        """
        return pulumi.get(self, "saml2_provider")

    @saml2_provider.setter
    def saml2_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_provider", value)

    @_builtins.property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @saml2_requested_nameid_format.setter
    def saml2_requested_nameid_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_requested_nameid_format", value)

    @_builtins.property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_sign_request")

    @saml2_sign_request.setter
    def saml2_sign_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_sign_request", value)

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @saml2_snowflake_acs_url.setter
    def saml2_snowflake_acs_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_snowflake_acs_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @saml2_snowflake_issuer_url.setter
    def saml2_snowflake_issuer_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_snowflake_issuer_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @saml2_sp_initiated_login_page_label.setter
    def saml2_sp_initiated_login_page_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_sp_initiated_login_page_label", value)

    @_builtins.property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @saml2_sso_url.setter
    def saml2_sso_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_sso_url", value)

    @_builtins.property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

    @saml2_x509_cert.setter
    def saml2_x509_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "saml2_x509_cert", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Saml2IntegrationShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/saml2Integration:Saml2Integration")
class Saml2Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_email_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_force_authn: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/saml2Integration:Saml2Integration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_email_patterns: A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_domains: A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] saml2_enable_sp_initiated: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_force_authn: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[_builtins.str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[_builtins.str] saml2_provider: The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        :param pulumi.Input[_builtins.str] saml2_sign_request: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[_builtins.str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Saml2IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/saml2Integration:Saml2Integration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param Saml2IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Saml2IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_email_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_enable_sp_initiated: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_force_authn: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_post_logout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_requested_nameid_format: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sign_request: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_snowflake_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sp_initiated_login_page_label: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 saml2_x509_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Saml2IntegrationArgs.__new__(Saml2IntegrationArgs)

            __props__.__dict__["allowed_email_patterns"] = allowed_email_patterns
            __props__.__dict__["allowed_user_domains"] = allowed_user_domains
            __props__.__dict__["comment"] = comment
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["saml2_enable_sp_initiated"] = saml2_enable_sp_initiated
            __props__.__dict__["saml2_force_authn"] = saml2_force_authn
            if saml2_issuer is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_issuer'")
            __props__.__dict__["saml2_issuer"] = saml2_issuer
            __props__.__dict__["saml2_post_logout_redirect_url"] = saml2_post_logout_redirect_url
            if saml2_provider is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_provider'")
            __props__.__dict__["saml2_provider"] = saml2_provider
            __props__.__dict__["saml2_requested_nameid_format"] = saml2_requested_nameid_format
            __props__.__dict__["saml2_sign_request"] = saml2_sign_request
            __props__.__dict__["saml2_snowflake_acs_url"] = saml2_snowflake_acs_url
            __props__.__dict__["saml2_snowflake_issuer_url"] = saml2_snowflake_issuer_url
            __props__.__dict__["saml2_sp_initiated_login_page_label"] = saml2_sp_initiated_login_page_label
            if saml2_sso_url is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_sso_url'")
            __props__.__dict__["saml2_sso_url"] = saml2_sso_url
            if saml2_x509_cert is None and not opts.urn:
                raise TypeError("Missing required property 'saml2_x509_cert'")
            __props__.__dict__["saml2_x509_cert"] = None if saml2_x509_cert is None else pulumi.Output.secret(saml2_x509_cert)
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["saml2X509Cert"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Saml2Integration, __self__).__init__(
            'snowflake:index/saml2Integration:Saml2Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_email_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_user_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Saml2IntegrationDescribeOutputArgs', 'Saml2IntegrationDescribeOutputArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_enable_sp_initiated: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_force_authn: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_post_logout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_provider: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_requested_nameid_format: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_sign_request: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_snowflake_acs_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_snowflake_issuer_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_sp_initiated_login_page_label: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_sso_url: Optional[pulumi.Input[_builtins.str]] = None,
            saml2_x509_cert: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['Saml2IntegrationShowOutputArgs', 'Saml2IntegrationShowOutputArgsDict']]]]] = None) -> 'Saml2Integration':
        """
        Get an existing Saml2Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_email_patterns: A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_user_domains: A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['Saml2IntegrationDescribeOutputArgs', 'Saml2IntegrationDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        :param pulumi.Input[_builtins.str] enabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] saml2_enable_sp_initiated: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_force_authn: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_issuer: The string containing the IdP EntityID / Issuer.
        :param pulumi.Input[_builtins.str] saml2_post_logout_redirect_url: The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        :param pulumi.Input[_builtins.str] saml2_provider: The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        :param pulumi.Input[_builtins.str] saml2_requested_nameid_format: The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        :param pulumi.Input[_builtins.str] saml2_sign_request: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.str] saml2_snowflake_acs_url: The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_snowflake_issuer_url: The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        :param pulumi.Input[_builtins.str] saml2_sp_initiated_login_page_label: The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        :param pulumi.Input[_builtins.str] saml2_sso_url: The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        :param pulumi.Input[_builtins.str] saml2_x509_cert: The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        :param pulumi.Input[Sequence[pulumi.Input[Union['Saml2IntegrationShowOutputArgs', 'Saml2IntegrationShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Saml2IntegrationState.__new__(_Saml2IntegrationState)

        __props__.__dict__["allowed_email_patterns"] = allowed_email_patterns
        __props__.__dict__["allowed_user_domains"] = allowed_user_domains
        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["saml2_enable_sp_initiated"] = saml2_enable_sp_initiated
        __props__.__dict__["saml2_force_authn"] = saml2_force_authn
        __props__.__dict__["saml2_issuer"] = saml2_issuer
        __props__.__dict__["saml2_post_logout_redirect_url"] = saml2_post_logout_redirect_url
        __props__.__dict__["saml2_provider"] = saml2_provider
        __props__.__dict__["saml2_requested_nameid_format"] = saml2_requested_nameid_format
        __props__.__dict__["saml2_sign_request"] = saml2_sign_request
        __props__.__dict__["saml2_snowflake_acs_url"] = saml2_snowflake_acs_url
        __props__.__dict__["saml2_snowflake_issuer_url"] = saml2_snowflake_issuer_url
        __props__.__dict__["saml2_sp_initiated_login_page_label"] = saml2_sp_initiated_login_page_label
        __props__.__dict__["saml2_sso_url"] = saml2_sso_url
        __props__.__dict__["saml2_x509_cert"] = saml2_x509_cert
        __props__.__dict__["show_outputs"] = show_outputs
        return Saml2Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedEmailPatterns")
    def allowed_email_patterns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of regular expressions that email addresses are matched against to authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_email_patterns")

    @_builtins.property
    @pulumi.getter(name="allowedUserDomains")
    def allowed_user_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of email domains that can authenticate with a SAML2 security integration. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "allowed_user_domains")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.Saml2IntegrationDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether this security integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the SAML2 integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="saml2EnableSpInitiated")
    def saml2_enable_sp_initiated(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating if the Log In With button will be shown on the login page. TRUE: displays the Log in With button on the login page. FALSE: does not display the Log in With button on the login page. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_enable_sp_initiated")

    @_builtins.property
    @pulumi.getter(name="saml2ForceAuthn")
    def saml2_force_authn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake. When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_force_authn")

    @_builtins.property
    @pulumi.getter(name="saml2Issuer")
    def saml2_issuer(self) -> pulumi.Output[_builtins.str]:
        """
        The string containing the IdP EntityID / Issuer.
        """
        return pulumi.get(self, "saml2_issuer")

    @_builtins.property
    @pulumi.getter(name="saml2PostLogoutRedirectUrl")
    def saml2_post_logout_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface. Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
        """
        return pulumi.get(self, "saml2_post_logout_redirect_url")

    @_builtins.property
    @pulumi.getter(name="saml2Provider")
    def saml2_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The string describing the IdP. Valid options are: `OKTA` | `ADFS` | `CUSTOM`.
        """
        return pulumi.get(self, "saml2_provider")

    @_builtins.property
    @pulumi.getter(name="saml2RequestedNameidFormat")
    def saml2_requested_nameid_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. Valid options are: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified` | `urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress` | `urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName` | `urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName` | `urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos` | `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent` | `urn:oasis:names:tc:SAML:2.0:nameid-format:transient`.
        """
        return pulumi.get(self, "saml2_requested_nameid_format")

    @_builtins.property
    @pulumi.getter(name="saml2SignRequest")
    def saml2_sign_request(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) The Boolean indicating whether SAML requests are signed. TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "saml2_sign_request")

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeAcsUrl")
    def saml2_snowflake_acs_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake. This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_acs_url")

    @_builtins.property
    @pulumi.getter(name="saml2SnowflakeIssuerUrl")
    def saml2_snowflake_issuer_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string containing the EntityID / Issuer for the Snowflake service provider. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Because Okta does not support underscores in URLs, the underscore in the account name must be converted to a hyphen. See [docs](https://docs.snowflake.com/en/user-guide/organizations-connect#okta-urls).
        """
        return pulumi.get(self, "saml2_snowflake_issuer_url")

    @_builtins.property
    @pulumi.getter(name="saml2SpInitiatedLoginPageLabel")
    def saml2_sp_initiated_login_page_label(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The string containing the label to display after the Log In With button on the login page. If this field changes value from non-empty to empty, the whole resource is recreated because of Snowflake limitations.
        """
        return pulumi.get(self, "saml2_sp_initiated_login_page_label")

    @_builtins.property
    @pulumi.getter(name="saml2SsoUrl")
    def saml2_sso_url(self) -> pulumi.Output[_builtins.str]:
        """
        The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
        """
        return pulumi.get(self, "saml2_sso_url")

    @_builtins.property
    @pulumi.getter(name="saml2X509Cert")
    def saml2_x509_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
        """
        return pulumi.get(self, "saml2_x509_cert")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.Saml2IntegrationShowOutput']]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATION` for the given integration.
        """
        return pulumi.get(self, "show_outputs")

