import { aws_ses as ses, aws_logs as logs, aws_events as events } from "aws-cdk-lib";
import { Construct } from "constructs";
/**
 * Properties for `SesCloudWatch`.
 */
export interface SesCloudWatchProps {
    /**
     * (Optional) Explicit name for the CloudWatch LogGroup that will receive
     * the SES event logs. If omitted, the LogGroup name will be automatically
     * generated by CloudFormation.
     */
    readonly logGroupName?: string;
    /**
     * (Optional) Explicit name for the SES Configuration Set. If not provided
     * a name will be derived using the pattern:
     * `${Stack.of(this).stackName}-ses-config-set`.
     */
    readonly configurationSetName?: string;
    /**
     * (Optional) Explicit name for the EventBridge Rule that captures SES events.
     * If not provided a name will be derived using the pattern:
     * `${Stack.of(this).stackName}-ses-event-rule`.
     */
    readonly eventRuleName?: string;
    /**
     * (Optional) The events to capture from SES. Defaults to SEND.
     */
    readonly events?: ses.EmailSendingEvent[];
}
/**
 * A construct that wires Amazon SES sending events into CloudWatch Logs via
 * EventBridge. It creates:
 *  - A CloudWatch LogGroup (optionally named) to store SES event logs
 *  - An SES Configuration Set (optionally named)
 *  - An EventBridge Rule that matches all SES events
 *  - A Configuration Set Event Destination that routes SEND events to the
 *    default EventBridge bus so they are captured by the rule and forwarded
 *    to the LogGroup.
 */
export declare class SesCloudWatch extends Construct {
    /** The CloudWatch LogGroup used to store SES event data. */
    readonly logGroup: logs.LogGroup;
    /** The SES Configuration Set whose events are being published. */
    readonly configurationSet: ses.ConfigurationSet;
    /** The EventBridge Rule that captures SES events. */
    readonly eventRule: events.Rule;
    constructor(scope: Construct, id: string, props?: SesCloudWatchProps);
}
