"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesCloudWatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * A construct that wires Amazon SES sending events into CloudWatch Logs via
 * EventBridge. It creates:
 *  - A CloudWatch LogGroup (optionally named) to store SES event logs
 *  - An SES Configuration Set (optionally named)
 *  - An EventBridge Rule that matches all SES events
 *  - A Configuration Set Event Destination that routes SEND events to the
 *    default EventBridge bus so they are captured by the rule and forwarded
 *    to the LogGroup.
 */
class SesCloudWatch extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        // CloudWatch LogGroup to receive SES events. Name is optional.
        this.logGroup = new aws_cdk_lib_1.aws_logs.LogGroup(this, "SesEmailLogGroup", {
            logGroupName: props.logGroupName,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
        // SES Configuration Set with optional custom name.
        this.configurationSet = new aws_cdk_lib_1.aws_ses.ConfigurationSet(this, "SesConfigurationSet", {
            configurationSetName: props.configurationSetName ||
                `${aws_cdk_lib_1.Stack.of(this).stackName}-ses-config-set`,
        });
        // EventBridge rule to match SES events published for this configuration set
        // EventBridge rule to match all SES events (source = aws.ses),
        // but only for the specified configuration set
        this.eventRule = new aws_cdk_lib_1.aws_events.Rule(this, "SesEventRule", {
            eventPattern: {
                source: ["aws.ses"],
                resources: [
                    `arn:aws:ses:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:configuration-set/${this.configurationSet.configurationSetName}`,
                ],
            },
        });
        // EventBridge target for SES events
        this.eventRule.addTarget(new aws_cdk_lib_1.aws_events_targets.CloudWatchLogGroup(this.logGroup));
        // Send the configuration set events to the resolved event bus
        this.configurationSet.addEventDestination("SesEventDestination", {
            destination: aws_cdk_lib_1.aws_ses.EventDestination.eventBus(aws_cdk_lib_1.aws_events.EventBus.fromEventBusName(this, props.eventRuleName ?? "DefaultEventBus", "default")),
            events: props.events ?? [aws_cdk_lib_1.aws_ses.EmailSendingEvent.SEND],
        });
    }
}
exports.SesCloudWatch = SesCloudWatch;
_a = JSII_RTTI_SYMBOL_1;
SesCloudWatch[_a] = { fqn: "ses-cloudwatch.SesCloudWatch", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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