r'''
# ses-cloudwatch

Small CDK construct that routes Amazon SES sending events to a CloudWatch LogGroup through EventBridge. It creates:

* CloudWatch LogGroup (optionally named)
* SES Configuration Set (optionally named)
* EventBridge Rule (matches all `aws.ses` events)
* Configuration Set Event Destination that sends `SEND` events to the default EventBridge bus which the rule targets to the LogGroup

## Install

Add as a dependency to your CDK app (peer deps `aws-cdk-lib` and `constructs` must already be present at compatible versions):

```bash
npm install ses-cloudwatch
```

## Usage

```python
import { Stack } from 'aws-cdk-lib';
import { SesCloudWatch } from 'ses-cloudwatch';

class MyStack extends Stack {
	constructor(scope: Construct, id: string) {
		super(scope, id);

		new SesCloudWatch(this, 'SesEvents');
	}
}
```

### With custom names

```python
new SesCloudWatch(this, 'SesEvents', {
	logGroupName: 'my-ses-event-logs',
	configurationSetName: 'marketing-emails',
	eventRuleName: 'marketing-emails-events',
});
```

### Capturing additional SES events

By default only `SEND` events are forwarded. Supply the `events` prop to include more:

```python
import { aws_ses as ses } from 'aws-cdk-lib';

new SesCloudWatch(this, 'SesEvents', {
	events: [
		ses.EmailSendingEvent.SEND,
		ses.EmailSendingEvent.REJECT,
		ses.EmailSendingEvent.DELIVERY,
	],
});
```

## Props

| Name | Type | Default | Description |
| ---- | ---- | ------- | ----------- |
| `logGroupName` | `string?` | auto-generated by CloudFormation | Explicit name for the CloudWatch LogGroup that stores SES events. |
| `configurationSetName` | `string?` | `<stackName>-ses-config-set` | Name for the SES Configuration Set whose events are logged. |
| `eventRuleName` | `string?` | `<stackName>-ses-event-rule` | Name for the EventBridge Rule that matches SES events. |
| `events` | `ses.EmailSendingEvent[]?` | `[ses.EmailSendingEvent.SEND]` | Set of SES sending event types to capture. |

## Testing

Run the Jest tests (auto-generated by projen) which validate both default and custom prop behavior:

```bash
npm test
```

## License

Apache-2.0
'''
from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from ._jsii import *

import aws_cdk.aws_events as _aws_cdk_aws_events_ceddda9d
import aws_cdk.aws_logs as _aws_cdk_aws_logs_ceddda9d
import aws_cdk.aws_ses as _aws_cdk_aws_ses_ceddda9d
import constructs as _constructs_77d1e7e8


class SesCloudWatch(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="ses-cloudwatch.SesCloudWatch",
):
    '''A construct that wires Amazon SES sending events into CloudWatch Logs via EventBridge.

    It creates:

    - A CloudWatch LogGroup (optionally named) to store SES event logs
    - An SES Configuration Set (optionally named)
    - An EventBridge Rule that matches all SES events
    - A Configuration Set Event Destination that routes SEND events to the
      default EventBridge bus so they are captured by the rule and forwarded
      to the LogGroup.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        configuration_set_name: typing.Optional[builtins.str] = None,
        event_rule_name: typing.Optional[builtins.str] = None,
        events: typing.Optional[typing.Sequence[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]] = None,
        log_group_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param configuration_set_name: (Optional) Explicit name for the SES Configuration Set. If not provided a name will be derived using the pattern: ``${Stack.of(this).stackName}-ses-config-set``.
        :param event_rule_name: (Optional) Explicit name for the EventBridge Rule that captures SES events. If not provided a name will be derived using the pattern: ``${Stack.of(this).stackName}-ses-event-rule``.
        :param events: (Optional) The events to capture from SES. Defaults to SEND.
        :param log_group_name: (Optional) Explicit name for the CloudWatch LogGroup that will receive the SES event logs. If omitted, the LogGroup name will be automatically generated by CloudFormation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6195a0780c353035bc6470bdd6dc2515442c5d098f24e3922be3bf02aa5a558)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SesCloudWatchProps(
            configuration_set_name=configuration_set_name,
            event_rule_name=event_rule_name,
            events=events,
            log_group_name=log_group_name,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="configurationSet")
    def configuration_set(self) -> _aws_cdk_aws_ses_ceddda9d.ConfigurationSet:
        '''The SES Configuration Set whose events are being published.'''
        return typing.cast(_aws_cdk_aws_ses_ceddda9d.ConfigurationSet, jsii.get(self, "configurationSet"))

    @builtins.property
    @jsii.member(jsii_name="eventRule")
    def event_rule(self) -> _aws_cdk_aws_events_ceddda9d.Rule:
        '''The EventBridge Rule that captures SES events.'''
        return typing.cast(_aws_cdk_aws_events_ceddda9d.Rule, jsii.get(self, "eventRule"))

    @builtins.property
    @jsii.member(jsii_name="logGroup")
    def log_group(self) -> _aws_cdk_aws_logs_ceddda9d.LogGroup:
        '''The CloudWatch LogGroup used to store SES event data.'''
        return typing.cast(_aws_cdk_aws_logs_ceddda9d.LogGroup, jsii.get(self, "logGroup"))


@jsii.data_type(
    jsii_type="ses-cloudwatch.SesCloudWatchProps",
    jsii_struct_bases=[],
    name_mapping={
        "configuration_set_name": "configurationSetName",
        "event_rule_name": "eventRuleName",
        "events": "events",
        "log_group_name": "logGroupName",
    },
)
class SesCloudWatchProps:
    def __init__(
        self,
        *,
        configuration_set_name: typing.Optional[builtins.str] = None,
        event_rule_name: typing.Optional[builtins.str] = None,
        events: typing.Optional[typing.Sequence[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]] = None,
        log_group_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for ``SesCloudWatch``.

        :param configuration_set_name: (Optional) Explicit name for the SES Configuration Set. If not provided a name will be derived using the pattern: ``${Stack.of(this).stackName}-ses-config-set``.
        :param event_rule_name: (Optional) Explicit name for the EventBridge Rule that captures SES events. If not provided a name will be derived using the pattern: ``${Stack.of(this).stackName}-ses-event-rule``.
        :param events: (Optional) The events to capture from SES. Defaults to SEND.
        :param log_group_name: (Optional) Explicit name for the CloudWatch LogGroup that will receive the SES event logs. If omitted, the LogGroup name will be automatically generated by CloudFormation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ea584bf21f30857aa957b8884aa745b28f297916d1fefa2b02e8dc215f2f6a7)
            check_type(argname="argument configuration_set_name", value=configuration_set_name, expected_type=type_hints["configuration_set_name"])
            check_type(argname="argument event_rule_name", value=event_rule_name, expected_type=type_hints["event_rule_name"])
            check_type(argname="argument events", value=events, expected_type=type_hints["events"])
            check_type(argname="argument log_group_name", value=log_group_name, expected_type=type_hints["log_group_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if configuration_set_name is not None:
            self._values["configuration_set_name"] = configuration_set_name
        if event_rule_name is not None:
            self._values["event_rule_name"] = event_rule_name
        if events is not None:
            self._values["events"] = events
        if log_group_name is not None:
            self._values["log_group_name"] = log_group_name

    @builtins.property
    def configuration_set_name(self) -> typing.Optional[builtins.str]:
        '''(Optional) Explicit name for the SES Configuration Set.

        If not provided
        a name will be derived using the pattern:
        ``${Stack.of(this).stackName}-ses-config-set``.
        '''
        result = self._values.get("configuration_set_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def event_rule_name(self) -> typing.Optional[builtins.str]:
        '''(Optional) Explicit name for the EventBridge Rule that captures SES events.

        If not provided a name will be derived using the pattern:
        ``${Stack.of(this).stackName}-ses-event-rule``.
        '''
        result = self._values.get("event_rule_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def events(
        self,
    ) -> typing.Optional[typing.List[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]]:
        '''(Optional) The events to capture from SES.

        Defaults to SEND.
        '''
        result = self._values.get("events")
        return typing.cast(typing.Optional[typing.List[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]], result)

    @builtins.property
    def log_group_name(self) -> typing.Optional[builtins.str]:
        '''(Optional) Explicit name for the CloudWatch LogGroup that will receive the SES event logs.

        If omitted, the LogGroup name will be automatically
        generated by CloudFormation.
        '''
        result = self._values.get("log_group_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SesCloudWatchProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "SesCloudWatch",
    "SesCloudWatchProps",
]

publication.publish()

def _typecheckingstub__a6195a0780c353035bc6470bdd6dc2515442c5d098f24e3922be3bf02aa5a558(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    configuration_set_name: typing.Optional[builtins.str] = None,
    event_rule_name: typing.Optional[builtins.str] = None,
    events: typing.Optional[typing.Sequence[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]] = None,
    log_group_name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8ea584bf21f30857aa957b8884aa745b28f297916d1fefa2b02e8dc215f2f6a7(
    *,
    configuration_set_name: typing.Optional[builtins.str] = None,
    event_rule_name: typing.Optional[builtins.str] = None,
    events: typing.Optional[typing.Sequence[_aws_cdk_aws_ses_ceddda9d.EmailSendingEvent]] = None,
    log_group_name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass
