"""Golden test cases for testing liquid identifiers."""

from liquid.golden.case import Case

cases = [
    Case(
        description="ascii lowercase",
        template="{% assign foo = 'hello' %}{{ foo }} {{ bar }}",
        expect="hello goodbye",
        globals={"bar": "goodbye"},
        strict=True,
    ),
    Case(
        description="ascii uppercase",
        template="{% assign FOO = 'hello' %}{{ FOO }} {{ BAR }}",
        expect="hello goodbye",
        globals={"BAR": "goodbye"},
        strict=True,
    ),
    Case(
        description="digits",
        template="{% assign foo1 = 'hello' %}{{ foo1 }} {{ bar2 }}",
        expect="hello goodbye",
        globals={"bar2": "goodbye"},
        strict=True,
    ),
    Case(
        description="only digits",
        template="{% assign 123 = 'hello' %}{{ 123 }} {{ 456 }}",
        expect="123 456",
        globals={"456": "goodbye"},
        strict=True,
    ),
    # Case(
    #     description="leading digits",
    #     template="{% assign 1foo = 'hello' %}{{ 1foo }} {{ 2bar }}",
    #     expect="hello goodbye",
    #     globals={"2bar": "goodbye"},
    #     strict=True,
    #     error=True,
    # ),
    Case(
        description="hyphens",
        template="{% assign foo-a = 'hello' %}{{ foo-a }} {{ bar-b }}",
        expect="hello goodbye",
        globals={"bar-b": "goodbye"},
        strict=True,
    ),
    Case(
        description="leading hyphen",
        template="{% assign -foo = 'hello' %}{{ -foo }} {{ -bar }}",
        expect="hello goodbye",
        globals={"-bar": "goodbye"},
        strict=True,
        error=True,
    ),
    Case(
        description="underscore",
        template="{% assign foo_a = 'hello' %}{{ foo_a }} {{ bar_b }}",
        expect="hello goodbye",
        globals={"bar_b": "goodbye"},
        strict=True,
    ),
    Case(
        description="only underscore",
        template="{% assign _ = 'hello' %}{{ _ }} {{ __ }}",
        expect="hello goodbye",
        globals={"__": "goodbye"},
        strict=True,
    ),
    Case(
        description="leading underscore",
        template="{% assign _foo = 'hello' %}{{ _foo }} {{ _bar }}",
        expect="hello goodbye",
        globals={"_bar": "goodbye"},
        strict=True,
    ),
    Case(
        description="trailing question mark assign",
        template="{% assign foo? = 'hello' %}{{ foo? }}",
        expect="hello",
        strict=True,
        error=True,
    ),
    Case(
        description="trailing question mark output",
        template="{{ bar? }}",
        expect="goodbye",
        globals={"bar?": "goodbye"},
        strict=True,
        error=False,
    ),
    # Case(
    #     description="non-trailing question mark output",
    #     template="{{ fo?o }}",
    #     expect="hello",
    #     globals={"fo?o": "hello"},
    #     strict=True,
    #     error=True,
    # ),
    Case(
        description="hyphen in for loop target",
        template="{% for x in f-oo %}{{ x }}{% endfor %}",
        expect="123",
        globals={"f-oo": [1, 2, 3]},
        strict=True,
    ),
    Case(
        description="leading hyphen in for loop target",
        template="{% for x in -foo %}{{ x }}{% endfor %}",
        expect="123",
        globals={"-foo": [1, 2, 3]},
        strict=True,
        error=True,
    ),
    Case(
        description="hyphen in for loop variable",
        template="{% for x-y in foo %}{{ x-y }}{% endfor %}",
        expect="123",
        globals={"foo": [1, 2, 3]},
        strict=True,
    ),
    Case(
        description="trailing question mark in for loop target",
        template="{% for x in foo? %}{{ x }}{% endfor %}",
        expect="123",
        globals={"foo?": [1, 2, 3]},
        strict=True,
    ),
    Case(
        description="trailing question mark in for loop variable",
        template="{% for x? in foo %}{{ x? }}{% endfor %}",
        expect="123",
        globals={"foo": [1, 2, 3]},
        strict=True,
    ),
    Case(
        description="increment with a hyphen",
        template="{% increment f-oo %}{% increment f-oo %}",
        expect="01",
        strict=True,
    ),
    # Case(
    #     description="increment with a leading hyphen",
    #     template="{% increment -foo %}{% increment -foo %}",
    #     expect="01",
    #     strict=True,
    # ),
    Case(
        description="decrement with a hyphen",
        template="{% decrement f-oo %}{% decrement f-oo %}",
        expect="-1-2",
        strict=True,
    ),
    # Case(
    #     description="decrement with a leading hyphen",
    #     template="{% decrement -foo %}{% decrement -foo %}",
    #     expect="-1-2",
    #     strict=True,
    # ),
    Case(
        description="capture ascii lowercase",
        template="{% capture foo %}hello{% endcapture %}{{ foo }}",
        expect="hello",
        strict=True,
    ),
    Case(
        description="capture ascii uppercase",
        template="{% capture FOO %}hello{% endcapture %}{{ FOO }}",
        expect="hello",
        strict=True,
    ),
    Case(
        description="capture digits",
        template="{% capture foo1 %}hello{% endcapture %}{{ foo1 }}",
        expect="hello",
        strict=True,
    ),
    Case(
        description="capture only digits",
        template="{% capture 123 %}hello{% endcapture %}{{ 123 }}",
        expect="123",
        strict=True,
    ),
    # Case(
    #     description="capture leading digits",
    #     template="{% capture 1foo %}hello {{ 2bar }}{% endcapture %}{{ 1foo }}",
    #     expect="hello goodbye",
    #     globals={"2bar": "goodbye"},
    #     strict=True,
    #     error=True,
    # ),
    Case(
        description="capture hyphens",
        template="{% capture foo-a %}hello {{ bar-b }}{% endcapture %}{{ foo-a }}",
        expect="hello goodbye",
        globals={"bar-b": "goodbye"},
        strict=True,
    ),
    Case(
        description="capture leading hyphen",
        template="{% capture -foo %}hello {{ -bar }}{% endcapture %}{{ -foo }}",
        expect="hello goodbye",
        globals={"-bar": "goodbye"},
        strict=True,
        error=True,
    ),
    Case(
        description="capture underscore",
        template="{% capture foo_a %}hello {{ bar_b }}{% endcapture %}{{ foo_a }}",
        expect="hello goodbye",
        globals={"bar_b": "goodbye"},
        strict=True,
    ),
    Case(
        description="capture only underscore",
        template="{% capture _ %}hello {{ __ }}{% endcapture %}{{ _ }}",
        expect="hello goodbye",
        globals={"__": "goodbye"},
        strict=True,
    ),
    Case(
        description="capture leading underscore",
        template="{% capture _foo %}hello {{ _bar }}{% endcapture %}{{ _foo }}",
        expect="hello goodbye",
        globals={"_bar": "goodbye"},
        strict=True,
    ),
    # Case(
    #     description="capture trailing question mark",
    #     template="{% capture foo? %}hello{% endcapture %}{{ foo? }}",
    #     expect="",
    #     strict=True,
    # ),
    Case(
        description="at sign",
        template="{{ @foo }}",
        expect="hello",
        globals={"@foo": "hello"},
        strict=True,
        error=True,
    ),
    # Case(
    #     description="assign at sign",
    #     template="{% assign @foo = 'hello' %}",
    #     expect="",
    #     strict=True,
    # ),
]
