# dasl-api
Interact with the Antimatter ASL API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.26
- Package version: 0.1.26
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dasl_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dasl_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import dasl_api
from dasl_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.asl.antimatter.io/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = dasl_api.Configuration(
    host = "https://api.asl.antimatter.io/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): account_identity
configuration = dasl_api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with dasl_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = dasl_api.ContentV1Api(api_client)
    workspace = 'workspace_example' # str | The name of the workspace.

    try:
        api_response = api_instance.content_v1_get_mitre_enterprise(workspace)
        print("The response of ContentV1Api->content_v1_get_mitre_enterprise:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentV1Api->content_v1_get_mitre_enterprise: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.asl.antimatter.io/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentV1Api* | [**content_v1_get_mitre_enterprise**](docs/ContentV1Api.md#content_v1_get_mitre_enterprise) | **GET** /apis/content/v1/workspaces/{workspace}/mitre/enterprise | 
*ContentV1Api* | [**content_v1_get_mitre_enterprise_details**](docs/ContentV1Api.md#content_v1_get_mitre_enterprise_details) | **GET** /apis/content/v1/workspaces/{workspace}/mitre/enterprise/{identifier} | 
*ContentV1Api* | [**content_v1_get_preset_data_sources**](docs/ContentV1Api.md#content_v1_get_preset_data_sources) | **GET** /apis/content/v1/workspaces/{workspace}/datasources | 
*ContentV1Api* | [**content_v1_get_preset_datasource**](docs/ContentV1Api.md#content_v1_get_preset_datasource) | **GET** /apis/content/v1/workspaces/{workspace}/presets/datasource/{name} | 
*ContentV1Api* | [**content_v1_get_preset_datasource_summary**](docs/ContentV1Api.md#content_v1_get_preset_datasource_summary) | **GET** /apis/content/v1/workspaces/{workspace}/presets/datasource/summary/{name} | 
*ContentV1Api* | [**content_v1_get_preset_datasource_versions**](docs/ContentV1Api.md#content_v1_get_preset_datasource_versions) | **GET** /apis/content/v1/workspaces/{workspace}/presets/datasource/{name}/versions | 
*ContentV1Api* | [**content_v1_preset_purge_cache**](docs/ContentV1Api.md#content_v1_preset_purge_cache) | **GET** /apis/content/v1/workspaces/{workspace}/presets/purge-cache | 
*ContentV1Api* | [**content_v1_request_datasource**](docs/ContentV1Api.md#content_v1_request_datasource) | **POST** /apis/content/v1/workspaces/{workspace}/request-datasource | 
*CoreV1Api* | [**core_v1_create_data_source**](docs/CoreV1Api.md#core_v1_create_data_source) | **POST** /apis/core/v1/workspaces/{workspace}/datasources | 
*CoreV1Api* | [**core_v1_create_query**](docs/CoreV1Api.md#core_v1_create_query) | **POST** /apis/core/v1/workspaces/{workspace}/queries | 
*CoreV1Api* | [**core_v1_create_rule**](docs/CoreV1Api.md#core_v1_create_rule) | **POST** /apis/core/v1/workspaces/{workspace}/rules | 
*CoreV1Api* | [**core_v1_create_transform**](docs/CoreV1Api.md#core_v1_create_transform) | **POST** /apis/core/v1/workspaces/{workspace}/transforms | 
*CoreV1Api* | [**core_v1_delete_data_source**](docs/CoreV1Api.md#core_v1_delete_data_source) | **DELETE** /apis/core/v1/workspaces/{workspace}/datasources/{name} | 
*CoreV1Api* | [**core_v1_delete_rule**](docs/CoreV1Api.md#core_v1_delete_rule) | **DELETE** /apis/core/v1/workspaces/{workspace}/rules/{name} | 
*CoreV1Api* | [**core_v1_delete_transform**](docs/CoreV1Api.md#core_v1_delete_transform) | **DELETE** /apis/core/v1/workspaces/{workspace}/transforms/{name} | 
*CoreV1Api* | [**core_v1_get_data_source**](docs/CoreV1Api.md#core_v1_get_data_source) | **GET** /apis/core/v1/workspaces/{workspace}/datasources/{name} | 
*CoreV1Api* | [**core_v1_get_migration_status**](docs/CoreV1Api.md#core_v1_get_migration_status) | **GET** /apis/core/v1/workspaces/{workspace}/migrations/status | 
*CoreV1Api* | [**core_v1_get_migrations**](docs/CoreV1Api.md#core_v1_get_migrations) | **GET** /apis/core/v1/workspaces/{workspace}/migrations | 
*CoreV1Api* | [**core_v1_get_rule**](docs/CoreV1Api.md#core_v1_get_rule) | **GET** /apis/core/v1/workspaces/{workspace}/rules/{name} | 
*CoreV1Api* | [**core_v1_get_transform**](docs/CoreV1Api.md#core_v1_get_transform) | **GET** /apis/core/v1/workspaces/{workspace}/transforms/{name} | 
*CoreV1Api* | [**core_v1_list_data_source_history**](docs/CoreV1Api.md#core_v1_list_data_source_history) | **GET** /apis/core/v1/workspaces/{workspace}/datasources/history/{name} | 
*CoreV1Api* | [**core_v1_list_data_sources**](docs/CoreV1Api.md#core_v1_list_data_sources) | **GET** /apis/core/v1/workspaces/{workspace}/datasources | 
*CoreV1Api* | [**core_v1_list_rules**](docs/CoreV1Api.md#core_v1_list_rules) | **GET** /apis/core/v1/workspaces/{workspace}/rules | 
*CoreV1Api* | [**core_v1_list_rules_history**](docs/CoreV1Api.md#core_v1_list_rules_history) | **GET** /apis/core/v1/workspaces/{workspace}/rules/history/{name} | 
*CoreV1Api* | [**core_v1_list_transforms**](docs/CoreV1Api.md#core_v1_list_transforms) | **GET** /apis/core/v1/workspaces/{workspace}/transforms | 
*CoreV1Api* | [**core_v1_list_transforms_history**](docs/CoreV1Api.md#core_v1_list_transforms_history) | **GET** /apis/core/v1/workspaces/{workspace}/transforms/history/{name} | 
*CoreV1Api* | [**core_v1_put_migration_status**](docs/CoreV1Api.md#core_v1_put_migration_status) | **PUT** /apis/core/v1/workspaces/{workspace}/migrations/status | 
*CoreV1Api* | [**core_v1_queries_list**](docs/CoreV1Api.md#core_v1_queries_list) | **GET** /apis/core/v1/workspaces/{workspace}/queries | 
*CoreV1Api* | [**core_v1_query_cancel**](docs/CoreV1Api.md#core_v1_query_cancel) | **POST** /apis/core/v1/workspaces/{workspace}/queries/{id}/cancel | 
*CoreV1Api* | [**core_v1_query_delete**](docs/CoreV1Api.md#core_v1_query_delete) | **DELETE** /apis/core/v1/workspaces/{workspace}/queries/{id} | 
*CoreV1Api* | [**core_v1_query_extend**](docs/CoreV1Api.md#core_v1_query_extend) | **POST** /apis/core/v1/workspaces/{workspace}/queries/{id}/extend | 
*CoreV1Api* | [**core_v1_query_get**](docs/CoreV1Api.md#core_v1_query_get) | **GET** /apis/core/v1/workspaces/{workspace}/queries/{id} | 
*CoreV1Api* | [**core_v1_query_get_status**](docs/CoreV1Api.md#core_v1_query_get_status) | **GET** /apis/core/v1/workspaces/{workspace}/queries/{id}/status | 
*CoreV1Api* | [**core_v1_query_histogram**](docs/CoreV1Api.md#core_v1_query_histogram) | **POST** /apis/core/v1/workspaces/{workspace}/queries/{id}/histogram | 
*CoreV1Api* | [**core_v1_query_lookup**](docs/CoreV1Api.md#core_v1_query_lookup) | **POST** /apis/core/v1/workspaces/{workspace}/queries/{id}/lookup | 
*CoreV1Api* | [**core_v1_query_replace**](docs/CoreV1Api.md#core_v1_query_replace) | **PUT** /apis/core/v1/workspaces/{workspace}/queries/{id} | 
*CoreV1Api* | [**core_v1_query_start**](docs/CoreV1Api.md#core_v1_query_start) | **POST** /apis/core/v1/workspaces/{workspace}/queries/{id}/start | 
*CoreV1Api* | [**core_v1_render_rule**](docs/CoreV1Api.md#core_v1_render_rule) | **POST** /apis/core/v1/workspaces/{workspace}/preview/rules | 
*CoreV1Api* | [**core_v1_replace_data_source**](docs/CoreV1Api.md#core_v1_replace_data_source) | **PUT** /apis/core/v1/workspaces/{workspace}/datasources/{name} | 
*CoreV1Api* | [**core_v1_replace_rule**](docs/CoreV1Api.md#core_v1_replace_rule) | **PUT** /apis/core/v1/workspaces/{workspace}/rules/{name} | 
*CoreV1Api* | [**core_v1_replace_transform**](docs/CoreV1Api.md#core_v1_replace_transform) | **PUT** /apis/core/v1/workspaces/{workspace}/transforms/{name} | 
*CoreV1Api* | [**dbui_v1_post_metrics**](docs/CoreV1Api.md#dbui_v1_post_metrics) | **POST** /apis/core/v1/workspaces/{workspace}/metrics | 
*DbuiV1Api* | [**dbui_v1_authenticate**](docs/DbuiV1Api.md#dbui_v1_authenticate) | **GET** /apis/dbui/v1/authenticate | 
*DbuiV1Api* | [**dbui_v1_autoloader_preview**](docs/DbuiV1Api.md#dbui_v1_autoloader_preview) | **POST** /apis/dbui/v1/workspaces/{workspace}/autoloader-preview | 
*DbuiV1Api* | [**dbui_v1_autoloader_preview_status**](docs/DbuiV1Api.md#dbui_v1_autoloader_preview_status) | **GET** /apis/dbui/v1/workspaces/{workspace}/autoloader-preview/{id} | 
*DbuiV1Api* | [**dbui_v1_check_schema_file**](docs/DbuiV1Api.md#dbui_v1_check_schema_file) | **GET** /apis/dbui/v1/workspaces/{workspace}/check-schema-file | 
*DbuiV1Api* | [**dbui_v1_create_function**](docs/DbuiV1Api.md#dbui_v1_create_function) | **POST** /apis/dbui/v1/workspaces/{workspace}/create-function | 
*DbuiV1Api* | [**dbui_v1_create_notebook**](docs/DbuiV1Api.md#dbui_v1_create_notebook) | **POST** /apis/dbui/v1/workspaces/{workspace}/create-notebook | 
*DbuiV1Api* | [**dbui_v1_dismiss_operational_alerts**](docs/DbuiV1Api.md#dbui_v1_dismiss_operational_alerts) | **POST** /apis/dbui/v1/workspaces/{workspace}/alerts/dismiss | 
*DbuiV1Api* | [**dbui_v1_get_data_source_summary**](docs/DbuiV1Api.md#dbui_v1_get_data_source_summary) | **GET** /apis/dbui/v1/workspaces/{workspace}/datasources/summary | 
*DbuiV1Api* | [**dbui_v1_get_notable_by_id**](docs/DbuiV1Api.md#dbui_v1_get_notable_by_id) | **GET** /apis/dbui/v1/workspaces/{workspace}/notables/by-id/{id} | 
*DbuiV1Api* | [**dbui_v1_get_notables**](docs/DbuiV1Api.md#dbui_v1_get_notables) | **GET** /apis/dbui/v1/workspaces/{workspace}/notables | 
*DbuiV1Api* | [**dbui_v1_get_notables_summary**](docs/DbuiV1Api.md#dbui_v1_get_notables_summary) | **GET** /apis/dbui/v1/workspaces/{workspace}/notables/summary | 
*DbuiV1Api* | [**dbui_v1_get_observable_events**](docs/DbuiV1Api.md#dbui_v1_get_observable_events) | **GET** /apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind}/{value}/events | 
*DbuiV1Api* | [**dbui_v1_get_observable_kind**](docs/DbuiV1Api.md#dbui_v1_get_observable_kind) | **GET** /apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind} | 
*DbuiV1Api* | [**dbui_v1_get_observable_top10**](docs/DbuiV1Api.md#dbui_v1_get_observable_top10) | **GET** /apis/dbui/v1/workspaces/{workspace}/observables/top10 | 
*DbuiV1Api* | [**dbui_v1_get_operational_alert_by_id**](docs/DbuiV1Api.md#dbui_v1_get_operational_alert_by_id) | **GET** /apis/dbui/v1/workspaces/{workspace}/alerts/by-id/{id} | 
*DbuiV1Api* | [**dbui_v1_get_operational_alerts**](docs/DbuiV1Api.md#dbui_v1_get_operational_alerts) | **GET** /apis/dbui/v1/workspaces/{workspace}/alerts | 
*DbuiV1Api* | [**dbui_v1_get_operational_alerts_summary**](docs/DbuiV1Api.md#dbui_v1_get_operational_alerts_summary) | **GET** /apis/dbui/v1/workspaces/{workspace}/alerts/summary | 
*DbuiV1Api* | [**dbui_v1_link_notebook**](docs/DbuiV1Api.md#dbui_v1_link_notebook) | **POST** /apis/dbui/v1/workspaces/{workspace}/link-notebook | 
*DbuiV1Api* | [**dbui_v1_list_catalog_schemas**](docs/DbuiV1Api.md#dbui_v1_list_catalog_schemas) | **GET** /apis/dbui/v1/workspaces/{workspace}/explore/schemas/list | 
*DbuiV1Api* | [**dbui_v1_list_columns**](docs/DbuiV1Api.md#dbui_v1_list_columns) | **GET** /apis/dbui/v1/workspaces/{workspace}/tables/{table}/columns | 
*DbuiV1Api* | [**dbui_v1_list_external_locations**](docs/DbuiV1Api.md#dbui_v1_list_external_locations) | **GET** /apis/dbui/v1/workspaces/{workspace}/external-locations | 
*DbuiV1Api* | [**dbui_v1_list_schema_tables**](docs/DbuiV1Api.md#dbui_v1_list_schema_tables) | **GET** /apis/dbui/v1/workspaces/{workspace}/explore/tables/list | 
*DbuiV1Api* | [**dbui_v1_list_table_columns**](docs/DbuiV1Api.md#dbui_v1_list_table_columns) | **GET** /apis/dbui/v1/workspaces/{workspace}/explore/columns/list | 
*DbuiV1Api* | [**dbui_v1_list_users**](docs/DbuiV1Api.md#dbui_v1_list_users) | **GET** /apis/dbui/v1/workspaces/{workspace}/users | 
*DbuiV1Api* | [**dbui_v1_medallion_table_list**](docs/DbuiV1Api.md#dbui_v1_medallion_table_list) | **GET** /apis/dbui/v1/workspaces/{workspace}/medallion/{medallionLayer}/tables/list | 
*DbuiV1Api* | [**dbui_v1_promote_event_to_notable**](docs/DbuiV1Api.md#dbui_v1_promote_event_to_notable) | **POST** /apis/dbui/v1/workspaces/{workspace}/notables | 
*DbuiV1Api* | [**dbui_v1_query_cancel**](docs/DbuiV1Api.md#dbui_v1_query_cancel) | **POST** /apis/dbui/v1/workspaces/{workspace}/query/{id}/cancel | 
*DbuiV1Api* | [**dbui_v1_query_extend**](docs/DbuiV1Api.md#dbui_v1_query_extend) | **POST** /apis/dbui/v1/workspaces/{workspace}/query/{id}/extend | 
*DbuiV1Api* | [**dbui_v1_query_generate**](docs/DbuiV1Api.md#dbui_v1_query_generate) | **POST** /apis/dbui/v1/workspaces/{workspace}/query | 
*DbuiV1Api* | [**dbui_v1_query_generate_status**](docs/DbuiV1Api.md#dbui_v1_query_generate_status) | **GET** /apis/dbui/v1/workspaces/{workspace}/query/{id}/status | 
*DbuiV1Api* | [**dbui_v1_query_histogram**](docs/DbuiV1Api.md#dbui_v1_query_histogram) | **POST** /apis/dbui/v1/workspaces/{workspace}/query/{id}/histogram | 
*DbuiV1Api* | [**dbui_v1_query_lookup**](docs/DbuiV1Api.md#dbui_v1_query_lookup) | **POST** /apis/dbui/v1/workspaces/{workspace}/query/{id}/lookup | 
*DbuiV1Api* | [**dbui_v1_refresh_token**](docs/DbuiV1Api.md#dbui_v1_refresh_token) | **GET** /apis/dbui/v1/refresh-token | 
*DbuiV1Api* | [**dbui_v1_table_preview**](docs/DbuiV1Api.md#dbui_v1_table_preview) | **GET** /apis/dbui/v1/workspaces/{workspace}/table-preview | 
*DbuiV1Api* | [**dbui_v1_test_access**](docs/DbuiV1Api.md#dbui_v1_test_access) | **POST** /apis/dbui/v1/workspaces/{workspace}/test-access | 
*DbuiV1Api* | [**dbui_v1_token_exchange**](docs/DbuiV1Api.md#dbui_v1_token_exchange) | **GET** /apis/dbui/v1/token-exchange | 
*DbuiV1Api* | [**dbui_v1_transform**](docs/DbuiV1Api.md#dbui_v1_transform) | **POST** /apis/dbui/v1/workspaces/{workspace}/transform | 
*DbuiV1Api* | [**dbui_v1_transform_status**](docs/DbuiV1Api.md#dbui_v1_transform_status) | **GET** /apis/dbui/v1/workspaces/{workspace}/transform/{id} | 
*DbuiV1Api* | [**dbui_v1_update_notable**](docs/DbuiV1Api.md#dbui_v1_update_notable) | **POST** /apis/dbui/v1/workspaces/{workspace}/notables/update | 
*DbuiV1Api* | [**dbui_v1_update_observable_risk**](docs/DbuiV1Api.md#dbui_v1_update_observable_risk) | **POST** /apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind}/{value}/update | 
*DbuiV1Api* | [**dbui_v1_verify_auth**](docs/DbuiV1Api.md#dbui_v1_verify_auth) | **GET** /apis/dbui/v1/verify-auth | 
*DbuiV1Api* | [**dbui_v1_warehouse_get**](docs/DbuiV1Api.md#dbui_v1_warehouse_get) | **GET** /apis/dbui/v1/workspaces/{workspace}/warehouse/{id} | 
*DbuiV1Api* | [**dbui_v1_warehouse_list**](docs/DbuiV1Api.md#dbui_v1_warehouse_list) | **GET** /apis/dbui/v1/workspaces/{workspace}/warehouse | 
*DbuiV1Api* | [**dbui_v1_warehouse_running**](docs/DbuiV1Api.md#dbui_v1_warehouse_running) | **GET** /apis/dbui/v1/workspaces/{workspace}/warehouse/{id}/running | 
*DbuiV1Api* | [**dbui_v1_warehouse_start**](docs/DbuiV1Api.md#dbui_v1_warehouse_start) | **POST** /apis/dbui/v1/workspaces/{workspace}/warehouse/{id}/start | 
*WorkspaceV1Api* | [**workspace_v1_accept_terms**](docs/WorkspaceV1Api.md#workspace_v1_accept_terms) | **POST** /apis/workspace/v1/workspaces/{workspace}/terms | 
*WorkspaceV1Api* | [**workspace_v1_authenticate**](docs/WorkspaceV1Api.md#workspace_v1_authenticate) | **POST** /apis/workspace/v1/workspaces/{workspace}/authenticate | 
*WorkspaceV1Api* | [**workspace_v1_create_service_account**](docs/WorkspaceV1Api.md#workspace_v1_create_service_account) | **POST** /apis/workspace/v1/workspaces/{workspace}/serviceaccounts | 
*WorkspaceV1Api* | [**workspace_v1_create_user**](docs/WorkspaceV1Api.md#workspace_v1_create_user) | **POST** /apis/workspace/v1/workspaces/{workspace}/users | 
*WorkspaceV1Api* | [**workspace_v1_create_workspace**](docs/WorkspaceV1Api.md#workspace_v1_create_workspace) | **POST** /apis/workspace/v1/workspaces | 
*WorkspaceV1Api* | [**workspace_v1_delete_admin_config**](docs/WorkspaceV1Api.md#workspace_v1_delete_admin_config) | **DELETE** /apis/workspace/v1/workspaces/{workspace}/adminconfig | 
*WorkspaceV1Api* | [**workspace_v1_delete_service_account**](docs/WorkspaceV1Api.md#workspace_v1_delete_service_account) | **DELETE** /apis/workspace/v1/workspaces/{workspace}/serviceaccounts/{name} | 
*WorkspaceV1Api* | [**workspace_v1_delete_user**](docs/WorkspaceV1Api.md#workspace_v1_delete_user) | **DELETE** /apis/workspace/v1/workspaces/{workspace}/users/{email} | 
*WorkspaceV1Api* | [**workspace_v1_get_admin_config**](docs/WorkspaceV1Api.md#workspace_v1_get_admin_config) | **GET** /apis/workspace/v1/workspaces/{workspace}/adminconfig | 
*WorkspaceV1Api* | [**workspace_v1_get_config**](docs/WorkspaceV1Api.md#workspace_v1_get_config) | **GET** /apis/workspace/v1/workspaces/{workspace}/config | 
*WorkspaceV1Api* | [**workspace_v1_get_context**](docs/WorkspaceV1Api.md#workspace_v1_get_context) | **GET** /apis/workspace/v1/workspaces/{workspace}/context | 
*WorkspaceV1Api* | [**workspace_v1_get_rebalance**](docs/WorkspaceV1Api.md#workspace_v1_get_rebalance) | **GET** /apis/workspace/v1/workspaces/{workspace}/rebalance | 
*WorkspaceV1Api* | [**workspace_v1_get_service_account**](docs/WorkspaceV1Api.md#workspace_v1_get_service_account) | **GET** /apis/workspace/v1/workspaces/{workspace}/serviceaccounts/{name} | 
*WorkspaceV1Api* | [**workspace_v1_get_terms**](docs/WorkspaceV1Api.md#workspace_v1_get_terms) | **GET** /apis/workspace/v1/workspaces/{workspace}/terms | 
*WorkspaceV1Api* | [**workspace_v1_get_user**](docs/WorkspaceV1Api.md#workspace_v1_get_user) | **GET** /apis/workspace/v1/workspaces/{workspace}/users/{email} | 
*WorkspaceV1Api* | [**workspace_v1_list_service_accounts**](docs/WorkspaceV1Api.md#workspace_v1_list_service_accounts) | **GET** /apis/workspace/v1/workspaces/{workspace}/serviceaccounts | 
*WorkspaceV1Api* | [**workspace_v1_list_users**](docs/WorkspaceV1Api.md#workspace_v1_list_users) | **GET** /apis/workspace/v1/workspaces/{workspace}/users | 
*WorkspaceV1Api* | [**workspace_v1_logout**](docs/WorkspaceV1Api.md#workspace_v1_logout) | **GET** /apis/workspace/v1/workspaces/{workspace}/logout | 
*WorkspaceV1Api* | [**workspace_v1_post_rebalance**](docs/WorkspaceV1Api.md#workspace_v1_post_rebalance) | **POST** /apis/workspace/v1/workspaces/{workspace}/rebalance | 
*WorkspaceV1Api* | [**workspace_v1_put_admin_config**](docs/WorkspaceV1Api.md#workspace_v1_put_admin_config) | **PUT** /apis/workspace/v1/workspaces/{workspace}/adminconfig | 
*WorkspaceV1Api* | [**workspace_v1_put_config**](docs/WorkspaceV1Api.md#workspace_v1_put_config) | **PUT** /apis/workspace/v1/workspaces/{workspace}/config | 
*WorkspaceV1Api* | [**workspace_v1_replace_service_account**](docs/WorkspaceV1Api.md#workspace_v1_replace_service_account) | **PUT** /apis/workspace/v1/workspaces/{workspace}/serviceaccounts/{name} | 
*WorkspaceV1Api* | [**workspace_v1_replace_user**](docs/WorkspaceV1Api.md#workspace_v1_replace_user) | **PUT** /apis/workspace/v1/workspaces/{workspace}/users/{email} | 
*WorkspaceV1Api* | [**workspace_v1_request_secret**](docs/WorkspaceV1Api.md#workspace_v1_request_secret) | **POST** /apis/workspace/v1/workspaces/{workspace}/request-secret | 


## Documentation For Models

 - [CommonV1JobMeta](docs/CommonV1JobMeta.md)
 - [CommonV1ListMeta](docs/CommonV1ListMeta.md)
 - [CommonV1ObjectMeta](docs/CommonV1ObjectMeta.md)
 - [ConflictError](docs/ConflictError.md)
 - [ContentV1DatasourcePreset](docs/ContentV1DatasourcePreset.md)
 - [ContentV1DatasourcePresetAutoloader](docs/ContentV1DatasourcePresetAutoloader.md)
 - [ContentV1DatasourcePresetAutoloaderCloudFiles](docs/ContentV1DatasourcePresetAutoloaderCloudFiles.md)
 - [ContentV1DatasourcePresetBronze](docs/ContentV1DatasourcePresetBronze.md)
 - [ContentV1DatasourcePresetGoldInner](docs/ContentV1DatasourcePresetGoldInner.md)
 - [ContentV1DatasourcePresetList](docs/ContentV1DatasourcePresetList.md)
 - [ContentV1DatasourcePresetListRecommendedPresetsInner](docs/ContentV1DatasourcePresetListRecommendedPresetsInner.md)
 - [ContentV1DatasourcePresetSilver](docs/ContentV1DatasourcePresetSilver.md)
 - [ContentV1DatasourcePresetSilverPreTransformInner](docs/ContentV1DatasourcePresetSilverPreTransformInner.md)
 - [ContentV1DatasourcePresetSilverTransformInner](docs/ContentV1DatasourcePresetSilverTransformInner.md)
 - [ContentV1DatasourcePresetSummary](docs/ContentV1DatasourcePresetSummary.md)
 - [ContentV1DatasourcePresetVersion](docs/ContentV1DatasourcePresetVersion.md)
 - [ContentV1DatasourcePresetVersionList](docs/ContentV1DatasourcePresetVersionList.md)
 - [ContentV1MitreAttack](docs/ContentV1MitreAttack.md)
 - [ContentV1MitreSubTechnique](docs/ContentV1MitreSubTechnique.md)
 - [ContentV1MitreTactic](docs/ContentV1MitreTactic.md)
 - [ContentV1MitreTechnique](docs/ContentV1MitreTechnique.md)
 - [ContentV1MitreTechniqueDetail](docs/ContentV1MitreTechniqueDetail.md)
 - [ContentV1PresetDataSourceList](docs/ContentV1PresetDataSourceList.md)
 - [ContentV1PresetDataSourceListItemsInner](docs/ContentV1PresetDataSourceListItemsInner.md)
 - [ContentV1RequestDatasourceRequest](docs/ContentV1RequestDatasourceRequest.md)
 - [CoreV1DataSource](docs/CoreV1DataSource.md)
 - [CoreV1DataSourceAutoloaderSpec](docs/CoreV1DataSourceAutoloaderSpec.md)
 - [CoreV1DataSourceFieldSpec](docs/CoreV1DataSourceFieldSpec.md)
 - [CoreV1DataSourceFieldSpecAssertInner](docs/CoreV1DataSourceFieldSpecAssertInner.md)
 - [CoreV1DataSourceFieldSpecJoin](docs/CoreV1DataSourceFieldSpecJoin.md)
 - [CoreV1DataSourceFieldSpecJoinWithCSV](docs/CoreV1DataSourceFieldSpecJoinWithCSV.md)
 - [CoreV1DataSourceFieldUtils](docs/CoreV1DataSourceFieldUtils.md)
 - [CoreV1DataSourceFieldUtilsJsonExtractInner](docs/CoreV1DataSourceFieldUtilsJsonExtractInner.md)
 - [CoreV1DataSourceFieldUtilsUnreferencedColumns](docs/CoreV1DataSourceFieldUtilsUnreferencedColumns.md)
 - [CoreV1DataSourceList](docs/CoreV1DataSourceList.md)
 - [CoreV1DataSourcePrimaryKeySpec](docs/CoreV1DataSourcePrimaryKeySpec.md)
 - [CoreV1DataSourceSpec](docs/CoreV1DataSourceSpec.md)
 - [CoreV1DataSourceSpecBronze](docs/CoreV1DataSourceSpecBronze.md)
 - [CoreV1DataSourceSpecBronzeClustering](docs/CoreV1DataSourceSpecBronzeClustering.md)
 - [CoreV1DataSourceSpecCustom](docs/CoreV1DataSourceSpecCustom.md)
 - [CoreV1DataSourceSpecGold](docs/CoreV1DataSourceSpecGold.md)
 - [CoreV1DataSourceSpecGoldPresetOverrides](docs/CoreV1DataSourceSpecGoldPresetOverrides.md)
 - [CoreV1DataSourceSpecGoldPresetOverridesAddTablesInner](docs/CoreV1DataSourceSpecGoldPresetOverridesAddTablesInner.md)
 - [CoreV1DataSourceSpecGoldPresetOverridesAddTablesInnerCustom](docs/CoreV1DataSourceSpecGoldPresetOverridesAddTablesInnerCustom.md)
 - [CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner](docs/CoreV1DataSourceSpecGoldPresetOverridesModifyTablesInner.md)
 - [CoreV1DataSourceSpecSilver](docs/CoreV1DataSourceSpecSilver.md)
 - [CoreV1DataSourceSpecSilverBronzeTablesInner](docs/CoreV1DataSourceSpecSilverBronzeTablesInner.md)
 - [CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark](docs/CoreV1DataSourceSpecSilverBronzeTablesInnerWatermark.md)
 - [CoreV1DataSourceSpecSilverPreTransform](docs/CoreV1DataSourceSpecSilverPreTransform.md)
 - [CoreV1DataSourceSpecSilverPreTransformCustom](docs/CoreV1DataSourceSpecSilverPreTransformCustom.md)
 - [CoreV1DataSourceSpecSilverPreTransformPresetOverrides](docs/CoreV1DataSourceSpecSilverPreTransformPresetOverrides.md)
 - [CoreV1DataSourceSpecSilverTransform](docs/CoreV1DataSourceSpecSilverTransform.md)
 - [CoreV1DataSourceSpecSilverTransformPresetOverrides](docs/CoreV1DataSourceSpecSilverTransformPresetOverrides.md)
 - [CoreV1DataSourceSpecSilverTransformPresetOverridesAddTablesInner](docs/CoreV1DataSourceSpecSilverTransformPresetOverridesAddTablesInner.md)
 - [CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner](docs/CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInner.md)
 - [CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom](docs/CoreV1DataSourceSpecSilverTransformPresetOverridesModifyTablesInnerCustom.md)
 - [CoreV1DefaultSchedule](docs/CoreV1DefaultSchedule.md)
 - [CoreV1MigrationList](docs/CoreV1MigrationList.md)
 - [CoreV1MigrationSpec](docs/CoreV1MigrationSpec.md)
 - [CoreV1MigrationStatus](docs/CoreV1MigrationStatus.md)
 - [CoreV1PostMetricsRequest](docs/CoreV1PostMetricsRequest.md)
 - [CoreV1PostMetricsRequestExecResultsInner](docs/CoreV1PostMetricsRequestExecResultsInner.md)
 - [CoreV1Query](docs/CoreV1Query.md)
 - [CoreV1QueryExecutionStatus](docs/CoreV1QueryExecutionStatus.md)
 - [CoreV1QueryExecutionStatusContext](docs/CoreV1QueryExecutionStatusContext.md)
 - [CoreV1QueryExtendRequest](docs/CoreV1QueryExtendRequest.md)
 - [CoreV1QueryExtendRequestDateRange](docs/CoreV1QueryExtendRequestDateRange.md)
 - [CoreV1QueryHistogramRequest](docs/CoreV1QueryHistogramRequest.md)
 - [CoreV1QueryHistogramResult](docs/CoreV1QueryHistogramResult.md)
 - [CoreV1QueryHistogramResultDataInner](docs/CoreV1QueryHistogramResultDataInner.md)
 - [CoreV1QueryList](docs/CoreV1QueryList.md)
 - [CoreV1QueryLookupRequest](docs/CoreV1QueryLookupRequest.md)
 - [CoreV1QueryLookupRequestPagination](docs/CoreV1QueryLookupRequestPagination.md)
 - [CoreV1QueryLookupResult](docs/CoreV1QueryLookupResult.md)
 - [CoreV1QuerySpec](docs/CoreV1QuerySpec.md)
 - [CoreV1QuerySpecDateRange](docs/CoreV1QuerySpecDateRange.md)
 - [CoreV1QuerySpecMetadata](docs/CoreV1QuerySpecMetadata.md)
 - [CoreV1RenderedRule](docs/CoreV1RenderedRule.md)
 - [CoreV1RenderedRuleTables](docs/CoreV1RenderedRuleTables.md)
 - [CoreV1ResourceStatus](docs/CoreV1ResourceStatus.md)
 - [CoreV1Rule](docs/CoreV1Rule.md)
 - [CoreV1RuleList](docs/CoreV1RuleList.md)
 - [CoreV1RuleObservable](docs/CoreV1RuleObservable.md)
 - [CoreV1RuleObservableRisk](docs/CoreV1RuleObservableRisk.md)
 - [CoreV1RuleSpec](docs/CoreV1RuleSpec.md)
 - [CoreV1RuleSpecCollate](docs/CoreV1RuleSpecCollate.md)
 - [CoreV1RuleSpecInput](docs/CoreV1RuleSpecInput.md)
 - [CoreV1RuleSpecInputBatch](docs/CoreV1RuleSpecInputBatch.md)
 - [CoreV1RuleSpecInputBatchCustom](docs/CoreV1RuleSpecInputBatchCustom.md)
 - [CoreV1RuleSpecInputStream](docs/CoreV1RuleSpecInputStream.md)
 - [CoreV1RuleSpecInputStreamCustom](docs/CoreV1RuleSpecInputStreamCustom.md)
 - [CoreV1RuleSpecInputStreamTablesInner](docs/CoreV1RuleSpecInputStreamTablesInner.md)
 - [CoreV1RuleSpecInputStreamTablesInnerWatermark](docs/CoreV1RuleSpecInputStreamTablesInnerWatermark.md)
 - [CoreV1RuleSpecMetadata](docs/CoreV1RuleSpecMetadata.md)
 - [CoreV1RuleSpecMetadataMitreInner](docs/CoreV1RuleSpecMetadataMitreInner.md)
 - [CoreV1RuleSpecMetadataResponse](docs/CoreV1RuleSpecMetadataResponse.md)
 - [CoreV1RuleSpecMetadataResponsePlaybooksInner](docs/CoreV1RuleSpecMetadataResponsePlaybooksInner.md)
 - [CoreV1RuleSpecOutput](docs/CoreV1RuleSpecOutput.md)
 - [CoreV1Schedule](docs/CoreV1Schedule.md)
 - [CoreV1StatusEvent](docs/CoreV1StatusEvent.md)
 - [CoreV1Transform](docs/CoreV1Transform.md)
 - [CoreV1TransformList](docs/CoreV1TransformList.md)
 - [CoreV1TransformSpec](docs/CoreV1TransformSpec.md)
 - [CoreV1TransformSpecStream](docs/CoreV1TransformSpecStream.md)
 - [CoreV1TransformSpecStreamTablesInner](docs/CoreV1TransformSpecStreamTablesInner.md)
 - [CoreV1TransformSpecStreamTablesInnerWatermark](docs/CoreV1TransformSpecStreamTablesInnerWatermark.md)
 - [DbuiV1AutoloaderPreviewRequest](docs/DbuiV1AutoloaderPreviewRequest.md)
 - [DbuiV1AutoloaderPreviewResponse](docs/DbuiV1AutoloaderPreviewResponse.md)
 - [DbuiV1AutoloaderPreviewStatus](docs/DbuiV1AutoloaderPreviewStatus.md)
 - [DbuiV1ColumnList](docs/DbuiV1ColumnList.md)
 - [DbuiV1ColumnListColumnsInner](docs/DbuiV1ColumnListColumnsInner.md)
 - [DbuiV1CreateFunctionRequest](docs/DbuiV1CreateFunctionRequest.md)
 - [DbuiV1CreateFunctionResponse](docs/DbuiV1CreateFunctionResponse.md)
 - [DbuiV1CreateNotebookRequest](docs/DbuiV1CreateNotebookRequest.md)
 - [DbuiV1CreateNotebookResponse](docs/DbuiV1CreateNotebookResponse.md)
 - [DbuiV1DataSourceSummaryList](docs/DbuiV1DataSourceSummaryList.md)
 - [DbuiV1DataSourceSummaryListDataSourcesInner](docs/DbuiV1DataSourceSummaryListDataSourcesInner.md)
 - [DbuiV1DataSourceSummaryListDataSourcesInnerAlerts](docs/DbuiV1DataSourceSummaryListDataSourcesInnerAlerts.md)
 - [DbuiV1DataSourceSummaryListRollupMetrics](docs/DbuiV1DataSourceSummaryListRollupMetrics.md)
 - [DbuiV1DismissOperationalAlertsRequest](docs/DbuiV1DismissOperationalAlertsRequest.md)
 - [DbuiV1ExternalLocationList](docs/DbuiV1ExternalLocationList.md)
 - [DbuiV1ExternalLocationListLocationsInner](docs/DbuiV1ExternalLocationListLocationsInner.md)
 - [DbuiV1LinkNotebookRequest](docs/DbuiV1LinkNotebookRequest.md)
 - [DbuiV1LinkNotebookResponse](docs/DbuiV1LinkNotebookResponse.md)
 - [DbuiV1ListUsersResponse](docs/DbuiV1ListUsersResponse.md)
 - [DbuiV1ListUsersResponseUsersInner](docs/DbuiV1ListUsersResponseUsersInner.md)
 - [DbuiV1MedallionTableListResponse](docs/DbuiV1MedallionTableListResponse.md)
 - [DbuiV1Notable](docs/DbuiV1Notable.md)
 - [DbuiV1NotableCollate](docs/DbuiV1NotableCollate.md)
 - [DbuiV1NotableList](docs/DbuiV1NotableList.md)
 - [DbuiV1NotableSummary](docs/DbuiV1NotableSummary.md)
 - [DbuiV1ObservableEventsList](docs/DbuiV1ObservableEventsList.md)
 - [DbuiV1ObservableEventsListItemsInner](docs/DbuiV1ObservableEventsListItemsInner.md)
 - [DbuiV1ObservableEventsListItemsInnerNotable](docs/DbuiV1ObservableEventsListItemsInnerNotable.md)
 - [DbuiV1ObservableInstance](docs/DbuiV1ObservableInstance.md)
 - [DbuiV1ObservableList](docs/DbuiV1ObservableList.md)
 - [DbuiV1ObservableTop10List](docs/DbuiV1ObservableTop10List.md)
 - [DbuiV1ObservableTop10ListItemsInner](docs/DbuiV1ObservableTop10ListItemsInner.md)
 - [DbuiV1ObservableTop10ListItemsInnerTop10Inner](docs/DbuiV1ObservableTop10ListItemsInnerTop10Inner.md)
 - [DbuiV1ObservableTop10Reply](docs/DbuiV1ObservableTop10Reply.md)
 - [DbuiV1ObservableTop10ReplyItemsInner](docs/DbuiV1ObservableTop10ReplyItemsInner.md)
 - [DbuiV1ObservableTop10ReplyItemsInnerTop10Inner](docs/DbuiV1ObservableTop10ReplyItemsInnerTop10Inner.md)
 - [DbuiV1OperationalAlert](docs/DbuiV1OperationalAlert.md)
 - [DbuiV1OperationalAlertList](docs/DbuiV1OperationalAlertList.md)
 - [DbuiV1OperationalAlertSummary](docs/DbuiV1OperationalAlertSummary.md)
 - [DbuiV1PromoteEventRequest](docs/DbuiV1PromoteEventRequest.md)
 - [DbuiV1QueryExtendRequest](docs/DbuiV1QueryExtendRequest.md)
 - [DbuiV1QueryGenerateRequest](docs/DbuiV1QueryGenerateRequest.md)
 - [DbuiV1QueryGenerateRequestTimeRange](docs/DbuiV1QueryGenerateRequestTimeRange.md)
 - [DbuiV1QueryGenerateStatus](docs/DbuiV1QueryGenerateStatus.md)
 - [DbuiV1QueryHistogramRequest](docs/DbuiV1QueryHistogramRequest.md)
 - [DbuiV1QueryHistogramResult](docs/DbuiV1QueryHistogramResult.md)
 - [DbuiV1QueryLookupRequest](docs/DbuiV1QueryLookupRequest.md)
 - [DbuiV1QueryLookupRequestPagination](docs/DbuiV1QueryLookupRequestPagination.md)
 - [DbuiV1QueryLookupResult](docs/DbuiV1QueryLookupResult.md)
 - [DbuiV1SchemaCheckResponse](docs/DbuiV1SchemaCheckResponse.md)
 - [DbuiV1SchemaList](docs/DbuiV1SchemaList.md)
 - [DbuiV1TableColumnDetails](docs/DbuiV1TableColumnDetails.md)
 - [DbuiV1TableColumnList](docs/DbuiV1TableColumnList.md)
 - [DbuiV1TableList](docs/DbuiV1TableList.md)
 - [DbuiV1TablePreview](docs/DbuiV1TablePreview.md)
 - [DbuiV1TestAccessRequest](docs/DbuiV1TestAccessRequest.md)
 - [DbuiV1TestAccessResponse](docs/DbuiV1TestAccessResponse.md)
 - [DbuiV1TransformRequest](docs/DbuiV1TransformRequest.md)
 - [DbuiV1TransformRequestIngestion](docs/DbuiV1TransformRequestIngestion.md)
 - [DbuiV1TransformRequestIngestionAdditionalInputTablesInner](docs/DbuiV1TransformRequestIngestionAdditionalInputTablesInner.md)
 - [DbuiV1TransformRequestIngestionAutoloaderInput](docs/DbuiV1TransformRequestIngestionAutoloaderInput.md)
 - [DbuiV1TransformRequestIngestionInput](docs/DbuiV1TransformRequestIngestionInput.md)
 - [DbuiV1TransformRequestTransformsInner](docs/DbuiV1TransformRequestTransformsInner.md)
 - [DbuiV1TransformRequestTransformsInnerPresetOverrides](docs/DbuiV1TransformRequestTransformsInnerPresetOverrides.md)
 - [DbuiV1TransformResponse](docs/DbuiV1TransformResponse.md)
 - [DbuiV1TransformResponseStagesInner](docs/DbuiV1TransformResponseStagesInner.md)
 - [DbuiV1TransformStatus](docs/DbuiV1TransformStatus.md)
 - [DbuiV1UpdateNotablesRequest](docs/DbuiV1UpdateNotablesRequest.md)
 - [DbuiV1UpdateObservableRequest](docs/DbuiV1UpdateObservableRequest.md)
 - [DbuiV1UpdateObservableRiskRequest](docs/DbuiV1UpdateObservableRiskRequest.md)
 - [DbuiV1VerifyAuthResponse](docs/DbuiV1VerifyAuthResponse.md)
 - [DbuiV1WarehouseItem](docs/DbuiV1WarehouseItem.md)
 - [DbuiV1WarehouseListResponse](docs/DbuiV1WarehouseListResponse.md)
 - [DbuiV1WarehouseReady](docs/DbuiV1WarehouseReady.md)
 - [Error](docs/Error.md)
 - [ForbiddenError](docs/ForbiddenError.md)
 - [InvalidRequestError](docs/InvalidRequestError.md)
 - [PreconditionFailedError](docs/PreconditionFailedError.md)
 - [ResourceExhaustedError](docs/ResourceExhaustedError.md)
 - [ResourceNotFoundError](docs/ResourceNotFoundError.md)
 - [UnauthorizedError](docs/UnauthorizedError.md)
 - [WorkspaceV1AcceptTermsRequest](docs/WorkspaceV1AcceptTermsRequest.md)
 - [WorkspaceV1AdminConfig](docs/WorkspaceV1AdminConfig.md)
 - [WorkspaceV1AdminConfigSpec](docs/WorkspaceV1AdminConfigSpec.md)
 - [WorkspaceV1AdminConfigSpecAuth](docs/WorkspaceV1AdminConfigSpecAuth.md)
 - [WorkspaceV1AdminConfigSpecAuthAppClientId](docs/WorkspaceV1AdminConfigSpecAuthAppClientId.md)
 - [WorkspaceV1AdminConfigSpecAuthServicePrincipal](docs/WorkspaceV1AdminConfigSpecAuthServicePrincipal.md)
 - [WorkspaceV1AdminConfigStatus](docs/WorkspaceV1AdminConfigStatus.md)
 - [WorkspaceV1AuthenticateRequest](docs/WorkspaceV1AuthenticateRequest.md)
 - [WorkspaceV1AuthenticateResponse](docs/WorkspaceV1AuthenticateResponse.md)
 - [WorkspaceV1CreateServiceAccountRequest](docs/WorkspaceV1CreateServiceAccountRequest.md)
 - [WorkspaceV1CreateServiceAccountResponse](docs/WorkspaceV1CreateServiceAccountResponse.md)
 - [WorkspaceV1CreateWorkspaceRequest](docs/WorkspaceV1CreateWorkspaceRequest.md)
 - [WorkspaceV1CreateWorkspaceResponse](docs/WorkspaceV1CreateWorkspaceResponse.md)
 - [WorkspaceV1DefaultConfig](docs/WorkspaceV1DefaultConfig.md)
 - [WorkspaceV1DefaultConfigComputeGroupOverridesValue](docs/WorkspaceV1DefaultConfigComputeGroupOverridesValue.md)
 - [WorkspaceV1ExportConfig](docs/WorkspaceV1ExportConfig.md)
 - [WorkspaceV1ExportConfigJiraConfig](docs/WorkspaceV1ExportConfigJiraConfig.md)
 - [WorkspaceV1ExportConfigJiraConfigToken](docs/WorkspaceV1ExportConfigJiraConfigToken.md)
 - [WorkspaceV1ExportConfigServiceNowConfig](docs/WorkspaceV1ExportConfigServiceNowConfig.md)
 - [WorkspaceV1ExportConfigServiceNowConfigPassword](docs/WorkspaceV1ExportConfigServiceNowConfigPassword.md)
 - [WorkspaceV1ExportConfigSlackConfig](docs/WorkspaceV1ExportConfigSlackConfig.md)
 - [WorkspaceV1ExportConfigSlackConfigToken](docs/WorkspaceV1ExportConfigSlackConfigToken.md)
 - [WorkspaceV1ExportConfigWebhookConfig](docs/WorkspaceV1ExportConfigWebhookConfig.md)
 - [WorkspaceV1ExportConfigWebhookConfigDestination](docs/WorkspaceV1ExportConfigWebhookConfigDestination.md)
 - [WorkspaceV1RebalanceInfo](docs/WorkspaceV1RebalanceInfo.md)
 - [WorkspaceV1RebalanceInfoStatus](docs/WorkspaceV1RebalanceInfoStatus.md)
 - [WorkspaceV1RebalanceInfoStatusResourcesInner](docs/WorkspaceV1RebalanceInfoStatusResourcesInner.md)
 - [WorkspaceV1RequestSecretRequest](docs/WorkspaceV1RequestSecretRequest.md)
 - [WorkspaceV1RequestSecretResponse](docs/WorkspaceV1RequestSecretResponse.md)
 - [WorkspaceV1ServiceAccount](docs/WorkspaceV1ServiceAccount.md)
 - [WorkspaceV1ServiceAccountCredentials](docs/WorkspaceV1ServiceAccountCredentials.md)
 - [WorkspaceV1ServiceAccountList](docs/WorkspaceV1ServiceAccountList.md)
 - [WorkspaceV1ServiceAccountSpec](docs/WorkspaceV1ServiceAccountSpec.md)
 - [WorkspaceV1ServiceAccountStatus](docs/WorkspaceV1ServiceAccountStatus.md)
 - [WorkspaceV1TermsStatus](docs/WorkspaceV1TermsStatus.md)
 - [WorkspaceV1User](docs/WorkspaceV1User.md)
 - [WorkspaceV1UserList](docs/WorkspaceV1UserList.md)
 - [WorkspaceV1UserSpec](docs/WorkspaceV1UserSpec.md)
 - [WorkspaceV1UserStatus](docs/WorkspaceV1UserStatus.md)
 - [WorkspaceV1WorkspaceConfig](docs/WorkspaceV1WorkspaceConfig.md)
 - [WorkspaceV1WorkspaceConfigSpec](docs/WorkspaceV1WorkspaceConfigSpec.md)
 - [WorkspaceV1WorkspaceConfigSpecDatasources](docs/WorkspaceV1WorkspaceConfigSpecDatasources.md)
 - [WorkspaceV1WorkspaceConfigSpecDefaultConfig](docs/WorkspaceV1WorkspaceConfigSpecDefaultConfig.md)
 - [WorkspaceV1WorkspaceConfigSpecDetectionRuleMetadata](docs/WorkspaceV1WorkspaceConfigSpecDetectionRuleMetadata.md)
 - [WorkspaceV1WorkspaceConfigSpecManagedRetentionInner](docs/WorkspaceV1WorkspaceConfigSpecManagedRetentionInner.md)
 - [WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner](docs/WorkspaceV1WorkspaceConfigSpecManagedRetentionInnerOverridesInner.md)
 - [WorkspaceV1WorkspaceConfigSpecObservables](docs/WorkspaceV1WorkspaceConfigSpecObservables.md)
 - [WorkspaceV1WorkspaceConfigSpecObservablesKindsInner](docs/WorkspaceV1WorkspaceConfigSpecObservablesKindsInner.md)
 - [WorkspaceV1WorkspaceConfigSpecRules](docs/WorkspaceV1WorkspaceConfigSpecRules.md)
 - [WorkspaceV1WorkspaceConfigSpecSystemTablesConfig](docs/WorkspaceV1WorkspaceConfigSpecSystemTablesConfig.md)
 - [WorkspaceV1WorkspaceContext](docs/WorkspaceV1WorkspaceContext.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="account_identity"></a>
### account_identity

- **Type**: Bearer authentication (JWT)

<a id="databricks_oauth_token"></a>
### databricks_oauth_token

- **Type**: Bearer authentication (JWT)


## Author

support@antimatter.io


