# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Optional, Union
from typing_extensions import Annotated
from dasl_api.models.dbui_v1_autoloader_preview_request import DbuiV1AutoloaderPreviewRequest
from dasl_api.models.dbui_v1_autoloader_preview_status import DbuiV1AutoloaderPreviewStatus
from dasl_api.models.dbui_v1_column_list import DbuiV1ColumnList
from dasl_api.models.dbui_v1_create_function_request import DbuiV1CreateFunctionRequest
from dasl_api.models.dbui_v1_create_function_response import DbuiV1CreateFunctionResponse
from dasl_api.models.dbui_v1_create_notebook_request import DbuiV1CreateNotebookRequest
from dasl_api.models.dbui_v1_create_notebook_response import DbuiV1CreateNotebookResponse
from dasl_api.models.dbui_v1_data_source_summary_list import DbuiV1DataSourceSummaryList
from dasl_api.models.dbui_v1_dismiss_operational_alerts_request import DbuiV1DismissOperationalAlertsRequest
from dasl_api.models.dbui_v1_external_location_list import DbuiV1ExternalLocationList
from dasl_api.models.dbui_v1_link_notebook_request import DbuiV1LinkNotebookRequest
from dasl_api.models.dbui_v1_link_notebook_response import DbuiV1LinkNotebookResponse
from dasl_api.models.dbui_v1_list_users_response import DbuiV1ListUsersResponse
from dasl_api.models.dbui_v1_medallion_table_list_response import DbuiV1MedallionTableListResponse
from dasl_api.models.dbui_v1_notable import DbuiV1Notable
from dasl_api.models.dbui_v1_notable_list import DbuiV1NotableList
from dasl_api.models.dbui_v1_notable_summary import DbuiV1NotableSummary
from dasl_api.models.dbui_v1_observable_events_list import DbuiV1ObservableEventsList
from dasl_api.models.dbui_v1_observable_list import DbuiV1ObservableList
from dasl_api.models.dbui_v1_observable_top10_list import DbuiV1ObservableTop10List
from dasl_api.models.dbui_v1_operational_alert import DbuiV1OperationalAlert
from dasl_api.models.dbui_v1_operational_alert_list import DbuiV1OperationalAlertList
from dasl_api.models.dbui_v1_operational_alert_summary import DbuiV1OperationalAlertSummary
from dasl_api.models.dbui_v1_promote_event_request import DbuiV1PromoteEventRequest
from dasl_api.models.dbui_v1_query_extend_request import DbuiV1QueryExtendRequest
from dasl_api.models.dbui_v1_query_generate_request import DbuiV1QueryGenerateRequest
from dasl_api.models.dbui_v1_query_generate_status import DbuiV1QueryGenerateStatus
from dasl_api.models.dbui_v1_query_histogram_request import DbuiV1QueryHistogramRequest
from dasl_api.models.dbui_v1_query_histogram_result import DbuiV1QueryHistogramResult
from dasl_api.models.dbui_v1_query_lookup_request import DbuiV1QueryLookupRequest
from dasl_api.models.dbui_v1_query_lookup_result import DbuiV1QueryLookupResult
from dasl_api.models.dbui_v1_schema_check_response import DbuiV1SchemaCheckResponse
from dasl_api.models.dbui_v1_schema_list import DbuiV1SchemaList
from dasl_api.models.dbui_v1_table_column_list import DbuiV1TableColumnList
from dasl_api.models.dbui_v1_table_list import DbuiV1TableList
from dasl_api.models.dbui_v1_table_preview import DbuiV1TablePreview
from dasl_api.models.dbui_v1_test_access_request import DbuiV1TestAccessRequest
from dasl_api.models.dbui_v1_test_access_response import DbuiV1TestAccessResponse
from dasl_api.models.dbui_v1_transform_request import DbuiV1TransformRequest
from dasl_api.models.dbui_v1_transform_status import DbuiV1TransformStatus
from dasl_api.models.dbui_v1_update_notables_request import DbuiV1UpdateNotablesRequest
from dasl_api.models.dbui_v1_update_observable_risk_request import DbuiV1UpdateObservableRiskRequest
from dasl_api.models.dbui_v1_verify_auth_response import DbuiV1VerifyAuthResponse
from dasl_api.models.dbui_v1_warehouse_item import DbuiV1WarehouseItem
from dasl_api.models.dbui_v1_warehouse_list_response import DbuiV1WarehouseListResponse
from dasl_api.models.dbui_v1_warehouse_ready import DbuiV1WarehouseReady
from dasl_api.models.error import Error
from dasl_api.models.workspace_v1_authenticate_response import WorkspaceV1AuthenticateResponse

from dasl_api.api_client import ApiClient, RequestSerialized
from dasl_api.api_response import ApiResponse
from dasl_api.rest import RESTResponseType


class DbuiV1Api:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def dbui_v1_authenticate(
        self,
        instance_id: Annotated[StrictStr, Field(description="The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com) ")],
        return_page: Annotated[Optional[StrictStr], Field(description="Optional page to return to if three-legged OAuth is successful.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Error:
        """dbui_v1_authenticate

        Start the three-legged OAuth process with Databricks. If returnPage is included and authentication fails, a 302 redirect will be returned with the error JSON added to the redirect as query parameters. If the returnPage is not included and authentication fails, a 4xx error with response will be returned. 

        :param instance_id: The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com)  (required)
        :type instance_id: str
        :param return_page: Optional page to return to if three-legged OAuth is successful.
        :type return_page: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_authenticate_serialize(
            instance_id=instance_id,
            return_page=return_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_authenticate_with_http_info(
        self,
        instance_id: Annotated[StrictStr, Field(description="The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com) ")],
        return_page: Annotated[Optional[StrictStr], Field(description="Optional page to return to if three-legged OAuth is successful.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Error]:
        """dbui_v1_authenticate

        Start the three-legged OAuth process with Databricks. If returnPage is included and authentication fails, a 302 redirect will be returned with the error JSON added to the redirect as query parameters. If the returnPage is not included and authentication fails, a 4xx error with response will be returned. 

        :param instance_id: The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com)  (required)
        :type instance_id: str
        :param return_page: Optional page to return to if three-legged OAuth is successful.
        :type return_page: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_authenticate_serialize(
            instance_id=instance_id,
            return_page=return_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_authenticate_without_preload_content(
        self,
        instance_id: Annotated[StrictStr, Field(description="The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com) ")],
        return_page: Annotated[Optional[StrictStr], Field(description="Optional page to return to if three-legged OAuth is successful.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_authenticate

        Start the three-legged OAuth process with Databricks. If returnPage is included and authentication fails, a 302 redirect will be returned with the error JSON added to the redirect as query parameters. If the returnPage is not included and authentication fails, a 4xx error with response will be returned. 

        :param instance_id: The full databricks instance ID to perform the three-legged OAuth  against (including e.g. .cloud.databricks.com)  (required)
        :type instance_id: str
        :param return_page: Optional page to return to if three-legged OAuth is successful.
        :type return_page: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_authenticate_serialize(
            instance_id=instance_id,
            return_page=return_page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_authenticate_serialize(
        self,
        instance_id,
        return_page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if instance_id is not None:
            
            _query_params.append(('instanceID', instance_id))
            
        if return_page is not None:
            
            _query_params.append(('returnPage', return_page))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/authenticate',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_autoloader_preview(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1AutoloaderPreviewStatus:
        """dbui_v1_autoloader_preview

        Get a preview of an autoloader configuration.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_autoloader_preview_request: (required)
        :type dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_serialize(
            workspace=workspace,
            dbui_v1_autoloader_preview_request=dbui_v1_autoloader_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_autoloader_preview_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1AutoloaderPreviewStatus]:
        """dbui_v1_autoloader_preview

        Get a preview of an autoloader configuration.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_autoloader_preview_request: (required)
        :type dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_serialize(
            workspace=workspace,
            dbui_v1_autoloader_preview_request=dbui_v1_autoloader_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_autoloader_preview_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_autoloader_preview

        Get a preview of an autoloader configuration.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_autoloader_preview_request: (required)
        :type dbui_v1_autoloader_preview_request: DbuiV1AutoloaderPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_serialize(
            workspace=workspace,
            dbui_v1_autoloader_preview_request=dbui_v1_autoloader_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_autoloader_preview_serialize(
        self,
        workspace,
        dbui_v1_autoloader_preview_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_autoloader_preview_request is not None:
            _body_params = dbui_v1_autoloader_preview_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/autoloader-preview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_autoloader_preview_status(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the autoloader preview request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1AutoloaderPreviewStatus:
        """dbui_v1_autoloader_preview_status

        Get the status of an autoloader preview

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the autoloader preview request. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_autoloader_preview_status_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the autoloader preview request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1AutoloaderPreviewStatus]:
        """dbui_v1_autoloader_preview_status

        Get the status of an autoloader preview

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the autoloader preview request. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_autoloader_preview_status_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the autoloader preview request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_autoloader_preview_status

        Get the status of an autoloader preview

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the autoloader preview request. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_autoloader_preview_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1AutoloaderPreviewStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_autoloader_preview_status_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/autoloader-preview/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_check_schema_file(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        file: Annotated[StrictStr, Field(description="Schema file path.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1SchemaCheckResponse:
        """dbui_v1_check_schema_file

        Check a schema file is accessible and valid.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param file: Schema file path. (required)
        :type file: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_check_schema_file_serialize(
            workspace=workspace,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaCheckResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_check_schema_file_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        file: Annotated[StrictStr, Field(description="Schema file path.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1SchemaCheckResponse]:
        """dbui_v1_check_schema_file

        Check a schema file is accessible and valid.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param file: Schema file path. (required)
        :type file: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_check_schema_file_serialize(
            workspace=workspace,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaCheckResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_check_schema_file_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        file: Annotated[StrictStr, Field(description="Schema file path.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_check_schema_file

        Check a schema file is accessible and valid.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param file: Schema file path. (required)
        :type file: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_check_schema_file_serialize(
            workspace=workspace,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaCheckResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_check_schema_file_serialize(
        self,
        workspace,
        file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if file is not None:
            
            _query_params.append(('file', file))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/check-schema-file',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_create_function(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_function_request: DbuiV1CreateFunctionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1CreateFunctionResponse:
        """dbui_v1_create_function

        Create a notebook function.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_function_request: (required)
        :type dbui_v1_create_function_request: DbuiV1CreateFunctionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_function_serialize(
            workspace=workspace,
            dbui_v1_create_function_request=dbui_v1_create_function_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateFunctionResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_create_function_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_function_request: DbuiV1CreateFunctionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1CreateFunctionResponse]:
        """dbui_v1_create_function

        Create a notebook function.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_function_request: (required)
        :type dbui_v1_create_function_request: DbuiV1CreateFunctionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_function_serialize(
            workspace=workspace,
            dbui_v1_create_function_request=dbui_v1_create_function_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateFunctionResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_create_function_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_function_request: DbuiV1CreateFunctionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_create_function

        Create a notebook function.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_function_request: (required)
        :type dbui_v1_create_function_request: DbuiV1CreateFunctionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_function_serialize(
            workspace=workspace,
            dbui_v1_create_function_request=dbui_v1_create_function_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateFunctionResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_create_function_serialize(
        self,
        workspace,
        dbui_v1_create_function_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_create_function_request is not None:
            _body_params = dbui_v1_create_function_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/create-function',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_create_notebook(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1CreateNotebookResponse:
        """dbui_v1_create_notebook

        Create a notebook.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_notebook_request: (required)
        :type dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_notebook_serialize(
            workspace=workspace,
            dbui_v1_create_notebook_request=dbui_v1_create_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_create_notebook_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1CreateNotebookResponse]:
        """dbui_v1_create_notebook

        Create a notebook.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_notebook_request: (required)
        :type dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_notebook_serialize(
            workspace=workspace,
            dbui_v1_create_notebook_request=dbui_v1_create_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_create_notebook_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_create_notebook

        Create a notebook.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_create_notebook_request: (required)
        :type dbui_v1_create_notebook_request: DbuiV1CreateNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_create_notebook_serialize(
            workspace=workspace,
            dbui_v1_create_notebook_request=dbui_v1_create_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1CreateNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_create_notebook_serialize(
        self,
        workspace,
        dbui_v1_create_notebook_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_create_notebook_request is not None:
            _body_params = dbui_v1_create_notebook_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/create-notebook',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_dismiss_operational_alerts(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_dismiss_operational_alerts

        Dismiss a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_dismiss_operational_alerts_request: (required)
        :type dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_dismiss_operational_alerts_serialize(
            workspace=workspace,
            dbui_v1_dismiss_operational_alerts_request=dbui_v1_dismiss_operational_alerts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_dismiss_operational_alerts_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_dismiss_operational_alerts

        Dismiss a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_dismiss_operational_alerts_request: (required)
        :type dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_dismiss_operational_alerts_serialize(
            workspace=workspace,
            dbui_v1_dismiss_operational_alerts_request=dbui_v1_dismiss_operational_alerts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_dismiss_operational_alerts_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_dismiss_operational_alerts

        Dismiss a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_dismiss_operational_alerts_request: (required)
        :type dbui_v1_dismiss_operational_alerts_request: DbuiV1DismissOperationalAlertsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_dismiss_operational_alerts_serialize(
            workspace=workspace,
            dbui_v1_dismiss_operational_alerts_request=dbui_v1_dismiss_operational_alerts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_dismiss_operational_alerts_serialize(
        self,
        workspace,
        dbui_v1_dismiss_operational_alerts_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_dismiss_operational_alerts_request is not None:
            _body_params = dbui_v1_dismiss_operational_alerts_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/alerts/dismiss',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_data_source_summary(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for metrics or not.")] = None,
        rollup_metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for rollup metrics (across all datasources).")] = None,
        alerts: Annotated[Optional[StrictBool], Field(description="Whether to query for alerts or not.")] = None,
        warehouse: Annotated[Optional[StrictStr], Field(description="If metrics is true, what warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1DataSourceSummaryList:
        """dbui_v1_get_data_source_summary

        Get a summary of active datasources.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param metrics: Whether to query for metrics or not.
        :type metrics: bool
        :param rollup_metrics: Whether to query for rollup metrics (across all datasources).
        :type rollup_metrics: bool
        :param alerts: Whether to query for alerts or not.
        :type alerts: bool
        :param warehouse: If metrics is true, what warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_data_source_summary_serialize(
            workspace=workspace,
            metrics=metrics,
            rollup_metrics=rollup_metrics,
            alerts=alerts,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1DataSourceSummaryList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_data_source_summary_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for metrics or not.")] = None,
        rollup_metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for rollup metrics (across all datasources).")] = None,
        alerts: Annotated[Optional[StrictBool], Field(description="Whether to query for alerts or not.")] = None,
        warehouse: Annotated[Optional[StrictStr], Field(description="If metrics is true, what warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1DataSourceSummaryList]:
        """dbui_v1_get_data_source_summary

        Get a summary of active datasources.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param metrics: Whether to query for metrics or not.
        :type metrics: bool
        :param rollup_metrics: Whether to query for rollup metrics (across all datasources).
        :type rollup_metrics: bool
        :param alerts: Whether to query for alerts or not.
        :type alerts: bool
        :param warehouse: If metrics is true, what warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_data_source_summary_serialize(
            workspace=workspace,
            metrics=metrics,
            rollup_metrics=rollup_metrics,
            alerts=alerts,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1DataSourceSummaryList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_data_source_summary_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for metrics or not.")] = None,
        rollup_metrics: Annotated[Optional[StrictBool], Field(description="Whether to query for rollup metrics (across all datasources).")] = None,
        alerts: Annotated[Optional[StrictBool], Field(description="Whether to query for alerts or not.")] = None,
        warehouse: Annotated[Optional[StrictStr], Field(description="If metrics is true, what warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_data_source_summary

        Get a summary of active datasources.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param metrics: Whether to query for metrics or not.
        :type metrics: bool
        :param rollup_metrics: Whether to query for rollup metrics (across all datasources).
        :type rollup_metrics: bool
        :param alerts: Whether to query for alerts or not.
        :type alerts: bool
        :param warehouse: If metrics is true, what warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_data_source_summary_serialize(
            workspace=workspace,
            metrics=metrics,
            rollup_metrics=rollup_metrics,
            alerts=alerts,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1DataSourceSummaryList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_data_source_summary_serialize(
        self,
        workspace,
        metrics,
        rollup_metrics,
        alerts,
        warehouse,
        cached_ok,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if metrics is not None:
            
            _query_params.append(('metrics', metrics))
            
        if rollup_metrics is not None:
            
            _query_params.append(('rollupMetrics', rollup_metrics))
            
        if alerts is not None:
            
            _query_params.append(('alerts', alerts))
            
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cached_ok is not None:
            
            _query_params.append(('cachedOk', cached_ok))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/datasources/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_notable_by_id(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the notable to get the details of")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1Notable:
        """dbui_v1_get_notable_by_id

        Get the details of a notable by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the notable to get the details of (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notable_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1Notable",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_notable_by_id_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the notable to get the details of")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1Notable]:
        """dbui_v1_get_notable_by_id

        Get the details of a notable by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the notable to get the details of (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notable_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1Notable",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_notable_by_id_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the notable to get the details of")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_notable_by_id

        Get the details of a notable by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the notable to get the details of (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notable_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1Notable",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_notable_by_id_serialize(
        self,
        workspace,
        id,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/notables/by-id/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_notables(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="What warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open notables.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get notables before the specified data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1NotableList:
        """dbui_v1_get_notables

        Get a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: What warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open notables.
        :type include_not_open: bool
        :param before_date: Get notables before the specified data.
        :type before_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_notables_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="What warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open notables.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get notables before the specified data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1NotableList]:
        """dbui_v1_get_notables

        Get a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: What warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open notables.
        :type include_not_open: bool
        :param before_date: Get notables before the specified data.
        :type before_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_notables_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="What warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open notables.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get notables before the specified data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_notables

        Get a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: What warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open notables.
        :type include_not_open: bool
        :param before_date: Get notables before the specified data.
        :type before_date: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_notables_serialize(
        self,
        workspace,
        warehouse,
        cursor,
        limit,
        include_not_open,
        before_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if include_not_open is not None:
            
            _query_params.append(('includeNotOpen', include_not_open))
            
        if before_date is not None:
            if isinstance(before_date, datetime):
                _query_params.append(
                    (
                        'beforeDate',
                        before_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('beforeDate', before_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/notables',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_notables_summary(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1NotableSummary:
        """dbui_v1_get_notables_summary

        Get a summary of the current notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_notables_summary_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1NotableSummary]:
        """dbui_v1_get_notables_summary

        Get a summary of the current notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_notables_summary_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_notables_summary

        Get a summary of the current notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_notables_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1NotableSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_notables_summary_serialize(
        self,
        workspace,
        warehouse,
        cached_ok,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cached_ok is not None:
            
            _query_params.append(('cachedOk', cached_ok))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/notables/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_observable_events(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ObservableEventsList:
        """dbui_v1_get_observable_events

        Fetch all the contributing risk events for this notable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_events_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableEventsList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_observable_events_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ObservableEventsList]:
        """dbui_v1_get_observable_events

        Fetch all the contributing risk events for this notable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_events_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableEventsList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_observable_events_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_observable_events

        Fetch all the contributing risk events for this notable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_events_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableEventsList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_observable_events_serialize(
        self,
        workspace,
        warehouse,
        kind,
        value,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if kind is not None:
            _path_params['kind'] = kind
        if value is not None:
            _path_params['value'] = value
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind}/{value}/events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_observable_kind(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ObservableList:
        """dbui_v1_get_observable_kind

        Get a list of observables of a specific kind.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_kind_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_observable_kind_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ObservableList]:
        """dbui_v1_get_observable_kind

        Get a list of observables of a specific kind.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_kind_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_observable_kind_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of records to return.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_observable_kind

        Get a list of observables of a specific kind.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results
        :type cursor: str
        :param limit: The number of records to return.
        :type limit: float
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_kind_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_observable_kind_serialize(
        self,
        workspace,
        warehouse,
        kind,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if kind is not None:
            _path_params['kind'] = kind
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_observable_top10(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ObservableTop10List:
        """dbui_v1_get_observable_top10

        Get the top 10 observables of each kind, by risk.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_top10_serialize(
            workspace=workspace,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableTop10List",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_observable_top10_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ObservableTop10List]:
        """dbui_v1_get_observable_top10

        Get the top 10 observables of each kind, by risk.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_top10_serialize(
            workspace=workspace,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableTop10List",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_observable_top10_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_observable_top10

        Get the top 10 observables of each kind, by risk.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_observable_top10_serialize(
            workspace=workspace,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ObservableTop10List",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_observable_top10_serialize(
        self,
        workspace,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/observables/top10',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_operational_alert_by_id(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the operational alert to get the details of.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1OperationalAlert:
        """dbui_v1_get_operational_alert_by_id

        Get the details of an operational alert by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the operational alert to get the details of. (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alert_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlert",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_operational_alert_by_id_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the operational alert to get the details of.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1OperationalAlert]:
        """dbui_v1_get_operational_alert_by_id

        Get the details of an operational alert by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the operational alert to get the details of. (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alert_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlert",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_operational_alert_by_id_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The identifier of the operational alert to get the details of.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_operational_alert_by_id

        Get the details of an operational alert by ID.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The identifier of the operational alert to get the details of. (required)
        :type id: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alert_by_id_serialize(
            workspace=workspace,
            id=id,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlert",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_operational_alert_by_id_serialize(
        self,
        workspace,
        id,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/alerts/by-id/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_operational_alerts(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of alerts to get.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open alerts.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get alerts before the specified data.")] = None,
        resource_type: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource type.")] = None,
        resource_name: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1OperationalAlertList:
        """dbui_v1_get_operational_alerts

        Get a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of alerts to get.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open alerts.
        :type include_not_open: bool
        :param before_date: Get alerts before the specified data.
        :type before_date: datetime
        :param resource_type: Get alerts matching this resource type.
        :type resource_type: str
        :param resource_name: Get alerts matching this resource name.
        :type resource_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            resource_type=resource_type,
            resource_name=resource_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_operational_alerts_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of alerts to get.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open alerts.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get alerts before the specified data.")] = None,
        resource_type: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource type.")] = None,
        resource_name: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1OperationalAlertList]:
        """dbui_v1_get_operational_alerts

        Get a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of alerts to get.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open alerts.
        :type include_not_open: bool
        :param before_date: Get alerts before the specified data.
        :type before_date: datetime
        :param resource_type: Get alerts matching this resource type.
        :type resource_type: str
        :param resource_name: Get alerts matching this resource name.
        :type resource_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            resource_type=resource_type,
            resource_name=resource_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_operational_alerts_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="An identifier that can be passed to the next get call to receive the next page of results.")] = None,
        limit: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="The number of alerts to get.")] = None,
        include_not_open: Annotated[Optional[StrictBool], Field(description="Specify inclusion of non-open alerts.")] = None,
        before_date: Annotated[Optional[datetime], Field(description="Get alerts before the specified data.")] = None,
        resource_type: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource type.")] = None,
        resource_name: Annotated[Optional[StrictStr], Field(description="Get alerts matching this resource name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_operational_alerts

        Get a list of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cursor: An identifier that can be passed to the next get call to receive the next page of results.
        :type cursor: str
        :param limit: The number of alerts to get.
        :type limit: float
        :param include_not_open: Specify inclusion of non-open alerts.
        :type include_not_open: bool
        :param before_date: Get alerts before the specified data.
        :type before_date: datetime
        :param resource_type: Get alerts matching this resource type.
        :type resource_type: str
        :param resource_name: Get alerts matching this resource name.
        :type resource_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cursor=cursor,
            limit=limit,
            include_not_open=include_not_open,
            before_date=before_date,
            resource_type=resource_type,
            resource_name=resource_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_operational_alerts_serialize(
        self,
        workspace,
        warehouse,
        cursor,
        limit,
        include_not_open,
        before_date,
        resource_type,
        resource_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if include_not_open is not None:
            
            _query_params.append(('includeNotOpen', include_not_open))
            
        if before_date is not None:
            if isinstance(before_date, datetime):
                _query_params.append(
                    (
                        'beforeDate',
                        before_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('beforeDate', before_date))
            
        if resource_type is not None:
            
            _query_params.append(('resourceType', resource_type))
            
        if resource_name is not None:
            
            _query_params.append(('resourceName', resource_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/alerts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_get_operational_alerts_summary(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1OperationalAlertSummary:
        """dbui_v1_get_operational_alerts_summary

        Get a summary of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_get_operational_alerts_summary_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1OperationalAlertSummary]:
        """dbui_v1_get_operational_alerts_summary

        Get a summary of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_get_operational_alerts_summary_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        cached_ok: Annotated[Optional[StrictBool], Field(description="Whether to use cached results if available.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_get_operational_alerts_summary

        Get a summary of operational alerts.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param cached_ok: Whether to use cached results if available.
        :type cached_ok: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_get_operational_alerts_summary_serialize(
            workspace=workspace,
            warehouse=warehouse,
            cached_ok=cached_ok,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1OperationalAlertSummary",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_get_operational_alerts_summary_serialize(
        self,
        workspace,
        warehouse,
        cached_ok,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if cached_ok is not None:
            
            _query_params.append(('cachedOk', cached_ok))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/alerts/summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_link_notebook(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1LinkNotebookResponse:
        """dbui_v1_link_notebook

        Get a link to a notebook (and optional function within)

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_link_notebook_request: (required)
        :type dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_link_notebook_serialize(
            workspace=workspace,
            dbui_v1_link_notebook_request=dbui_v1_link_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1LinkNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_link_notebook_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1LinkNotebookResponse]:
        """dbui_v1_link_notebook

        Get a link to a notebook (and optional function within)

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_link_notebook_request: (required)
        :type dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_link_notebook_serialize(
            workspace=workspace,
            dbui_v1_link_notebook_request=dbui_v1_link_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1LinkNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_link_notebook_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_link_notebook

        Get a link to a notebook (and optional function within)

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_link_notebook_request: (required)
        :type dbui_v1_link_notebook_request: DbuiV1LinkNotebookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_link_notebook_serialize(
            workspace=workspace,
            dbui_v1_link_notebook_request=dbui_v1_link_notebook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1LinkNotebookResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_link_notebook_serialize(
        self,
        workspace,
        dbui_v1_link_notebook_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_link_notebook_request is not None:
            _body_params = dbui_v1_link_notebook_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/link-notebook',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_catalog_schemas(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to list schemas from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1SchemaList:
        """dbui_v1_list_catalog_schemas

        Given a catalog with read access, this endpoint will return all schemas in that catalog. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to list schemas from. (required)
        :type catalog: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_catalog_schemas_serialize(
            workspace=workspace,
            catalog=catalog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_catalog_schemas_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to list schemas from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1SchemaList]:
        """dbui_v1_list_catalog_schemas

        Given a catalog with read access, this endpoint will return all schemas in that catalog. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to list schemas from. (required)
        :type catalog: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_catalog_schemas_serialize(
            workspace=workspace,
            catalog=catalog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_catalog_schemas_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to list schemas from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_catalog_schemas

        Given a catalog with read access, this endpoint will return all schemas in that catalog. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to list schemas from. (required)
        :type catalog: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_catalog_schemas_serialize(
            workspace=workspace,
            catalog=catalog,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1SchemaList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_catalog_schemas_serialize(
        self,
        workspace,
        catalog,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if catalog is not None:
            
            _query_params.append(('catalog', catalog))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/explore/schemas/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_columns(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        table: Annotated[StrictStr, Field(description="The name of the table.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TableColumnList:
        """dbui_v1_list_columns

        List all columns in a source table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param table: The name of the table. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_columns_serialize(
            workspace=workspace,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_columns_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        table: Annotated[StrictStr, Field(description="The name of the table.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TableColumnList]:
        """dbui_v1_list_columns

        List all columns in a source table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param table: The name of the table. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_columns_serialize(
            workspace=workspace,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_columns_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        table: Annotated[StrictStr, Field(description="The name of the table.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_columns

        List all columns in a source table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param table: The name of the table. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_columns_serialize(
            workspace=workspace,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_columns_serialize(
        self,
        workspace,
        table,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if table is not None:
            _path_params['table'] = table
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/tables/{table}/columns',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_external_locations(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ExternalLocationList:
        """dbui_v1_list_external_locations

        Get a list of external locations.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_external_locations_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ExternalLocationList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_external_locations_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ExternalLocationList]:
        """dbui_v1_list_external_locations

        Get a list of external locations.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_external_locations_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ExternalLocationList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_external_locations_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_external_locations

        Get a list of external locations.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_external_locations_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ExternalLocationList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_external_locations_serialize(
        self,
        workspace,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/external-locations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_schema_tables(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to list tables from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TableList:
        """dbui_v1_list_schema_tables

        Given a catalog and schema with read access, this endpoint will return all  tables in that catalog.schema. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to list tables from. (required)
        :type var_schema: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_schema_tables_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_schema_tables_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to list tables from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TableList]:
        """dbui_v1_list_schema_tables

        Given a catalog and schema with read access, this endpoint will return all  tables in that catalog.schema. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to list tables from. (required)
        :type var_schema: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_schema_tables_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_schema_tables_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to list tables from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_schema_tables

        Given a catalog and schema with read access, this endpoint will return all  tables in that catalog.schema. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to list tables from. (required)
        :type var_schema: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_schema_tables_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TableList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_schema_tables_serialize(
        self,
        workspace,
        catalog,
        var_schema,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if catalog is not None:
            
            _query_params.append(('catalog', catalog))
            
        if var_schema is not None:
            
            _query_params.append(('schema', var_schema))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/explore/tables/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_table_columns(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to access table in.")],
        table: Annotated[StrictStr, Field(description="Table to list columns from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ColumnList:
        """dbui_v1_list_table_columns

        Given a catalog, schema and table with read access, this endpoint will  return all columns in that catalog.schema.table. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to access table in. (required)
        :type var_schema: str
        :param table: Table to list columns from. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_table_columns_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_table_columns_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to access table in.")],
        table: Annotated[StrictStr, Field(description="Table to list columns from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ColumnList]:
        """dbui_v1_list_table_columns

        Given a catalog, schema and table with read access, this endpoint will  return all columns in that catalog.schema.table. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to access table in. (required)
        :type var_schema: str
        :param table: Table to list columns from. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_table_columns_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_table_columns_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        catalog: Annotated[StrictStr, Field(description="Catalog to access schema in.")],
        var_schema: Annotated[StrictStr, Field(description="Schema to access table in.")],
        table: Annotated[StrictStr, Field(description="Table to list columns from.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_table_columns

        Given a catalog, schema and table with read access, this endpoint will  return all columns in that catalog.schema.table. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param catalog: Catalog to access schema in. (required)
        :type catalog: str
        :param var_schema: Schema to access table in. (required)
        :type var_schema: str
        :param table: Table to list columns from. (required)
        :type table: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_table_columns_serialize(
            workspace=workspace,
            catalog=catalog,
            var_schema=var_schema,
            table=table,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ColumnList",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_table_columns_serialize(
        self,
        workspace,
        catalog,
        var_schema,
        table,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if catalog is not None:
            
            _query_params.append(('catalog', catalog))
            
        if var_schema is not None:
            
            _query_params.append(('schema', var_schema))
            
        if table is not None:
            
            _query_params.append(('table', table))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/explore/columns/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_list_users(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Number of results to fetch per page.")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Only include users whose userName begins with this.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1ListUsersResponse:
        """dbui_v1_list_users

        Get a list of users in a workspace.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param prefix: Only include users whose userName begins with this.
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_users_serialize(
            workspace=workspace,
            page=page,
            page_size=page_size,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ListUsersResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_list_users_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Number of results to fetch per page.")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Only include users whose userName begins with this.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1ListUsersResponse]:
        """dbui_v1_list_users

        Get a list of users in a workspace.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param prefix: Only include users whose userName begins with this.
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_users_serialize(
            workspace=workspace,
            page=page,
            page_size=page_size,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ListUsersResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_list_users_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Number of results to fetch per page.")] = None,
        prefix: Annotated[Optional[StrictStr], Field(description="Only include users whose userName begins with this.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_list_users

        Get a list of users in a workspace.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param prefix: Only include users whose userName begins with this.
        :type prefix: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_list_users_serialize(
            workspace=workspace,
            page=page,
            page_size=page_size,
            prefix=prefix,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1ListUsersResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_list_users_serialize(
        self,
        workspace,
        page,
        page_size,
        prefix,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if prefix is not None:
            
            _query_params.append(('prefix', prefix))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_medallion_table_list(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        medallion_layer: Annotated[StrictStr, Field(description="The name of the medallion layer.")],
        resource_type: Annotated[StrictStr, Field(description="For which resource type to retrieve the medallion tables for.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1MedallionTableListResponse:
        """dbui_v1_medallion_table_list

        List all tables that exist within given medallion layer. Returns the first 1000 available tables sorted by name.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param medallion_layer: The name of the medallion layer. (required)
        :type medallion_layer: str
        :param resource_type: For which resource type to retrieve the medallion tables for. (required)
        :type resource_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_medallion_table_list_serialize(
            workspace=workspace,
            medallion_layer=medallion_layer,
            resource_type=resource_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1MedallionTableListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_medallion_table_list_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        medallion_layer: Annotated[StrictStr, Field(description="The name of the medallion layer.")],
        resource_type: Annotated[StrictStr, Field(description="For which resource type to retrieve the medallion tables for.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1MedallionTableListResponse]:
        """dbui_v1_medallion_table_list

        List all tables that exist within given medallion layer. Returns the first 1000 available tables sorted by name.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param medallion_layer: The name of the medallion layer. (required)
        :type medallion_layer: str
        :param resource_type: For which resource type to retrieve the medallion tables for. (required)
        :type resource_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_medallion_table_list_serialize(
            workspace=workspace,
            medallion_layer=medallion_layer,
            resource_type=resource_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1MedallionTableListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_medallion_table_list_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        medallion_layer: Annotated[StrictStr, Field(description="The name of the medallion layer.")],
        resource_type: Annotated[StrictStr, Field(description="For which resource type to retrieve the medallion tables for.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_medallion_table_list

        List all tables that exist within given medallion layer. Returns the first 1000 available tables sorted by name.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param medallion_layer: The name of the medallion layer. (required)
        :type medallion_layer: str
        :param resource_type: For which resource type to retrieve the medallion tables for. (required)
        :type resource_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_medallion_table_list_serialize(
            workspace=workspace,
            medallion_layer=medallion_layer,
            resource_type=resource_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1MedallionTableListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_medallion_table_list_serialize(
        self,
        workspace,
        medallion_layer,
        resource_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if medallion_layer is not None:
            _path_params['medallionLayer'] = medallion_layer
        # process the query parameters
        if resource_type is not None:
            
            _query_params.append(('resourceType', resource_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/medallion/{medallionLayer}/tables/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_promote_event_to_notable(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_promote_event_request: DbuiV1PromoteEventRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_promote_event_to_notable

        Create a notable from an event.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_promote_event_request: (required)
        :type dbui_v1_promote_event_request: DbuiV1PromoteEventRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_promote_event_to_notable_serialize(
            workspace=workspace,
            dbui_v1_promote_event_request=dbui_v1_promote_event_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_promote_event_to_notable_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_promote_event_request: DbuiV1PromoteEventRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_promote_event_to_notable

        Create a notable from an event.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_promote_event_request: (required)
        :type dbui_v1_promote_event_request: DbuiV1PromoteEventRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_promote_event_to_notable_serialize(
            workspace=workspace,
            dbui_v1_promote_event_request=dbui_v1_promote_event_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_promote_event_to_notable_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_promote_event_request: DbuiV1PromoteEventRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_promote_event_to_notable

        Create a notable from an event.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_promote_event_request: (required)
        :type dbui_v1_promote_event_request: DbuiV1PromoteEventRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_promote_event_to_notable_serialize(
            workspace=workspace,
            dbui_v1_promote_event_request=dbui_v1_promote_event_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_promote_event_to_notable_serialize(
        self,
        workspace,
        dbui_v1_promote_event_request,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_promote_event_request is not None:
            _body_params = dbui_v1_promote_event_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/notables',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_cancel(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to cancel")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_query_cancel

        Cancel an existing query

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to cancel (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_cancel_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_cancel_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to cancel")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_query_cancel

        Cancel an existing query

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to cancel (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_cancel_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_cancel_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to cancel")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_cancel

        Cancel an existing query

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to cancel (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_cancel_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_cancel_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query/{id}/cancel',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_extend(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to extend.")],
        dbui_v1_query_extend_request: DbuiV1QueryExtendRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1QueryGenerateStatus:
        """dbui_v1_query_extend

        Extend the time range of an existing query. Will update the results to include rows constrained by the new time range. Note that the returned ID may differ from the original. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to extend. (required)
        :type id: str
        :param dbui_v1_query_extend_request: (required)
        :type dbui_v1_query_extend_request: DbuiV1QueryExtendRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_extend_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_extend_request=dbui_v1_query_extend_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_extend_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to extend.")],
        dbui_v1_query_extend_request: DbuiV1QueryExtendRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1QueryGenerateStatus]:
        """dbui_v1_query_extend

        Extend the time range of an existing query. Will update the results to include rows constrained by the new time range. Note that the returned ID may differ from the original. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to extend. (required)
        :type id: str
        :param dbui_v1_query_extend_request: (required)
        :type dbui_v1_query_extend_request: DbuiV1QueryExtendRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_extend_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_extend_request=dbui_v1_query_extend_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_extend_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to extend.")],
        dbui_v1_query_extend_request: DbuiV1QueryExtendRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_extend

        Extend the time range of an existing query. Will update the results to include rows constrained by the new time range. Note that the returned ID may differ from the original. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to extend. (required)
        :type id: str
        :param dbui_v1_query_extend_request: (required)
        :type dbui_v1_query_extend_request: DbuiV1QueryExtendRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_extend_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_extend_request=dbui_v1_query_extend_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_extend_serialize(
        self,
        workspace,
        id,
        dbui_v1_query_extend_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_query_extend_request is not None:
            _body_params = dbui_v1_query_extend_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query/{id}/extend',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_generate(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1QueryGenerateStatus:
        """dbui_v1_query_generate

        Create a delta table using the provided query as input. Once generated data can be collected from this table using lookup operations. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_query_generate_request: (required)
        :type dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_serialize(
            workspace=workspace,
            dbui_v1_query_generate_request=dbui_v1_query_generate_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_generate_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1QueryGenerateStatus]:
        """dbui_v1_query_generate

        Create a delta table using the provided query as input. Once generated data can be collected from this table using lookup operations. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_query_generate_request: (required)
        :type dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_serialize(
            workspace=workspace,
            dbui_v1_query_generate_request=dbui_v1_query_generate_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_generate_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_generate

        Create a delta table using the provided query as input. Once generated data can be collected from this table using lookup operations. 

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_query_generate_request: (required)
        :type dbui_v1_query_generate_request: DbuiV1QueryGenerateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_serialize(
            workspace=workspace,
            dbui_v1_query_generate_request=dbui_v1_query_generate_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_generate_serialize(
        self,
        workspace,
        dbui_v1_query_generate_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_query_generate_request is not None:
            _body_params = dbui_v1_query_generate_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_generate_status(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to fetch the status of.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1QueryGenerateStatus:
        """dbui_v1_query_generate_status

        Get the status of a generate delta table operation.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to fetch the status of. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_generate_status_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to fetch the status of.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1QueryGenerateStatus]:
        """dbui_v1_query_generate_status

        Get the status of a generate delta table operation.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to fetch the status of. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_generate_status_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to fetch the status of.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_generate_status

        Get the status of a generate delta table operation.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to fetch the status of. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_generate_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryGenerateStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_generate_status_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query/{id}/status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_histogram(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perform the request against.")],
        dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1QueryHistogramResult:
        """dbui_v1_query_histogram

        Fetch a frequency count of query records over a specified range.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perform the request against. (required)
        :type id: str
        :param dbui_v1_query_histogram_request: (required)
        :type dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_histogram_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_histogram_request=dbui_v1_query_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryHistogramResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_histogram_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perform the request against.")],
        dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1QueryHistogramResult]:
        """dbui_v1_query_histogram

        Fetch a frequency count of query records over a specified range.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perform the request against. (required)
        :type id: str
        :param dbui_v1_query_histogram_request: (required)
        :type dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_histogram_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_histogram_request=dbui_v1_query_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryHistogramResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_histogram_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perform the request against.")],
        dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_histogram

        Fetch a frequency count of query records over a specified range.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perform the request against. (required)
        :type id: str
        :param dbui_v1_query_histogram_request: (required)
        :type dbui_v1_query_histogram_request: DbuiV1QueryHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_histogram_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_histogram_request=dbui_v1_query_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryHistogramResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_histogram_serialize(
        self,
        workspace,
        id,
        dbui_v1_query_histogram_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_query_histogram_request is not None:
            _body_params = dbui_v1_query_histogram_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query/{id}/histogram',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_query_lookup(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perfrom the lookup against.")],
        dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1QueryLookupResult:
        """dbui_v1_query_lookup

        Perform a lookup operation against an existing query result

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perfrom the lookup against. (required)
        :type id: str
        :param dbui_v1_query_lookup_request: (required)
        :type dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_lookup_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_lookup_request=dbui_v1_query_lookup_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryLookupResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_query_lookup_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perfrom the lookup against.")],
        dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1QueryLookupResult]:
        """dbui_v1_query_lookup

        Perform a lookup operation against an existing query result

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perfrom the lookup against. (required)
        :type id: str
        :param dbui_v1_query_lookup_request: (required)
        :type dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_lookup_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_lookup_request=dbui_v1_query_lookup_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryLookupResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_query_lookup_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the query to perfrom the lookup against.")],
        dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_query_lookup

        Perform a lookup operation against an existing query result

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the query to perfrom the lookup against. (required)
        :type id: str
        :param dbui_v1_query_lookup_request: (required)
        :type dbui_v1_query_lookup_request: DbuiV1QueryLookupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_query_lookup_serialize(
            workspace=workspace,
            id=id,
            dbui_v1_query_lookup_request=dbui_v1_query_lookup_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1QueryLookupResult",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_query_lookup_serialize(
        self,
        workspace,
        id,
        dbui_v1_query_lookup_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_query_lookup_request is not None:
            _body_params = dbui_v1_query_lookup_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/query/{id}/lookup',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_refresh_token(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkspaceV1AuthenticateResponse:
        """dbui_v1_refresh_token

        Refresh the requester's auth token.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_refresh_token_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceV1AuthenticateResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_refresh_token_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkspaceV1AuthenticateResponse]:
        """dbui_v1_refresh_token

        Refresh the requester's auth token.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_refresh_token_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceV1AuthenticateResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_refresh_token_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_refresh_token

        Refresh the requester's auth token.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_refresh_token_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkspaceV1AuthenticateResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_refresh_token_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/refresh-token',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_table_preview(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        name: Annotated[StrictStr, Field(description="The table name.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to fetch per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TablePreview:
        """dbui_v1_table_preview

        Get a preview of a table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param name: The table name. (required)
        :type name: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_table_preview_serialize(
            workspace=workspace,
            warehouse=warehouse,
            name=name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TablePreview",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_table_preview_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        name: Annotated[StrictStr, Field(description="The table name.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to fetch per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TablePreview]:
        """dbui_v1_table_preview

        Get a preview of a table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param name: The table name. (required)
        :type name: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_table_preview_serialize(
            workspace=workspace,
            warehouse=warehouse,
            name=name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TablePreview",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_table_preview_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        name: Annotated[StrictStr, Field(description="The table name.")],
        page: Annotated[Optional[StrictInt], Field(description="Which page of results to return.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to fetch per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_table_preview

        Get a preview of a table.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param name: The table name. (required)
        :type name: str
        :param page: Which page of results to return.
        :type page: int
        :param page_size: Number of results to fetch per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_table_preview_serialize(
            workspace=workspace,
            warehouse=warehouse,
            name=name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TablePreview",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_table_preview_serialize(
        self,
        workspace,
        warehouse,
        name,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/table-preview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_test_access(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_test_access_request: DbuiV1TestAccessRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TestAccessResponse:
        """dbui_v1_test_access

        Test the access for a Unity Catalog path or table. If the system cannot determine existence of a path or table  due to a lack of permissions then an error is returned. See the TestAccessResponse object for more information on a successful response. 

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_test_access_request: (required)
        :type dbui_v1_test_access_request: DbuiV1TestAccessRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_test_access_serialize(
            workspace=workspace,
            dbui_v1_test_access_request=dbui_v1_test_access_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TestAccessResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
            '412': "PreconditionFailedError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_test_access_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_test_access_request: DbuiV1TestAccessRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TestAccessResponse]:
        """dbui_v1_test_access

        Test the access for a Unity Catalog path or table. If the system cannot determine existence of a path or table  due to a lack of permissions then an error is returned. See the TestAccessResponse object for more information on a successful response. 

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_test_access_request: (required)
        :type dbui_v1_test_access_request: DbuiV1TestAccessRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_test_access_serialize(
            workspace=workspace,
            dbui_v1_test_access_request=dbui_v1_test_access_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TestAccessResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
            '412': "PreconditionFailedError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_test_access_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace")],
        dbui_v1_test_access_request: DbuiV1TestAccessRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_test_access

        Test the access for a Unity Catalog path or table. If the system cannot determine existence of a path or table  due to a lack of permissions then an error is returned. See the TestAccessResponse object for more information on a successful response. 

        :param workspace: The name of the workspace (required)
        :type workspace: str
        :param dbui_v1_test_access_request: (required)
        :type dbui_v1_test_access_request: DbuiV1TestAccessRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_test_access_serialize(
            workspace=workspace,
            dbui_v1_test_access_request=dbui_v1_test_access_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TestAccessResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
            '412': "PreconditionFailedError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_test_access_serialize(
        self,
        workspace,
        dbui_v1_test_access_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_test_access_request is not None:
            _body_params = dbui_v1_test_access_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/test-access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_token_exchange(
        self,
        code: Annotated[StrictStr, Field(description="The token to exchange.")],
        state: Annotated[StrictStr, Field(description="The returned encrypted state object returned provided by Antimatter.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Error:
        """dbui_v1_token_exchange

        Perform token exchange with Databricks instance to acquire access token JWT.

        :param code: The token to exchange. (required)
        :type code: str
        :param state: The returned encrypted state object returned provided by Antimatter. (required)
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_token_exchange_serialize(
            code=code,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_token_exchange_with_http_info(
        self,
        code: Annotated[StrictStr, Field(description="The token to exchange.")],
        state: Annotated[StrictStr, Field(description="The returned encrypted state object returned provided by Antimatter.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Error]:
        """dbui_v1_token_exchange

        Perform token exchange with Databricks instance to acquire access token JWT.

        :param code: The token to exchange. (required)
        :type code: str
        :param state: The returned encrypted state object returned provided by Antimatter. (required)
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_token_exchange_serialize(
            code=code,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_token_exchange_without_preload_content(
        self,
        code: Annotated[StrictStr, Field(description="The token to exchange.")],
        state: Annotated[StrictStr, Field(description="The returned encrypted state object returned provided by Antimatter.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_token_exchange

        Perform token exchange with Databricks instance to acquire access token JWT.

        :param code: The token to exchange. (required)
        :type code: str
        :param state: The returned encrypted state object returned provided by Antimatter. (required)
        :type state: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_token_exchange_serialize(
            code=code,
            state=state,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '302': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_token_exchange_serialize(
        self,
        code,
        state,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if code is not None:
            
            _query_params.append(('code', code))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/token-exchange',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_transform(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        dbui_v1_transform_request: DbuiV1TransformRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TransformStatus:
        """dbui_v1_transform

        Transform a set of records.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param dbui_v1_transform_request: (required)
        :type dbui_v1_transform_request: DbuiV1TransformRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_serialize(
            workspace=workspace,
            warehouse=warehouse,
            dbui_v1_transform_request=dbui_v1_transform_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_transform_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        dbui_v1_transform_request: DbuiV1TransformRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TransformStatus]:
        """dbui_v1_transform

        Transform a set of records.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param dbui_v1_transform_request: (required)
        :type dbui_v1_transform_request: DbuiV1TransformRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_serialize(
            workspace=workspace,
            warehouse=warehouse,
            dbui_v1_transform_request=dbui_v1_transform_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_transform_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        dbui_v1_transform_request: DbuiV1TransformRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_transform

        Transform a set of records.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param dbui_v1_transform_request: (required)
        :type dbui_v1_transform_request: DbuiV1TransformRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_serialize(
            workspace=workspace,
            warehouse=warehouse,
            dbui_v1_transform_request=dbui_v1_transform_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_transform_serialize(
        self,
        workspace,
        warehouse,
        dbui_v1_transform_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_transform_request is not None:
            _body_params = dbui_v1_transform_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/transform',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_transform_status(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the transform.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1TransformStatus:
        """dbui_v1_transform_status

        Get the status of a transform

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the transform. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_transform_status_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the transform.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1TransformStatus]:
        """dbui_v1_transform_status

        Get the status of a transform

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the transform. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_transform_status_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The id of the transform.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_transform_status

        Get the status of a transform

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The id of the transform. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_transform_status_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1TransformStatus",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_transform_status_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/transform/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_update_notable(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_update_notable

        Update a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_update_notables_request: (required)
        :type dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_notable_serialize(
            workspace=workspace,
            dbui_v1_update_notables_request=dbui_v1_update_notables_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_update_notable_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_update_notable

        Update a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_update_notables_request: (required)
        :type dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_notable_serialize(
            workspace=workspace,
            dbui_v1_update_notables_request=dbui_v1_update_notables_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_update_notable_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest,
        warehouse: Annotated[Optional[StrictStr], Field(description="The SQL warehouse ID to use.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_update_notable

        Update a list of notables.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param dbui_v1_update_notables_request: (required)
        :type dbui_v1_update_notables_request: DbuiV1UpdateNotablesRequest
        :param warehouse: The SQL warehouse ID to use.
        :type warehouse: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_notable_serialize(
            workspace=workspace,
            dbui_v1_update_notables_request=dbui_v1_update_notables_request,
            warehouse=warehouse,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_update_notable_serialize(
        self,
        workspace,
        dbui_v1_update_notables_request,
        warehouse,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_update_notables_request is not None:
            _body_params = dbui_v1_update_notables_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/notables/update',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_update_observable_risk(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_update_observable_risk

        Updates the risk score for a specific observable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param dbui_v1_update_observable_risk_request: (required)
        :type dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_observable_risk_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            dbui_v1_update_observable_risk_request=dbui_v1_update_observable_risk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_update_observable_risk_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_update_observable_risk

        Updates the risk score for a specific observable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param dbui_v1_update_observable_risk_request: (required)
        :type dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_observable_risk_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            dbui_v1_update_observable_risk_request=dbui_v1_update_observable_risk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_update_observable_risk_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        warehouse: Annotated[StrictStr, Field(description="The SQL warehouse ID to use.")],
        kind: Annotated[StrictStr, Field(description="Specify what kind of observables to fetch.")],
        value: Annotated[StrictStr, Field(description="URL encoded value of the observable.")],
        dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_update_observable_risk

        Updates the risk score for a specific observable.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param warehouse: The SQL warehouse ID to use. (required)
        :type warehouse: str
        :param kind: Specify what kind of observables to fetch. (required)
        :type kind: str
        :param value: URL encoded value of the observable. (required)
        :type value: str
        :param dbui_v1_update_observable_risk_request: (required)
        :type dbui_v1_update_observable_risk_request: DbuiV1UpdateObservableRiskRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_update_observable_risk_serialize(
            workspace=workspace,
            warehouse=warehouse,
            kind=kind,
            value=value,
            dbui_v1_update_observable_risk_request=dbui_v1_update_observable_risk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_update_observable_risk_serialize(
        self,
        workspace,
        warehouse,
        kind,
        value,
        dbui_v1_update_observable_risk_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if kind is not None:
            _path_params['kind'] = kind
        if value is not None:
            _path_params['value'] = value
        # process the query parameters
        if warehouse is not None:
            
            _query_params.append(('warehouse', warehouse))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if dbui_v1_update_observable_risk_request is not None:
            _body_params = dbui_v1_update_observable_risk_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/observables/kinds/{kind}/{value}/update',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_verify_auth(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1VerifyAuthResponse:
        """dbui_v1_verify_auth

        Get information about the requester's auth cookie.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_verify_auth_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1VerifyAuthResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_verify_auth_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1VerifyAuthResponse]:
        """dbui_v1_verify_auth

        Get information about the requester's auth cookie.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_verify_auth_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1VerifyAuthResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_verify_auth_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_verify_auth

        Get information about the requester's auth cookie.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_verify_auth_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1VerifyAuthResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_verify_auth_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/verify-auth',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_warehouse_get(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1WarehouseItem:
        """dbui_v1_warehouse_get

        Get the current info of a specific warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_get_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseItem",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_warehouse_get_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1WarehouseItem]:
        """dbui_v1_warehouse_get

        Get the current info of a specific warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_get_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseItem",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_warehouse_get_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_warehouse_get

        Get the current info of a specific warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_get_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseItem",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_warehouse_get_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/warehouse/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_warehouse_list(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1WarehouseListResponse:
        """dbui_v1_warehouse_list

        List SQL warehouses the authenticated user has manager permissions to.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_list_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_warehouse_list_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1WarehouseListResponse]:
        """dbui_v1_warehouse_list

        List SQL warehouses the authenticated user has manager permissions to.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_list_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_warehouse_list_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_warehouse_list

        List SQL warehouses the authenticated user has manager permissions to.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_list_serialize(
            workspace=workspace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseListResponse",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_warehouse_list_serialize(
        self,
        workspace,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/warehouse',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_warehouse_running(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DbuiV1WarehouseReady:
        """dbui_v1_warehouse_running

        Check if a warehouse is running.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_running_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseReady",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_warehouse_running_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DbuiV1WarehouseReady]:
        """dbui_v1_warehouse_running

        Check if a warehouse is running.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_running_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseReady",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_warehouse_running_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_warehouse_running

        Check if a warehouse is running.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_running_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DbuiV1WarehouseReady",
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_warehouse_running_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/warehouse/{id}/running',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def dbui_v1_warehouse_start(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """dbui_v1_warehouse_start

        Start a warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_start_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def dbui_v1_warehouse_start_with_http_info(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """dbui_v1_warehouse_start

        Start a warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_start_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def dbui_v1_warehouse_start_without_preload_content(
        self,
        workspace: Annotated[StrictStr, Field(description="The name of the workspace.")],
        id: Annotated[StrictStr, Field(description="The warehouse ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """dbui_v1_warehouse_start

        Start a warehouse.

        :param workspace: The name of the workspace. (required)
        :type workspace: str
        :param id: The warehouse ID. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._dbui_v1_warehouse_start_serialize(
            workspace=workspace,
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "InvalidRequestError",
            '401': "UnauthorizedError",
            '403': "ForbiddenError",
            '404': "ResourceNotFoundError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _dbui_v1_warehouse_start_serialize(
        self,
        workspace,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace is not None:
            _path_params['workspace'] = workspace
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'account_identity'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/apis/dbui/v1/workspaces/{workspace}/warehouse/{id}/start',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


