# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.content_v1_datasource_preset_autoloader import ContentV1DatasourcePresetAutoloader
from dasl_api.models.content_v1_datasource_preset_bronze import ContentV1DatasourcePresetBronze
from dasl_api.models.content_v1_datasource_preset_gold_inner import ContentV1DatasourcePresetGoldInner
from dasl_api.models.content_v1_datasource_preset_silver import ContentV1DatasourcePresetSilver
from dasl_api.models.core_v1_data_source_primary_key_spec import CoreV1DataSourcePrimaryKeySpec
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePreset(BaseModel):
    """
    ContentV1DatasourcePreset
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="The name of the preset. Preset names must be unique and should follow established patterns such as  \"${source}_${sourceType}_${optionalInfo}\". ")
    author: Optional[StrictStr] = Field(default=None, description="The person or organization that authored this preset. ")
    description: Optional[StrictStr] = Field(default=None, description="A description of the preset that will be displayed in the UI. The included content should be a brief and may include information about the preset's purpose, the data it is designed to work with, and any other relevant information. ")
    title: Optional[StrictStr] = Field(default=None, description="A formatted, human-readable title for the preset. This text will be displayed in the UI. ")
    icon_url: Optional[StrictStr] = Field(default=None, description="A URL to an icon representing the preset. This icon will be displayed in the UI. ", alias="iconURL")
    primary_key: Optional[CoreV1DataSourcePrimaryKeySpec] = Field(default=None, description="Configuration used to compute a primary key which will be composed of a timestamp plus hash computed over a set of columns. This primary key will be used for automatic deduplication when re-ingesting raw data and prevents duplicate rows being created. ", alias="primaryKey")
    autoloader: Optional[ContentV1DatasourcePresetAutoloader] = None
    bronze: Optional[ContentV1DatasourcePresetBronze] = None
    silver: Optional[ContentV1DatasourcePresetSilver] = None
    gold: Optional[List[ContentV1DatasourcePresetGoldInner]] = Field(default=None, description="The gold transform configuration for this preset. This configuration will be used to transform the silver data  into the gold OCSF tables. Note that you can have duplicate names for array objects which indicates the same destination table but different source (silver) tables. ")
    version_number: Optional[StrictInt] = Field(default=None, description="The number for this preset version", alias="versionNumber")
    latest_version: Optional[StrictInt] = Field(default=None, description="The latest number for this preset version", alias="latestVersion")
    bronze_event_expr: Optional[StrictStr] = Field(default=None, description="The Spark SQL expression used to determine a row's event class.")
    silver_table_event_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="A mapping of which event classes maps to which silver tables.")
    gold_table_event_mappings: Optional[Dict[str, StrictStr]] = Field(default=None, description="A mapping of which event classes maps to which gold tables.")
    __properties: ClassVar[List[str]] = ["name", "author", "description", "title", "iconURL", "primaryKey", "autoloader", "bronze", "silver", "gold", "versionNumber", "latestVersion", "bronze_event_expr", "silver_table_event_mappings", "gold_table_event_mappings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePreset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of primary_key
        if self.primary_key:
            _dict['primaryKey'] = self.primary_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of autoloader
        if self.autoloader:
            _dict['autoloader'] = self.autoloader.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bronze
        if self.bronze:
            _dict['bronze'] = self.bronze.to_dict()
        # override the default output from pydantic by calling `to_dict()` of silver
        if self.silver:
            _dict['silver'] = self.silver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in gold (list)
        _items = []
        if self.gold:
            for _item_gold in self.gold:
                if _item_gold:
                    _items.append(_item_gold.to_dict())
            _dict['gold'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if icon_url (nullable) is None
        # and model_fields_set contains the field
        if self.icon_url is None and "icon_url" in self.model_fields_set:
            _dict['iconURL'] = None

        # set to None if primary_key (nullable) is None
        # and model_fields_set contains the field
        if self.primary_key is None and "primary_key" in self.model_fields_set:
            _dict['primaryKey'] = None

        # set to None if autoloader (nullable) is None
        # and model_fields_set contains the field
        if self.autoloader is None and "autoloader" in self.model_fields_set:
            _dict['autoloader'] = None

        # set to None if bronze (nullable) is None
        # and model_fields_set contains the field
        if self.bronze is None and "bronze" in self.model_fields_set:
            _dict['bronze'] = None

        # set to None if silver (nullable) is None
        # and model_fields_set contains the field
        if self.silver is None and "silver" in self.model_fields_set:
            _dict['silver'] = None

        # set to None if version_number (nullable) is None
        # and model_fields_set contains the field
        if self.version_number is None and "version_number" in self.model_fields_set:
            _dict['versionNumber'] = None

        # set to None if latest_version (nullable) is None
        # and model_fields_set contains the field
        if self.latest_version is None and "latest_version" in self.model_fields_set:
            _dict['latestVersion'] = None

        # set to None if bronze_event_expr (nullable) is None
        # and model_fields_set contains the field
        if self.bronze_event_expr is None and "bronze_event_expr" in self.model_fields_set:
            _dict['bronze_event_expr'] = None

        # set to None if silver_table_event_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.silver_table_event_mappings is None and "silver_table_event_mappings" in self.model_fields_set:
            _dict['silver_table_event_mappings'] = None

        # set to None if gold_table_event_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.gold_table_event_mappings is None and "gold_table_event_mappings" in self.model_fields_set:
            _dict['gold_table_event_mappings'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePreset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "author": obj.get("author"),
            "description": obj.get("description"),
            "title": obj.get("title"),
            "iconURL": obj.get("iconURL"),
            "primaryKey": CoreV1DataSourcePrimaryKeySpec.from_dict(obj["primaryKey"]) if obj.get("primaryKey") is not None else None,
            "autoloader": ContentV1DatasourcePresetAutoloader.from_dict(obj["autoloader"]) if obj.get("autoloader") is not None else None,
            "bronze": ContentV1DatasourcePresetBronze.from_dict(obj["bronze"]) if obj.get("bronze") is not None else None,
            "silver": ContentV1DatasourcePresetSilver.from_dict(obj["silver"]) if obj.get("silver") is not None else None,
            "gold": [ContentV1DatasourcePresetGoldInner.from_dict(_item) for _item in obj["gold"]] if obj.get("gold") is not None else None,
            "versionNumber": obj.get("versionNumber"),
            "latestVersion": obj.get("latestVersion"),
            "bronze_event_expr": obj.get("bronze_event_expr"),
            "silver_table_event_mappings": obj.get("silver_table_event_mappings"),
            "gold_table_event_mappings": obj.get("gold_table_event_mappings")
        })
        return _obj


