# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePresetBronze(BaseModel):
    """
    ContentV1DatasourcePresetBronze
    """ # noqa: E501
    load_as_single_variant: Optional[StrictBool] = Field(default=None, description="Whether to ingest the data as a single variant column called data (defaults to false if not provided). This disables all schema hints and type inference. Use the preTransform option to extract individual fields into typed columns before writing to the bronze table. Please note that the VARIANT type can only hold records up to 16 MB in size. For more details see: http://docs.databricks.com/aws/en/ingestion/variant#ingest-data-from-cloud-object-storage-as-variant ", alias="loadAsSingleVariant")
    pre_transform: Optional[List[List[StrictStr]]] = Field(default=None, description="A set of SQL expressions to apply before writing the DataFrame ingested by Auto Loader to the bronze table. Use this to unpack, unwrap, or unroll data into individual rows that would otherwise be ingested as a single, highly nested row. When `loadAsSingleVariant` is enabled, use this to extract individual fields from the `data` VARIANT column. This is a nested array: each item in the outer array results in a separate `selectExpr` execution. This allows chaining multiple passes—for example, if the data needs to be unpacked across multiple levels. The inner array contains the actual expressions to include in each `selectExpr`. ", alias="preTransform")
    __properties: ClassVar[List[str]] = ["loadAsSingleVariant", "preTransform"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetBronze from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if load_as_single_variant (nullable) is None
        # and model_fields_set contains the field
        if self.load_as_single_variant is None and "load_as_single_variant" in self.model_fields_set:
            _dict['loadAsSingleVariant'] = None

        # set to None if pre_transform (nullable) is None
        # and model_fields_set contains the field
        if self.pre_transform is None and "pre_transform" in self.model_fields_set:
            _dict['preTransform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetBronze from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "loadAsSingleVariant": obj.get("loadAsSingleVariant"),
            "preTransform": obj.get("preTransform")
        })
        return _obj


