# coding: utf-8

"""
    Antimatter Security Lakehouse Public API

    Interact with the Antimatter ASL API.

    The version of the OpenAPI document: 0.1.26
    Contact: support@antimatter.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dasl_api.models.content_v1_datasource_preset_silver_pre_transform_inner import ContentV1DatasourcePresetSilverPreTransformInner
from dasl_api.models.content_v1_datasource_preset_silver_transform_inner import ContentV1DatasourcePresetSilverTransformInner
from typing import Optional, Set
from typing_extensions import Self

class ContentV1DatasourcePresetSilver(BaseModel):
    """
    ContentV1DatasourcePresetSilver
    """ # noqa: E501
    pre_transform: Optional[List[ContentV1DatasourcePresetSilverPreTransformInner]] = Field(default=None, description="A list of pretransform definitions that will be used in later stages. Each item will include a name of the  pretransform (used for dataframe variable naming) as well as the FieldSpecs that define the column schema.  Other typical properties such as filter, postFilter, and FieldUtils may be included as well. ", alias="preTransform")
    transform: Optional[List[ContentV1DatasourcePresetSilverTransformInner]] = Field(default=None, description="A list of silver transform definitions for data cleaning and processing. Each transformation item will  include the name of the transformation which is used for variable and table naming. Other typical properties  such as filter, postFilter, and FieldUtils may be included as well. ")
    __properties: ClassVar[List[str]] = ["preTransform", "transform"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSilver from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in pre_transform (list)
        _items = []
        if self.pre_transform:
            for _item_pre_transform in self.pre_transform:
                if _item_pre_transform:
                    _items.append(_item_pre_transform.to_dict())
            _dict['preTransform'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transform (list)
        _items = []
        if self.transform:
            for _item_transform in self.transform:
                if _item_transform:
                    _items.append(_item_transform.to_dict())
            _dict['transform'] = _items
        # set to None if pre_transform (nullable) is None
        # and model_fields_set contains the field
        if self.pre_transform is None and "pre_transform" in self.model_fields_set:
            _dict['preTransform'] = None

        # set to None if transform (nullable) is None
        # and model_fields_set contains the field
        if self.transform is None and "transform" in self.model_fields_set:
            _dict['transform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentV1DatasourcePresetSilver from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "preTransform": [ContentV1DatasourcePresetSilverPreTransformInner.from_dict(_item) for _item in obj["preTransform"]] if obj.get("preTransform") is not None else None,
            "transform": [ContentV1DatasourcePresetSilverTransformInner.from_dict(_item) for _item in obj["transform"]] if obj.get("transform") is not None else None
        })
        return _obj


